/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.GalaxMappingSnapshotSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GalaxMappingSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5862047499194345022L;
    private static final Log logger = LogFactory.getInstance(GalaxMappingSnapshotProcessor.class);

    public final boolean execute(RecoveryProcessorContext context) {
        this.setContextRef(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            List recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, CreateSnapshotCopySubProcessor.class);
            this.updateSubProcessors(recoveryProcesses, recoveryPlan);
        } else {
            Map lunAndSnapshotInfos = (Map)context.getAttribute("CreateSnapshotSubProcessors");
            this.updateMappingSnapshotSubProcessors(lunAndSnapshotInfos);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            return this.endRecoveryProcess();
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            logger.error((Object)("can not get the recoveryTemplate, type=" + type.name()), 90160758784001L);
            return false;
        }
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            context.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        GalaxMappingSnapshotSubProcessor preProcessor = (GalaxMappingSnapshotSubProcessor)oldProcess;
        GalaxMappingSnapshotSubProcessor newProcessor = (GalaxMappingSnapshotSubProcessor)newProcess;
        return preProcessor.getLunId().equals(newProcessor.getLunId()) && preProcessor.getDeviceId().equals(newProcessor.getDeviceId()) && preProcessor.getHostOrGroupId().equals(newProcessor.getHostOrGroupId());
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return;
        }
        GalaxMappingSnapshotSubProcessor preProcessor = (GalaxMappingSnapshotSubProcessor)oldProcess;
        GalaxMappingSnapshotSubProcessor newProcessor = (GalaxMappingSnapshotSubProcessor)newProcess;
        this.updateProcessorStatus(preProcessor, newProcessor);
        preProcessor.setSnapshotId(newProcessor.getSnapshotId());
        preProcessor.setSnapshotName(newProcessor.getSnapshotName());
    }

    protected final boolean updateMappingSnapshotSubProcessors(Map<String, String> lunAndSnapshotInfos) {
        if (null == lunAndSnapshotInfos || lunAndSnapshotInfos.isEmpty()) {
            return true;
        }
        Set<RecoveryProcessor> subProcessors = this.createMappingSnapshotSubProcessors(lunAndSnapshotInfos);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        boolean result = ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private boolean updateSubProcessors(Collection<RecoveryProcessor> recoveryProcesses, RecoveryPlan plan) {
        if (VerifyUtil.isEmpty(recoveryProcesses)) {
            return true;
        }
        Set<RecoveryProcessor> subProcessors = this.createMappingSnapshotSubProcessors(recoveryProcesses, plan);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        boolean result = ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected Set<RecoveryProcessor> createMappingSnapshotSubProcessors(Map<String, String> lunAndSnapshotInfos) {
        return null;
    }

    protected Set<RecoveryProcessor> createMappingSnapshotSubProcessors(Collection<RecoveryProcessor> recoveryProcesses, RecoveryPlan plan) {
        return null;
    }

    private void updateProcessorStatus(GalaxMappingSnapshotSubProcessor preProcessor, GalaxMappingSnapshotSubProcessor newProcessor) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == preProcessor.getProcStatus() && null != preProcessor.getSnapshotId() && null != newProcessor.getSnapshotId() && !preProcessor.getSnapshotId().equals(newProcessor.getSnapshotId())) {
            preProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            logger.info((Object)("The snapshot id has been changed. DevSN:" + preProcessor.getDeviceId() + ",LunId:" + preProcessor.getLunId() + ",OldSnapshotId:" + preProcessor.getSnapshotId() + ",NewSnapshotId:" + preProcessor.getSnapshotId()), 90160758784000L);
        }
    }

    private boolean endRecoveryProcess() {
        this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }
}

