/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.VmMappingSnapshotToHostProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.VmDeleteSnapMapFromHostSubProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.VmMappingSnapshotToHostSubProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VmDeleteSnapMapFromHostProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = 6004746007005469566L;
    private static final Log logger = LogFactory.getInstance(VmDeleteSnapMapFromHostProcessor.class);
    private static final long LOG_CODE = -1L;

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"[Delete Mapping Snapshot]Begin to delete mapping snapshot.", 90160758786816L);
        this.setContextRef(context);
        List<RecoveryProcessor> allMappingSnapshotProcessor = this.queryMappingSnapshotsSubProcessor(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
        Set delMappingSnapshotSubProcs = this.getChildProc();
        if (null == delMappingSnapshotSubProcs || delMappingSnapshotSubProcs.isEmpty()) {
            this.updateSubProcessors(allMappingSnapshotProcessor);
            if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
                logger.info((Object)"no snapshot map need delete", -1L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
        } else {
            logger.debug((Object)("getChildProc subprocs:" + delMappingSnapshotSubProcs.size()), -1L);
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            logger.error((Object)"get template error:", -1L);
            return false;
        }
        recoveryTemplate.process(context);
        int successCount = this.countSuccessResult(this.getChildProc());
        logger.debug((Object)("countSuccessResult:" + successCount), -1L);
        return super.calcExcuteResult();
    }

    private List<RecoveryProcessor> queryMappingSnapshotsSubProcessor(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        ArrayList<RecoveryProcessor> procList = new ArrayList<RecoveryProcessor>();
        RecoveryProcessDefinition rpd = plan.getRecoveryProcess(type);
        for (RecoveryProcessor rp : rpd.getRecoveryProcessors()) {
            if (rp.getClass() != VmMappingSnapshotToHostProcessor.class) continue;
            procList.addAll(rp.getChildProc());
            break;
        }
        return procList;
    }

    private boolean updateSubProcessors(List<RecoveryProcessor> allMappingSnapshotProcessor) {
        if (null == allMappingSnapshotProcessor || allMappingSnapshotProcessor.isEmpty()) {
            return true;
        }
        HashSet<VmDeleteSnapMapFromHostSubProcessor> delMappingSnashotSubProcessors = new HashSet<VmDeleteSnapMapFromHostSubProcessor>();
        for (RecoveryProcessor rp : allMappingSnapshotProcessor) {
            if (!(rp instanceof VmMappingSnapshotToHostSubProcessor)) continue;
            VmMappingSnapshotToHostSubProcessor mstp = (VmMappingSnapshotToHostSubProcessor)rp;
            String deviceId = mstp.getDeviceId();
            String lunId = mstp.getLunId();
            String snapshotId = mstp.getSnapshotId();
            String snapshotName = mstp.getSnapshotName();
            String hostMoId = mstp.getHostOrGroupId();
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != mstp.getProcStatus()) continue;
            VmDeleteSnapMapFromHostSubProcessor processor = new VmDeleteSnapMapFromHostSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setTgtDeviceId(deviceId);
            processor.setLunId(lunId);
            processor.setSnapshotId(snapshotId);
            processor.setSnapshotName(snapshotName);
            processor.setHostMoId(hostMoId);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            delMappingSnashotSubProcessors.add(processor);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(delMappingSnashotSubProcessors);
        }
        boolean result = ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private int countSuccessResult(Set<RecoveryProcessor> mappingLunSubProcessors) {
        int successCount = 0;
        for (RecoveryProcessor process : mappingLunSubProcessors) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != process.getProcStatus()) continue;
            ++successCount;
        }
        return successCount;
    }

    public void updateProcessName() {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoverPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        this.setProcName(this.calcProcessName(recoverPlan));
    }

    private String calcProcessName(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            return "com.huawei.ism.drm.galax.storage.recovery.process.VmDeleteSnapMapFromHostProcessor.local";
        }
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCopyMappingProcessor.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotMappingProcessor.des");
        }
    }
}

