/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.process.GalaxMappingSnapshotProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.VmMappingSnapshotToHostSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VmMappingSnapshotToHostProcessor
extends GalaxMappingSnapshotProcessor {
    private static final long serialVersionUID = 8900153777530766347L;
    private static final Log logger = LogFactory.getInstance(VmMappingSnapshotToHostProcessor.class);

    @Override
    protected Set<RecoveryProcessor> createMappingSnapshotSubProcessors(Map<String, String> lunAndSnapshotInfos) {
        logger.info((Object)"begin to createMappingSnapshotSubProcessors.", 90160758786816L);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        Set<Map.Entry<String, String>> entrySet = lunAndSnapshotInfos.entrySet();
        logger.info((Object)("lunAndSnapshotInfos list." + entrySet.toString()), 90160758786816L);
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            logger.info((Object)("lunAndSnapshotInfos key." + key), 90160758786816L);
            logger.info((Object)("lunAndSnapshotInfos value." + entry.getValue()), 90160758786816L);
            String str = null;
            if (key.split(":").length > 1) {
                str = key.split(":")[1];
            }
            if (null == str) {
                logger.error((Object)("str is null, key=" + key), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            String[] strArray = str.split(";");
            String deviceId = null;
            String lunId = null;
            if (strArray.length > 0 && strArray[0].split("=").length > 1) {
                deviceId = strArray[0].split("=")[1];
            }
            if (strArray.length > 1 && strArray[1].split("=").length > 1) {
                lunId = strArray[1].split("=")[1];
            }
            String value = entry.getValue();
            strArray = value.split(";");
            String snapshotId = null;
            String snapshotName = null;
            if (strArray.length > 0) {
                snapshotId = strArray[0];
            }
            if (strArray.length > 1) {
                snapshotName = strArray[1];
            }
            VmMappingSnapshotToHostSubProcessor processor = new VmMappingSnapshotToHostSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(deviceId);
            processor.setLunId(lunId);
            processor.setSnapshotId(snapshotId);
            processor.setSnapshotName(snapshotName);
            processor.setHostOrGroupId(null);
            subProcessors.add((RecoveryProcessor)processor);
            String deviceType = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getStorageType(deviceId);
            IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
            Snapshot paramSnapshot = new Snapshot();
            paramSnapshot.setSnapshotId(snapshotId);
            List snapshots = proxy.getSnapshot(deviceId, paramSnapshot);
            Snapshot ttArraySnapshot = !VerifyUtil.isEmpty((Collection)snapshots) ? (Snapshot)snapshots.get(0) : null;
            if (null != ttArraySnapshot) continue;
            logger.error((Object)("fail to get snapshot:" + snapshotId), 90160758784001L);
        }
        logger.info((Object)"end createMappingSnapshotSubProcessors.", 90160758786816L);
        return subProcessors;
    }

    @Override
    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        logger.info((Object)"begin isSameProcessor.", 90160758786816L);
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        VmMappingSnapshotToHostSubProcessor preProcessor = (VmMappingSnapshotToHostSubProcessor)oldProcess;
        VmMappingSnapshotToHostSubProcessor newProcessor = (VmMappingSnapshotToHostSubProcessor)newProcess;
        return preProcessor.getLunId().equals(newProcessor.getLunId()) && preProcessor.getDeviceId().equals(newProcessor.getDeviceId());
    }

    @Override
    protected Set<RecoveryProcessor> createMappingSnapshotSubProcessors(Collection<RecoveryProcessor> recoveryProcesses, RecoveryPlan plan) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            CreateSnapshotCopySubProcessor copySubProcessor = (CreateSnapshotCopySubProcessor)process;
            VmMappingSnapshotToHostSubProcessor processor = new VmMappingSnapshotToHostSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(copySubProcessor.getDeviceId());
            processor.setLunId(copySubProcessor.getLunId());
            processor.setSnapshotId(copySubProcessor.getSnapshotId());
            processor.setSnapshotName(copySubProcessor.getSnapshotName());
            processor.setHostOrGroupId(this.getHostClusterId(plan));
            subProcessors.add((RecoveryProcessor)processor);
        }
        return subProcessors;
    }

    private String getHostClusterId(RecoveryPlan plan) {
        String cloudSn = ((ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups())).getPoProviderSN();
        String array = FsRecoveryUtil.getGlobalSettingFromPlan((RecoveryPlan)plan, (String)"testHostCluster");
        JSONObject jObject = VrmRecoveryUtil.getMappingSettingFromPlan(array, "srcCloudId", cloudSn);
        return jObject.getString("remoteHostClusterId");
    }

    public void updateProcessName() {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoverPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        this.setProcName(this.calcProcessName(recoverPlan));
    }

    private String calcProcessName(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            return "com.huawei.ism.drm.galax.storage.recovery.process.VmMappingSnapshotToHostProcessor.local";
        }
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.MappingSnapshotCopyProcessor.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.MappingSnapshotProcessor.des");
        }
    }
}

