/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate.DRCreateDsCmdFactory;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopyProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DLCreateDsCmdFactory
extends DRCreateDsCmdFactory {
    private static final Log logger = LogFactory.getInstance(DLCreateDsCmdFactory.class);
    private Map<String, String> mapSnap = new HashMap<String, String>();

    @Override
    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parentRp) {
        RecoveryPlan recPlan = context.getRecoveryPlan();
        if (recPlan.getPlanType() == DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == parentRp.getProcType()) {
            RecoveryPlanProxy planProxy = new RecoveryPlanProxy(recPlan);
            RecoveryProcessor recoveryProcesses = planProxy.getRecoveryProcessByType(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, CreateSnapshotCopyProcessor.class);
            this.updateMapSnap(recoveryProcesses, context);
        } else {
            this.updateMapSnap(context);
        }
        return super.createSubProcessors(context, parentRp);
    }

    private void updateMapSnap(RecoveryProcessorContext context) {
        Map lunAndSnapshotInfos = (Map)context.getAttribute("CreateSnapshotSubProcessors");
        logger.info((Object)"begin to createMappingSnapshotSubProcessors.", 90160758786816L);
        Set entrySet = lunAndSnapshotInfos.entrySet();
        logger.info((Object)("lunAndSnapshotInfos list." + entrySet.toString()), 90160758786816L);
        for (Map.Entry entry : entrySet) {
            try {
                Snapshot ttArraySnapshot;
                String key = (String)entry.getKey();
                logger.info((Object)("lunAndSnapshotInfos key." + key), 90160758786816L);
                logger.info((Object)("lunAndSnapshotInfos value." + (String)entry.getValue()), 90160758786816L);
                String str = null;
                if (key.split(":").length > 1) {
                    str = key.split(":")[1];
                }
                if (null == str) {
                    logger.error((Object)("str is null, key=" + key), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                String[] strArray = str.split(";");
                String deviceId = null;
                String lunId = null;
                if (strArray.length > 0 && strArray[0].split("=").length > 1) {
                    deviceId = strArray[0].split("=")[1];
                }
                if (strArray.length > 1 && strArray[1].split("=").length > 1) {
                    lunId = strArray[1].split("=")[1];
                }
                String value = (String)entry.getValue();
                strArray = value.split(";");
                String snapshotId = null;
                if (strArray.length > 0) {
                    snapshotId = strArray[0];
                }
                Lun lun = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getTargetLunById(deviceId, lunId);
                String deviceType = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getStorageType(deviceId);
                StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
                IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
                Snapshot paramSnapshot = new Snapshot();
                paramSnapshot.setId(snapshotId);
                List snapshots = proxy.getSnapshot(deviceId, paramSnapshot);
                Snapshot snapshot = ttArraySnapshot = !VerifyUtil.isEmpty((Collection)snapshots) ? (Snapshot)snapshots.get(0) : null;
                if (null == ttArraySnapshot) {
                    logger.error((Object)("fail to get snapshot:" + snapshotId), 90160758784001L);
                    continue;
                }
                if (!VerifyUtil.isEmpty((String)ttArraySnapshot.getWwn()) && !ttArraySnapshot.getWwn().equals("--")) {
                    this.mapSnap.put(lun.getWwn(), ttArraySnapshot.getWwn());
                    continue;
                }
                String newSnapshotId = this.buildNewSnapshotId(deviceId, snapshotId);
                this.mapSnap.put(lun.getWwn(), newSnapshotId);
            }
            catch (Exception e) {
                logger.error((Object)("fail to update map snap, Exception" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
        context.setAttribute("mapSnap", this.mapSnap);
    }

    private void updateMapSnap(RecoveryProcessor recoveryProcesses, RecoveryProcessorContext context) {
        if (null == recoveryProcesses) {
            context.setAttribute("mapSnap", this.mapSnap);
            logger.error((Object)"there is no CreateSnapshotCopyProcessor in this plan.", 90160758784001L);
            return;
        }
        Set subProcessors = recoveryProcesses.getChildProc();
        if (VerifyUtil.isEmpty((Collection)subProcessors)) {
            context.setAttribute("mapSnap", this.mapSnap);
            logger.error((Object)"there is no sub process under CreateSnapshotCopyProcessor.", 90160758784001L);
            return;
        }
        for (RecoveryProcessor subProcessor : subProcessors) {
            if (subProcessor instanceof CreateSnapshotCopySubProcessor) {
                CreateSnapshotCopySubProcessor copySubProc = (CreateSnapshotCopySubProcessor)subProcessor;
                Lun lun = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getTargetLunById(copySubProc.getDeviceId(), copySubProc.getLunId());
                String snapWwn = copySubProc.getSnapshotWWN();
                if (!VerifyUtil.isEmpty((String)snapWwn) && !snapWwn.equals("--")) {
                    this.mapSnap.put(lun.getWwn(), snapWwn);
                } else {
                    this.mapSnap.put(lun.getWwn(), this.buildNewSnapshotId(copySubProc.getDeviceId(), copySubProc.getSnapshotId()));
                }
            }
            context.setAttribute("mapSnap", this.mapSnap);
        }
    }

    @Override
    protected String getWwn(String wwn) {
        String snapWwn = this.mapSnap.get(wwn);
        if (null == snapWwn) {
            snapWwn = "";
        }
        return snapWwn;
    }

    @Override
    protected Map<String, String> getLunWwnMap(List<String> wwns) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty(wwns)) {
            return retMap;
        }
        for (String wwn : wwns) {
            String snapWwn = this.mapSnap.get(wwn);
            if (null == snapWwn) continue;
            retMap.put(wwn, snapWwn);
        }
        return retMap;
    }
}

