/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.command.parse.BaseRecoveryCmdResParser;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.process.subprocess.RegisterVmRecoverySubProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.RegisterVmCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.RecoveryCmdResponseParser;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate.DRRegisterVmCmdFactory;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DLRegisterVmCmdFactory
extends DRRegisterVmCmdFactory {
    @Override
    protected RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, ProtectObject po) {
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        Map mapSnap = (Map)context.getAttribute("mapSnap");
        RegisterVmRecoverySubProcessor processor = new RegisterVmRecoverySubProcessor(parrentRp, po);
        VmMgrInfo vmMgr = GalaxProxyFactory.createVmMgrInfo(po);
        RecoveryPlan plan = context.getRecoveryPlan();
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(plan);
        if (!vmMgr.isTemplate()) {
            processor.getExtendParams().put(RpExParamsEnum.STARTUPNUM.getValue(), String.valueOf(rpProxy.getVmStartupOrder(po.getUuid())));
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
            this.updateVmMgrLunInfoForLocal(po, mapSnap, vmMgr);
        } else {
            String recSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
            this.updateVmMgrLunInfo(context, po.getProtectGroup(), mapSnap, vmMgr, recSiteId);
        }
        processor.getExtendParams().put(RpExParamsEnum.VM_TYPE.getValue(), vmMgr.getVmType());
        HashSet<RecoverySetting> poSetting = new HashSet<RecoverySetting>();
        for (RecoverySetting recoverySetting : plan.getRecoverySettings()) {
            if (!po.getUuid().equals(recoverySetting.getOwnerId())) continue;
            poSetting.add(recoverySetting);
        }
        RegisterVmCmd cmd = new RegisterVmCmd(platformInfo, vmMgr, plan.getGlobalSettings(), poSetting, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), plan.getPlanType());
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgr.getVmType());
        RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser((GalaxBaseSubRecoveryProcessor)processor);
        ((BaseRecoveryCmdResParser)parser).getListIgnoreErrorCode().remove("10410006");
        RecoveryProcessTask task = new RecoveryProcessTask(parrentRp.getProcId(), (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
        processor.setExcuteTask((IExecuteTask)task);
        return processor;
    }

    private void updateVmMgrLunInfo(RecoveryProcessorContext context, ProtectGroup pg, Map<String, String> mapSnap, VmMgrInfo vmMgr, String siteId) {
        Set setDsUrns = vmMgr.getMapSrcdsurnToLunId().keySet();
        HashMap mapSrcDsUrnToRecLunWwn = new HashMap();
        for (String dsUrn : setDsUrns) {
            HashMap<String, String> wwnMap;
            List<StorageResource> tgtLunList = VrmRecoveryUtil.getTgtResources(context, pg, dsUrn, siteId, wwnMap = new HashMap<String, String>());
            if (VerifyUtil.isEmpty(tgtLunList) || null == mapSnap) continue;
            ArrayList<Object> wwns = new ArrayList<Object>();
            StorageResource resource = (StorageResource)CommonUtil.getFirstElement(tgtLunList);
            if (null != resource && DrmEnumDefine.ResourceTypeE.NAS.getValue() == resource.getResourceType().intValue()) {
                wwns.addAll(wwnMap.values());
            } else {
                for (StorageResource tgLun : tgtLunList) {
                    wwns.add(mapSnap.get(((Lun)tgLun).getWwn()));
                }
            }
            mapSrcDsUrnToRecLunWwn.put(dsUrn, wwns);
        }
        vmMgr.setMapSrcdsurnToLunId(mapSrcDsUrnToRecLunWwn);
    }

    private void updateVmMgrLunInfoForLocal(ProtectObject po, Map<String, String> mapSnap, VmMgrInfo vmMgr) {
        Set setDsUrns = vmMgr.getMapSrcdsurnToLunId().keySet();
        HashMap mapSrcDsUrnToRecLunWwn = new HashMap();
        for (String dsUrn : setDsUrns) {
            List<String> lunWwnList = VrmRecoveryUtil.getLunWwnsByDs(po, dsUrn);
            if (null == lunWwnList || null == mapSnap) continue;
            ArrayList<String> wwns = new ArrayList<String>();
            for (String lunWwn : lunWwnList) {
                wwns.add(mapSnap.get(lunWwn));
            }
            mapSrcDsUrnToRecLunWwn.put(dsUrn, wwns);
        }
        vmMgr.setMapSrcdsurnToLunId(mapSrcDsUrnToRecLunWwn);
    }
}

