/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.DsRpParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.DataChannel;
import com.huawei.ism.drm.galax.sdk.vrm.model.StorageResourceMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.StorageUnitMsgsData;
import com.huawei.ism.drm.galax.storage.entity.DsMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.HostMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.CreateDsCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.ScanHyperVCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.RecoveryCmdResponseParser;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.CreateDataStoreSubProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.ScanHyperVResSubProcessor;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DRCreateDsCmdFactory
extends AbstractCmdSubProcessorFactory {
    protected static final String SNAPSHOT = "SNAPSHOTID_";
    protected static final String SEPERATE = "_";
    private static final Log logger = LogFactory.getInstance(DRCreateDsCmdFactory.class);
    private static final int MAX_LENGTH_DSNAME = 64;
    private static final String DS_NAME_KEY = "_WWN_";

    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parentRp) {
        List<RecoveryProcessor> fmScanProcessors;
        super.createSubProcessors(context, parentRp);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        RecoveryPlan plan = context.getRecoveryPlan();
        Map mapSnap = (Map)context.getAttribute("mapSnap");
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
            this.generateSubProcessorsForLocal(context, parentRp, subProcessors);
        } else {
            this.generateSubProcessorsForReplication(context, parentRp, subProcessors);
        }
        if (null != mapSnap) {
            context.setAttribute("mapSnap", (Object)mapSnap);
        }
        if (!VerifyUtil.isEmpty(subProcessors) && !VerifyUtil.isEmpty(fmScanProcessors = this.createFmScanProcessor(context, parentRp))) {
            subProcessors.addAll(fmScanProcessors);
        }
        return subProcessors;
    }

    private void generateSubProcessorsForLocal(RecoveryProcessorContext context, RecoveryProcessor parentRp, Set<RecoveryProcessor> subProcessors) {
        RecoveryPlan plan = context.getRecoveryPlan();
        ProtectGroup pg = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(context);
        PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(pg);
        String recVrmSn = this.isRollBack(parentRp) ? VrmRecoveryUtil.getVrmSnByPgForLocalRollback(plan) : VrmRecoveryUtil.getVrmSnByPgForLocalTest(plan);
        for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
            DsMgrInfo dsMgr = (DsMgrInfo)dsMgrInfo;
            List<HostMgrInfo> hosts = this.isRollBack(parentRp) ? VrmRecoveryUtil.queryRollBackHostMgrInfo(dsMgr.getHosts()) : VrmRecoveryUtil.queryLocalTestHostMgrInfo(plan, dsMgr.getHosts());
            for (HostMgrInfo host : hosts) {
                String primaryLunWwn = this.getWwn(dsMgr.getPrimaryLunWwn());
                String dsNewName = this.isRollBack(parentRp) ? dsMgrInfo.getDsName() : this.generateDsName(dsMgrInfo.getDsName(), primaryLunWwn);
                CreateDataStoreSubProcessor processor = new CreateDataStoreSubProcessor(parentRp, host, primaryLunWwn, dsNewName);
                String dsUnitUrn = this.getLunUrn(primaryLunWwn, host, new HashMap<String, String>());
                if (VerifyUtil.isEmpty((String)dsUnitUrn)) {
                    logger.info((Object)("Failed to get store unit urn, primaryLunWwn:" + primaryLunWwn), 90160758786816L);
                    continue;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                logger.debug((Object)"query ds StorageType: %s", new Object[]{dsMgrInfo.getStorageType()});
                params.put(DsRpParamsEnum.DS_TYPE.getValue(), dsMgrInfo.getStorageType());
                params.put(DsRpParamsEnum.DS_NAME.getValue(), dsNewName);
                params.put(DsRpParamsEnum.HOST_URN.getValue(), host.getHostUrn());
                params.put(DsRpParamsEnum.LUN_URN.getValue(), dsUnitUrn);
                params.put(DsRpParamsEnum.LUN_WWN_MAP.getValue(), this.getLunWwnMap(dsMgrInfo.getWwns()));
                IExecuteTask task = this.generateExcuteTask(context, processor, params, recVrmSn, parentRp.getProcId());
                processor.setExcuteTask(task);
                subProcessors.add((RecoveryProcessor)processor);
            }
        }
    }

    private void generateSubProcessorsForReplication(RecoveryProcessorContext context, RecoveryProcessor parentRp, Set<RecoveryProcessor> subProcessors) {
        RecoveryPlan plan = context.getRecoveryPlan();
        ProtectGroup pg = context.getProtectGroup();
        PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(pg);
        String productSiteId = null == context.getAttribute("PRODUCT_SITE_ID") ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
        String recoverySiteId = null == context.getAttribute("SELECT_DISASTER_SITE_KEY") ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
        String recVrmSn = FsRecoveryUtil.getVrmSnByPg((ProtectGroup)pg, (boolean)false, (String)productSiteId, (String)recoverySiteId);
        String recSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
            HashMap<String, String> wwnMap = new HashMap<String, String>();
            DsMgrInfo dsMgr = (DsMgrInfo)dsMgrInfo;
            List<StorageResource> storageResources = VrmRecoveryUtil.getTgtResources(context, pg, dsMgrInfo.getDsUrn(), recSiteId, wwnMap);
            if (VerifyUtil.isEmpty(storageResources)) continue;
            HashMap<String, String> shanshotMap = new HashMap<String, String>();
            for (Map.Entry entity : wwnMap.entrySet()) {
                shanshotMap.put((String)entity.getKey(), this.getWwn((String)entity.getValue()));
            }
            String primaryLunWwnOfRS = (String)shanshotMap.get(dsMgr.getPrimaryLunWwn());
            Map<String, String> snapshotIdToWwn = this.getSnapshotIdToWwn(shanshotMap, primaryLunWwnOfRS);
            List<HostMgrInfo> hosts = dsMgr.queryRecoveryHostMgrInfo(productSiteId, recoverySiteId);
            for (HostMgrInfo host : hosts) {
                String primaryLunUrnOfRs = this.getLunUrn(primaryLunWwnOfRS, host, snapshotIdToWwn);
                if (VerifyUtil.isEmpty((String)primaryLunUrnOfRs)) {
                    logger.info((Object)("Failed to get lunUrn, slaveLunWwns:" + storageResources.toString()), 90160758786816L);
                    continue;
                }
                this.replaceValueOfWwnMap(shanshotMap, snapshotIdToWwn);
                String dsNewName = this.generateDsName(dsMgrInfo.getDsName(), primaryLunWwnOfRS);
                CreateDataStoreSubProcessor processor = new CreateDataStoreSubProcessor(parentRp, host, primaryLunWwnOfRS, dsNewName);
                HashMap<String, Object> params = new HashMap<String, Object>();
                logger.debug((Object)"qurey storageType: %s", new Object[]{dsMgrInfo.getStorageType()});
                params.put(DsRpParamsEnum.DS_TYPE.getValue(), dsMgrInfo.getStorageType());
                params.put(DsRpParamsEnum.DS_NAME.getValue(), dsNewName);
                params.put(DsRpParamsEnum.HOST_URN.getValue(), host.getHostUrn());
                params.put(DsRpParamsEnum.LUN_URN.getValue(), primaryLunUrnOfRs);
                params.put(DsRpParamsEnum.LUN_WWN_MAP.getValue(), shanshotMap);
                params.put(DsRpParamsEnum.DS_CONFIDENTIALITY_LEVEL.getValue(), dsMgrInfo.getConfidentialityLevel());
                IExecuteTask task = this.generateExcuteTask(context, processor, params, recVrmSn, parentRp.getProcId());
                processor.setExcuteTask(task);
                subProcessors.add((RecoveryProcessor)processor);
            }
        }
    }

    protected Map<String, String> getLunWwnMap(List<String> wwns) {
        return new HashMap<String, String>();
    }

    private Map<String, String> getSnapshotIdToWwn(Map<String, String> wwnMap, String primaryLunWwnOfRecoverySite) {
        HashMap<String, String> snapShotIdToWwn = new HashMap<String, String>();
        if (null == primaryLunWwnOfRecoverySite || !primaryLunWwnOfRecoverySite.contains(SNAPSHOT) || null == wwnMap) {
            return snapShotIdToWwn;
        }
        for (String value : wwnMap.values()) {
            if (null == value) continue;
            snapShotIdToWwn.put(value, null);
        }
        return snapShotIdToWwn;
    }

    private void replaceValueOfWwnMap(Map<String, String> wwnMap, Map<String, String> snapshotIdToWwn) {
        if (VerifyUtil.isEmpty(snapshotIdToWwn) || VerifyUtil.isEmpty(wwnMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : wwnMap.entrySet()) {
            String snapShotId = entry.getValue();
            if (!snapshotIdToWwn.containsKey(snapShotId)) continue;
            entry.setValue(snapshotIdToWwn.get(snapShotId));
        }
    }

    private String generateDsName(String dsOldName, String wwn) {
        if (null != dsOldName && dsOldName.contains(DS_NAME_KEY)) {
            dsOldName = dsOldName.substring(0, dsOldName.indexOf(DS_NAME_KEY));
        }
        if (null != dsOldName && dsOldName.length() > 64) {
            dsOldName = dsOldName.substring(64);
        }
        String dsNewName = dsOldName + DS_NAME_KEY + wwn;
        return dsNewName;
    }

    protected String getWwn(String wwn) {
        return wwn;
    }

    protected String buildNewSnapshotId(String deviceId, String snapshotId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SNAPSHOT).append(deviceId).append(SEPERATE).append(snapshotId);
        return buffer.toString();
    }

    private IExecuteTask generateExcuteTask(RecoveryProcessorContext context, GalaxBaseSubRecoveryProcessor processor, Map<String, Object> params, String vrmSn, String proId) {
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        CreateDsCmd cmd = new CreateDsCmd(platformInfo.getRecSiteId(), vrmSn, params);
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), vrmSn, GalaxVM.VMProviderType.FC.getValue());
        RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser(processor);
        RecoveryProcessTask task = new RecoveryProcessTask(proId, (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
        return task;
    }

    private String getLunUrn(String primaryLunWwnOfRS, HostMgrInfo host, Map<String, String> snapshotIdToWwn) {
        List<StorageUnitMsgsData> storageUnits = host.queryStorageUnit();
        List<StorageResourceMsgsData> storageResourceMsgsDatas = host.queryStorageResource();
        if (null == primaryLunWwnOfRS || VerifyUtil.isEmpty(storageUnits)) {
            return null;
        }
        String lunUrn = null;
        for (StorageUnitMsgsData sumd : storageUnits) {
            if (primaryLunWwnOfRS.contains(SNAPSHOT)) {
                if (VerifyUtil.isEmpty((String)sumd.getSuLunID()) || VerifyUtil.isEmpty((String)sumd.getSanSN())) continue;
                String lunId = sumd.getSuLunID().replaceAll("^0{1,}", "");
                String newSnapshotId = this.buildNewSnapshotId(sumd.getSanSN(), lunId);
                if (snapshotIdToWwn.containsKey(newSnapshotId) && !VerifyUtil.isEmpty((String)sumd.getWwn())) {
                    snapshotIdToWwn.put(newSnapshotId, sumd.getWwn());
                }
                if (!primaryLunWwnOfRS.equals(newSnapshotId)) continue;
                lunUrn = sumd.getUrn();
                continue;
            }
            if (primaryLunWwnOfRS.equals(sumd.getWwn())) {
                lunUrn = sumd.getUrn();
                break;
            }
            if (primaryLunWwnOfRS.split(":").length != 2 || VerifyUtil.isEmpty((String)(lunUrn = this.getNasDsUrnByStorageResource(sumd, storageResourceMsgsDatas, primaryLunWwnOfRS)))) continue;
            return lunUrn;
        }
        return lunUrn;
    }

    private String getNasDsUrnByStorageResource(StorageUnitMsgsData sumd, List<StorageResourceMsgsData> storageResourceMsgsDatas, String primaryLunWwnOfRS) {
        String urn = null;
        for (StorageResourceMsgsData storageResource : storageResourceMsgsDatas) {
            if (VerifyUtil.isEmpty((String)sumd.getSdName()) || !sumd.getSdName().equals(storageResource.getName())) continue;
            String ip = ((DataChannel)storageResource.getDataChannel().get(0)).getIp();
            String dsIp = primaryLunWwnOfRS.split(":")[0];
            String dsName = primaryLunWwnOfRS.split(":")[1];
            if (!ip.equals(dsIp) || !dsName.equals(sumd.getName())) continue;
            urn = sumd.getUrn();
            break;
        }
        return urn;
    }

    private List<RecoveryProcessor> createFmScanProcessor(RecoveryProcessorContext context, RecoveryProcessor parentRp) {
        ArrayList<RecoveryProcessor> fmScanSbuProcessors = new ArrayList<RecoveryProcessor>();
        RecoveryPlan plan = context.getRecoveryPlan();
        Set pgs = this.getPgs(context);
        ArrayList<String> scanedFcs = new ArrayList<String>();
        for (ProtectGroup pg : pgs) {
            String cloudSn;
            Hypervisor hyperV;
            if (((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).isVrmSn(pg.getPoProviderSN())) continue;
            String productSiteId = null == context.getAttribute("PRODUCT_SITE_ID") ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
            String recoverySiteId = null == context.getAttribute("SELECT_DISASTER_SITE_KEY") ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
            String vrmSn = FsRecoveryUtil.getVrmSnByPg((ProtectGroup)pg, (boolean)false, (String)productSiteId, (String)recoverySiteId);
            if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
                String string = vrmSn = this.isRollBack(parentRp) ? VrmRecoveryUtil.getVrmSnByPgForLocalRollback(plan) : VrmRecoveryUtil.getVrmSnByPgForLocalTest(plan);
            }
            if (null == (hyperV = ((IFmService)ServiceLocator.getInstance().getService(IFmService.class)).getHypervisorByVrm(vrmSn))) {
                logger.warn((Object)("Failed to get hyperV,and vrmSn is:" + vrmSn), 90160758786816L);
                continue;
            }
            String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
            FusionManager fm = ((IFmService)ServiceLocator.getInstance().getService(IFmService.class)).getDependenceFmByVrm(vrmSn);
            if (null == fm || scanedFcs.contains(cloudSn = fm.getSn())) continue;
            ScanHyperVResSubProcessor processor = new ScanHyperVResSubProcessor(parentRp, fm.getName(), cloudSn + hypervisorId);
            String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
            QueryResultCmd queryCmd = new QueryResultCmd(disasterSiteId, cloudSn, GalaxVM.VMProviderType.FM.getValue());
            ScanHyperVCmd cmd = new ScanHyperVCmd(disasterSiteId, cloudSn, hypervisorId);
            RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser(processor);
            RecoveryProcessTask task = new RecoveryProcessTask(parentRp.getProcId(), (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
            processor.setExcuteTask((IExecuteTask)task);
            fmScanSbuProcessors.add((RecoveryProcessor)processor);
            scanedFcs.add(cloudSn);
        }
        return fmScanSbuProcessors;
    }
}

