/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.command.parse.BaseRecoveryCmdResParser;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.process.subprocess.RegisterVmRecoverySubProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.RegisterVmCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.RecoveryCmdResponseParser;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DRRegisterVmCmdFactory
extends AbstractCmdSubProcessorFactory {
    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parrentRp) {
        if (context.getRecoveryPlan().getPlanType() == DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue()) {
            return this.getSubProcessorsFromReplica(context, parrentRp);
        }
        return super.createSubProcessors(context, parrentRp);
    }

    protected RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, ProtectObject po) {
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        RegisterVmRecoverySubProcessor processor = new RegisterVmRecoverySubProcessor(parrentRp, po);
        VmMgrInfo vmMgr = GalaxProxyFactory.createVmMgrInfo(po);
        RecoveryPlan plan = context.getRecoveryPlan();
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(plan);
        if (!vmMgr.isTemplate()) {
            processor.getExtendParams().put(RpExParamsEnum.STARTUPNUM.getValue(), String.valueOf(rpProxy.getVmStartupOrder(po.getUuid())));
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
            this.updateVmMgrLunInfoForLocal(po, vmMgr);
        } else {
            String recSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
            this.updateVmMgrLunInfo(context, po.getProtectGroup(), vmMgr, recSiteId);
        }
        HashSet<RecoverySetting> poSetting = new HashSet<RecoverySetting>();
        for (RecoverySetting recoverySetting : plan.getRecoverySettings()) {
            if (!po.getUuid().equals(recoverySetting.getOwnerId())) continue;
            poSetting.add(recoverySetting);
        }
        RegisterVmCmd.RegisterVmCmdBuilder builder = new RegisterVmCmd.RegisterVmCmdBuilder();
        RegisterVmCmd cmd = builder.platformInfo(platformInfo).vmMgrInfo(vmMgr).globalSetting(plan.getGlobalSettings()).recoverySetting(poSetting).procType(processor.getProcType()).planType(plan.getPlanType()).po(po).build();
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgr.getVmType());
        RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser((GalaxBaseSubRecoveryProcessor)processor);
        ((BaseRecoveryCmdResParser)parser).getListIgnoreErrorCode().remove("10410006");
        RecoveryProcessTask task = new RecoveryProcessTask(parrentRp.getProcId(), (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
        processor.setExcuteTask((IExecuteTask)task);
        return processor;
    }

    private void updateVmMgrLunInfo(RecoveryProcessorContext context, ProtectGroup pg, VmMgrInfo vmMgr, String recSiteId) {
        HashMap mapSrcDsUrnToRecLunWwns = new HashMap();
        Set setDsUrns = vmMgr.getMapSrcdsurnToLunId().keySet();
        for (String dsUrn : setDsUrns) {
            HashMap<String, String> wwnMap;
            List<StorageResource> storageResources = VrmRecoveryUtil.getTgtResources(context, pg, dsUrn, recSiteId, wwnMap = new HashMap<String, String>());
            if (VerifyUtil.isEmpty(storageResources)) continue;
            ArrayList wwns = new ArrayList();
            wwns.addAll(wwnMap.values());
            mapSrcDsUrnToRecLunWwns.put(dsUrn, wwns);
        }
        vmMgr.setMapSrcdsurnToLunId(mapSrcDsUrnToRecLunWwns);
    }

    private void updateVmMgrLunInfoForLocal(ProtectObject po, VmMgrInfo vmMgr) {
        HashMap mapSrcDsUrnToRecLunWwns = new HashMap();
        Set setDsUrns = vmMgr.getMapSrcdsurnToLunId().keySet();
        for (String dsUrn : setDsUrns) {
            List<String> luns = VrmRecoveryUtil.getLunWwnsByDs(po, dsUrn);
            ArrayList<String> wwns = new ArrayList<String>();
            if (VerifyUtil.isEmpty(luns)) continue;
            wwns.addAll(luns);
            mapSrcDsUrnToRecLunWwns.put(dsUrn, wwns);
        }
        vmMgr.setMapSrcdsurnToLunId(mapSrcDsUrnToRecLunWwns);
    }
}

