/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.HostToPowerOn;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.PowerOnHostCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.QueryHostStatusCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.RecoveryCmdResponseParser;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.PowerOnHostSubProcessor;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PowerOnHostCmdFactory
extends AbstractCmdSubProcessorFactory {
    private static final Log log = LogFactory.getInstance(PowerOnHostCmdFactory.class);

    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parentRp) {
        super.createSubProcessors(context, parentRp);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (!VerifyUtil.isEmpty((Map)recoveryPlan.getGlobalSettings()) && !VerifyUtil.isEmpty((String)((String)recoveryPlan.getGlobalSettings().get("PoweronHost")))) {
            String poweronHostsSetting = (String)recoveryPlan.getGlobalSettings().get("PoweronHost");
            if (VerifyUtil.isEmpty((String)poweronHostsSetting)) {
                return subProcessors;
            }
            List hostList = (List)CommonUtil.json2Bean((String)poweronHostsSetting, HostToPowerOn[].class);
            if (VerifyUtil.isEmpty((Collection)hostList)) {
                return subProcessors;
            }
            for (HostToPowerOn host : hostList) {
                RecoveryProcessor rp = this.generateSubProcessor(context, parentRp, host);
                if (null == rp) continue;
                subProcessors.add(rp);
            }
        }
        return subProcessors;
    }

    private RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parentRp, HostToPowerOn host) {
        ComputeNode cna = (ComputeNode)CommonDAOLocator.getMoDao().getMo(ComputeNode.class, "urn", (Object)host.getUrn());
        if (VerifyUtil.isEmpty((Object)cna)) {
            log.info((Object)("PoweronHost is not exist. hostUrn=" + host.getUrn()), 90160758786816L);
            return null;
        }
        VRM vrm = (VRM)CommonDAOLocator.getMoDao().getMo(VRM.class, "moId", (Object)cna.getParentId());
        if (VerifyUtil.isEmpty((Object)vrm)) {
            log.error((Object)("VRM is not exist. vrm=" + cna.getParentId()), 90160758787071L);
            return null;
        }
        PowerOnHostSubProcessor processor = new PowerOnHostSubProcessor(parentRp, host.getUri());
        processor.getExtendParams().put(RpExParamsEnum.SHOWPARAM.getValue(), cna.getName());
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        PowerOnHostCmd cmd = new PowerOnHostCmd(platformInfo.getRecSiteId(), vrm.getSn(), host.getUri());
        QueryHostStatusCmd queryCmd = new QueryHostStatusCmd(platformInfo.getRecSiteId(), vrm.getSn(), host.getUri());
        RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser(processor, new ArrayList<String>());
        RecoveryProcessTask task = new RecoveryProcessTask(parentRp.getProcId(), (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
        processor.setExcuteTask((IExecuteTask)task);
        return processor;
    }
}

