/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.DsRpParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.storage.entity.DsMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.HostMgrInfo;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.recovery.command.impl.ScanDsCmd;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.RecoveryCmdResponseParser;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.process.ScanningStorageUnitProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.ScanningStorageUnitSubProcessor;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScanDsCmdFactory
extends AbstractCmdSubProcessorFactory {
    private static final Log log = LogFactory.getInstance(ScanDsCmdFactory.class);

    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parentRp) {
        super.createSubProcessors(context, parentRp);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        log.info((Object)("current procType is " + parentRp.getProcType()), 90160758786816L);
        if (parentRp.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()) {
            RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(recoveryPlan);
            RecoveryProcessor scanSuRp = rpProxy.getRecoveryProcessByType(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, ScanningStorageUnitProcessor.class);
            if (null == scanSuRp) {
                return subProcessors;
            }
            Set scanSuProcessors = scanSuRp.getChildProc();
            if (null == scanSuProcessors) {
                return subProcessors;
            }
            for (RecoveryProcessor process : scanSuProcessors) {
                GalaxBaseSubRecoveryProcessor scanSu = (GalaxBaseSubRecoveryProcessor)process;
                String hostUrn = (String)scanSu.getExtendParams().get(DsRpParamsEnum.HOST_URN.getValue());
                String hostIp = (String)scanSu.getExtendParams().get(DsRpParamsEnum.HOST_IP.getValue());
                String recoveryFcSn = (String)scanSu.getExtendParams().get(DsRpParamsEnum.FC_SN.getValue());
                RecoveryProcessor processor = this.generateSubProcessor(context, parentRp, hostUrn, hostIp, recoveryFcSn);
                subProcessors.add(processor);
            }
        } else {
            this.generateSubProcessors(context, subProcessors, parentRp);
        }
        return subProcessors;
    }

    protected RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, ProtectObject po) {
        return null;
    }

    private void generateSubProcessors(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessors, RecoveryProcessor parentRp) {
        Set pgs = this.getPgs(context);
        RecoveryPlan plan = context.getRecoveryPlan();
        HashSet<HostMgrInfo> hosts = new HashSet<HostMgrInfo>();
        String recVrmSn = null;
        for (ProtectGroup pg : pgs) {
            PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(pg);
            if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
                for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
                    DsMgrInfo dsMgr = (DsMgrInfo)dsMgrInfo;
                    List<HostMgrInfo> tempHosts = this.isRollBack(parentRp) ? VrmRecoveryUtil.queryRollBackHostMgrInfo(dsMgr.getHosts()) : VrmRecoveryUtil.queryLocalTestHostMgrInfo(plan, dsMgr.getHosts());
                    hosts.addAll(tempHosts);
                }
                recVrmSn = this.isRollBack(parentRp) ? VrmRecoveryUtil.getVrmSnByPgForLocalRollback(plan) : VrmRecoveryUtil.getVrmSnByPgForLocalTest(plan);
                continue;
            }
            String productSiteId = null == context.getAttribute("PRODUCT_SITE_ID") ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
            String recoverySiteId = null == context.getAttribute("SELECT_DISASTER_SITE_KEY") ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
            for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
                DsMgrInfo dsMgr = (DsMgrInfo)dsMgrInfo;
                List<HostMgrInfo> tempHosts = dsMgr.queryRecoveryHostMgrInfo(productSiteId, recoverySiteId);
                hosts.addAll(tempHosts);
            }
            recVrmSn = FsRecoveryUtil.getVrmSnByPg((ProtectGroup)pg, (boolean)false, (String)productSiteId, (String)recoverySiteId);
        }
        for (HostMgrInfo host : hosts) {
            RecoveryProcessor processor = this.generateSubProcessor(context, parentRp, host.getHostUrn(), host.getHostIp(), recVrmSn);
            subProcessors.add(processor);
        }
    }

    private RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parentRp, String hostUrn, String hostIp, String recoveryFcSn) {
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        ScanDsCmd cmd = new ScanDsCmd(platformInfo.getRecSiteId(), recoveryFcSn, hostUrn);
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), recoveryFcSn, GalaxVM.VMProviderType.FC.getValue());
        ScanningStorageUnitSubProcessor processor = new ScanningStorageUnitSubProcessor(parentRp, recoveryFcSn + hostUrn, hostIp);
        processor.getExtendParams().put(DsRpParamsEnum.HOST_URN.getValue(), hostUrn);
        processor.getExtendParams().put(DsRpParamsEnum.FC_SN.getValue(), recoveryFcSn);
        RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser(processor);
        RecoveryProcessTask task = new RecoveryProcessTask(parentRp.getProcId(), (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
        processor.setExcuteTask((IExecuteTask)task);
        return processor;
    }
}

