/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.factory.impl.operate;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.RegisterVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.command.impl.StartVmCmd;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.process.subprocess.StartVmRecoverySubProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.RecoveryCmdResponseParser;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Set;

public class StartVmCmdFactory
extends AbstractCmdSubProcessorFactory {
    private static final Log log = LogFactory.getInstance(StartVmCmdFactory.class);

    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parrentRp) {
        Set subProcessors = super.createSubProcessors(context, parrentRp);
        if (context.getRecoveryPlan().getPlanType() == DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue()) {
            subProcessors = this.getSubProcessorsFromReplica(context, parrentRp);
        }
        return subProcessors;
    }

    protected RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, ProtectObject po) {
        ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
        VmMgrInfo vmMgrInfo = poProxy.getPoMgrInfo();
        if (vmMgrInfo.isTemplate()) {
            log.info((Object)("po type is template, don't need to be started " + po.getName()), 90160758786816L);
            return null;
        }
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(context.getRecoveryPlan());
        if (!rpProxy.isPoStartUp(po.getUuid())) {
            log.info((Object)("po was set to not start, don't need to be started " + po.getName()), 90160758786816L);
            return null;
        }
        StartVmRecoverySubProcessor processor = new StartVmRecoverySubProcessor(parrentRp, po);
        String startUpNum = String.valueOf(rpProxy.getVmStartupOrder(po.getUuid()));
        RecoveryProcessor registerVMProcess = this.getRegisterVMProcessor(parrentRp.getPreviousProcessor());
        String vmKey = this.getVmUriOrId(registerVMProcess, po.getUuid());
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        VmMgrInfo vmMgr = GalaxProxyFactory.createVmMgrInfo(po);
        vmMgr.setVmUriOrId(vmKey);
        processor.getExtendParams().put(RpExParamsEnum.STARTUPNUM.getValue(), startUpNum);
        processor.getExtendParams().put(RpExParamsEnum.VM_URIORID.getValue(), vmKey);
        StartVmCmd cmd = new StartVmCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), (VmMgrInfoBase)vmMgr);
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgr.getVmType());
        RecoveryCmdResponseParser parser = new RecoveryCmdResponseParser((GalaxBaseSubRecoveryProcessor)processor);
        RecoveryProcessTask task = new RecoveryProcessTask(parrentRp.getProcId(), (IRecoveryCommand)cmd, (IRecoveryCommand)queryCmd, (ICmdResponseParser)parser);
        processor.setExcuteTask((IExecuteTask)task);
        return processor;
    }

    private String getVmUriOrId(RecoveryProcessor registerVMProcessor, String poId) {
        GalaxBaseSubRecoveryProcessor process = this.getRegisterRecoveryProcess(registerVMProcessor, poId);
        if (null == process) {
            return null;
        }
        return (String)process.getExtendParams().get(RpExParamsEnum.VM_URIORID.getValue());
    }

    private GalaxBaseSubRecoveryProcessor getRegisterRecoveryProcess(RecoveryProcessor registerVMProcessor, String poId) {
        for (RecoveryProcessor process : registerVMProcessor.getChildProc()) {
            GalaxBaseSubRecoveryProcessor processor = (GalaxBaseSubRecoveryProcessor)process;
            if (!poId.equals(processor.getGalaxId())) continue;
            return (GalaxBaseSubRecoveryProcessor)process;
        }
        return null;
    }

    private RecoveryProcessor getRegisterVMProcessor(RecoveryProcessor currentRP) {
        if (currentRP instanceof RegisterVmRecoveryProcessor) {
            return currentRP;
        }
        return this.getRegisterVMProcessor(currentRP.getPreviousProcessor());
    }
}

