/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.excuter.ProcessConcurrentExcuter;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.DeleteDataStoreProcessor;
import com.huawei.ism.drm.galax.storage.recovery.process.DeleteVmRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;

public class CleanProductSiteProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = 7761436529587994615L;
    private static final Log logger = LogFactory.getInstance(CleanProductSiteProcessor.class);

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        return oldProcess.getClass() == newProcess.getClass();
    }

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Ready to clean pro siteveryPlan:%s.", new Object[]{context.getRecoveryPlan().getName()});
        this.setContextRef(context);
        this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"There is no sub processor need to be created.");
            return this.endRecoveryProcessWithoutProcessor("ism.drm.recovery.process.no.need", true);
        }
        ProcessConcurrentExcuter excuter = new ProcessConcurrentExcuter(context, (RecoveryProcessor)this);
        excuter.excuteProcessorTemplate();
        logger.info((Object)"Complete the process of reprotection, recoveryPlan is:%s.", new Object[]{context.getRecoveryPlan().getName()});
        return this.calcReProtectExcuteResult();
    }

    private boolean calcReProtectExcuteResult() {
        for (RecoveryProcessor rp : this.getChildProc()) {
            int status = rp.getProcStatus();
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != status && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != status) continue;
            this.setProcStatus(status);
            this.updateProcessDetail("ism.drm.recovery.reprotect.manual.clean", new String[0]);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void updateSubProcessors(RecoveryProcessorContext context) {
        if (!this.isNeedCleanProSide(context)) {
            return;
        }
        DeleteVmRecoveryProcessor deleteVmProcessor = new DeleteVmRecoveryProcessor();
        deleteVmProcessor.setProcName(deleteVmProcessor.getName());
        deleteVmProcessor.setProcType(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue());
        deleteVmProcessor.setPlanId(this.getPlanId());
        deleteVmProcessor.setParentProc((RecoveryProcessor)this);
        deleteVmProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        HashSet<GalaxBaseRecoveryProcessor> subProcessors = new HashSet<GalaxBaseRecoveryProcessor>();
        subProcessors.add(deleteVmProcessor);
        if (context.getProtectGroup().getTemplate().getType() == 33 || context.getProtectGroup().getTemplate().getType() == 39) {
            logger.info((Object)"No need deleteDataStore.");
        } else {
            DeleteDataStoreProcessor deleteDataStoreProcessor = new DeleteDataStoreProcessor();
            deleteDataStoreProcessor.setProcName(deleteDataStoreProcessor.getName());
            deleteDataStoreProcessor.setProcType(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue());
            deleteDataStoreProcessor.setPlanId(this.getPlanId());
            deleteDataStoreProcessor.setParentProc((RecoveryProcessor)this);
            deleteDataStoreProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessors.add(deleteDataStoreProcessor);
            deleteVmProcessor.setNextProcessor((RecoveryProcessor)deleteDataStoreProcessor);
            deleteDataStoreProcessor.setPreviousProcessor((RecoveryProcessor)deleteVmProcessor);
        }
        this.saveProcessors(subProcessors);
    }

    private boolean isNeedCleanProSide(RecoveryProcessorContext context) {
        RecoveryPlan rp = context.getRecoveryPlan();
        boolean flag = false;
        RecoveryProcessDefinition planedMotionProcDef = rp.getRecoveryProcess(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
        for (RecoveryProcessor recoveryProcess : planedMotionProcDef.getRecoveryProcessors()) {
            boolean isSucess = recoveryProcess.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
            boolean isDeleteVm = recoveryProcess instanceof DeleteVmRecoveryProcessor;
            boolean isDeleteDs = recoveryProcess instanceof DeleteDataStoreProcessor;
            if (isSucess || !isDeleteVm && !isDeleteDs) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.galax.storage.recovery.process.reprotect.CleanProductSiteProcessor.des");
    }
}

