/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.reprotect;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.process.BaseRefreshCloudProcessor;
import com.huawei.ism.drm.galax.recovery.process.RegisterVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.StartVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.recovery.process.command.exception.FindNoResourceMappingCheckedException;
import com.huawei.ism.drm.galax.recovery.process.command.impl.RefreshCloudCmd;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.process.subprocess.RefreshCloudSubProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectGroupProxy;
import com.huawei.ism.drm.galax.storage.recovery.command.parsor.ReprotectErrorParser;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RefreshCloudProcessor
extends BaseRefreshCloudProcessor {
    private static final long serialVersionUID = -2310645521899935474L;
    private static final Log logger = LogFactory.getInstance(RefreshCloudProcessor.class);

    protected boolean preExcuteCheck(RecoveryProcessorContext context) {
        if (!(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType() || this.isRegisterAllVmsSuccess(context) && this.isStartAllVmsSuccess(context))) {
            this.refreshCloudAndUpdatePo(context);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.rollbackallvms.vrm.errorcode", new String[0]);
            this.setPoRecoveryStatusAfterRefresh();
            return false;
        }
        return true;
    }

    protected void setPoRecoveryStatusAfterRefresh() {
        super.setPoRecoveryStatusAfterRefresh();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            RecoveryToolsUtil.getInstance().setPoRecoveryStatusAfterRefresh(this.getContextRef(), this.getProcType(), 12);
        }
    }

    private boolean isRegisterAllVmsSuccess(RecoveryProcessorContext context) {
        RecoveryPlan rp = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(rp);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessor registerVmProcessor = rpProxy.getRecoveryProcessByType(type, RegisterVmRecoveryProcessor.class);
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        if (registerVmProcessor == null) {
            return false;
        }
        return registerVmProcessor.getProcStatus() == successStatus;
    }

    private boolean isStartAllVmsSuccess(RecoveryProcessorContext context) {
        RecoveryPlan rp = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        RecoveryPlanProxy rpProxy = GalaxProxyFactory.createRecoveryPlanProxy(rp);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessor startVmProcessor = rpProxy.getRecoveryProcessByType(type, StartVmRecoveryProcessor.class);
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        if (startVmProcessor == null) {
            return false;
        }
        return startVmProcessor.getProcStatus() == successStatus;
    }

    protected void updateRefreshSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        RecoveryPlan plan = context.getRecoveryPlan();
        Set pgSet = plan.getProtectGroups();
        ArrayList<String> addedCloudSn = new ArrayList<String>();
        for (ProtectGroup pg : pgSet) {
            RecoveryProcessor rp;
            PgMgrInfo mgrInfo = GalaxProxyFactory.createPgMgrInfo(pg);
            String fcSn = mgrInfo.getPgFcSn();
            this.addRefreshFmSubProcessors(context, subProcessors, addedCloudSn, pg, fcSn);
            String recCloudSn = this.getRecCloudSn(context, fcSn);
            if (addedCloudSn.contains(recCloudSn) || (rp = this.generateRp(recCloudSn, "Dr_Vrm", pg.getUuid())) == null) continue;
            addedCloudSn.add(recCloudSn);
            subProcessors.add(rp);
        }
        this.saveProcessors(subProcessors);
    }

    private void addRefreshFmSubProcessors(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessors, List<String> addedCloudSn, ProtectGroup pg, String fcSn) {
        if (!pg.getPoProviderSN().equals(fcSn)) {
            String recCloudSn = this.getRecCloudSn(context, pg.getPoProviderSN());
            if (addedCloudSn.contains(recCloudSn)) {
                return;
            }
            RecoveryProcessor rp = this.generateRp(recCloudSn, "Dr_Fm", pg.getUuid());
            if (rp != null) {
                addedCloudSn.add(recCloudSn);
                subProcessors.add(rp);
            }
        }
    }

    private String getRecCloudSn(RecoveryProcessorContext context, String proCloudSn) {
        ResourceMapping rm;
        String recoverySiteId;
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            return proCloudSn;
        }
        ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("productResourceProviderId", (Object)proCloudSn);
        props.add(condition);
        String productSiteId = context.getAttribute("PRODUCT_SITE_ID") == null ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
        String string = recoverySiteId = context.getAttribute("SELECT_DISASTER_SITE_KEY") == null ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
        if (!VerifyUtil.isEmpty((String)productSiteId) && !VerifyUtil.isEmpty((String)recoverySiteId)) {
            QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
            props.add(conditionRecoverySiteId);
        }
        if ((rm = FsRecoveryUtil.getResourceMapping(props, (String)"productResourceProviderId", (String)proCloudSn)) == null) {
            logger.error((Object)"Failed to get rm by proCloudSn:%s.", new Object[]{SecurityUtil.desensitizeId((String)proCloudSn)});
            throw new FindNoResourceMappingCheckedException();
        }
        return rm.getRecoveryResourceProviderId();
    }

    private RecoveryProcessor generateRp(String cloudSn, String cloudType, String pgUuid) {
        NetworkEntity entity = (NetworkEntity)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(NetworkEntity.class, "sn", (Object)cloudSn);
        RefreshCloudSubProcessor processor = null;
        HashSet<String> pgUuidSet = new HashSet<String>();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            pgUuidSet.add(pgUuid);
        }
        if (entity != null) {
            processor = new RefreshCloudSubProcessor((RecoveryProcessor)this, cloudSn, entity.getLinkIp());
            RefreshCloudCmd cmd = new RefreshCloudCmd(null, cloudSn, cloudType, "GALAX_STORAGE_RECOVERY", pgUuidSet);
            ReprotectErrorParser parser = new ReprotectErrorParser((GalaxBaseSubRecoveryProcessor)processor);
            RecoveryProcessTask task = new RecoveryProcessTask(this.getProcId(), (IRecoveryCommand)cmd, null, (ICmdResponseParser)parser);
            processor.setExcuteTask((IExecuteTask)task);
        }
        return processor;
    }

    private void refreshCloudAndUpdatePo(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String cloudSn = pg.getPoProviderSN();
        NetworkEntity mo = (NetworkEntity)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(NetworkEntity.class, "sn", (Object)cloudSn);
        if (mo == null) {
            logger.error((Object)"failed to get the cloud information, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)cloudSn)});
            throw new LegoCheckedException(0x300001L);
        }
        String cloudType = "Dr_Fm";
        if (mo instanceof VRM) {
            cloudType = "Dr_Vrm";
        }
        RefreshContext refreshContext = new RefreshContext((ManagedObject)mo);
        refreshContext.setAttribute("refreshTask", (Object)this);
        refreshContext.setAttribute("DiscoveryType", (Object)"refresh");
        CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType(cloudType);
        if (refreshTemplate == null) {
            throw new LegoCheckedException(127402L);
        }
        refreshTemplate.process((AbstractContext)refreshContext);
        Long errorCode = (Long)refreshContext.getAttribute("icommand:errorcode");
        if (errorCode != null) {
            throw new LegoCheckedException(errorCode.longValue());
        }
        ProtectGroup newPg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByID(pg.getUuid());
        ProtectGroupProxy pgProxy = GalaxProxyFactory.createPgProxy(newPg);
        pgProxy.updateMgrInfo(true);
        pgProxy.updatePos();
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)newPg);
    }
}

