/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.subprocess;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class GalaxMappingSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -931973272333339002L;
    private String deviceId;
    private String lunId;
    private String lunName;
    private String snapshotId = null;
    private String snapshotWWN;
    private String snapshotName = null;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private transient ResourceVO resourceVO;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSnapshotWWN(String snapshotWWN) {
        this.snapshotWWN = snapshotWWN;
    }

    public String getSnapshotWWN() {
        return this.snapshotWWN;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public final boolean execute(RecoveryProcessorContext context) {
        OperationResult result;
        RecoveryProcessResult processResult = context.getProcessResult();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{this.getSnapshotName(), this.getHostOrGroupName()});
            this.updateProcessDetail("ism.drm.recovery.snapshot.already.mapped", new String[]{this.getSnapshotName(), this.getHostOrGroupName()});
            return true;
        }
        String createSnapshotResultkey = RecoveryProcessResult.getCreateSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getLunId());
        boolean createSnapshotResult = processResult.getProcessResult(createSnapshotResultkey);
        if (!createSnapshotResult && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != this.getProcType()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948680", new String[]{this.getLunId()});
            return true;
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        OperationResult operationResult = result = this.isLocalPlan(recoveryPlan) ? this.mappingSnapshotForLocal() : this.mappingSnapshot();
        if (null != result && !result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected OperationResult mappingSnapshot() {
        return null;
    }

    protected OperationResult mappingSnapshotForLocal() {
        return null;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getMappingLunProcResultKey((String)this.getLunId(), (String)this.getSnapshotId(), (String)this.getSnapshotWWN(), (String)this.getHostOrGroupId(), (String)this.getDeviceId());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void initSnapshotWWN(IStorageSnapshotManager proxy, Snapshot snapshot) {
        if (!(VerifyUtil.isEmpty((String)this.snapshotWWN) || "null".equals(this.snapshotWWN) || "--".equals(this.snapshotWWN))) {
            return;
        }
        List snapshots = proxy.getSnapshot(this.getDeviceId(), snapshot);
        if (!VerifyUtil.isEmpty((Collection)snapshots)) {
            this.snapshotWWN = ((Snapshot)snapshots.get(0)).getWwn();
        }
    }

    public void setResourceVO(ResourceVO resourceVO) {
        this.resourceVO = resourceVO;
    }

    public ResourceVO getResourceVO() {
        return this.resourceVO;
    }

    private boolean isLocalPlan(RecoveryPlan recoveryPlan) {
        return DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType();
    }
}

