/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.subprocess;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class VmDeleteSnapMapFromHostSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8236347839046897699L;
    private static final Log logger = LogFactory.getInstance(VmDeleteSnapMapFromHostSubProcessor.class);
    private static final long LOG_CODE = -1L;
    private static final int REPEAT_TIMES = 16;
    private static final long MILLION_SEC = 1000L;
    private String lunId = null;
    private String snapshotId = null;
    private String snapshotName = null;
    private String hostMoId = null;
    private String lunName = null;
    private String tgtDeviceId = null;

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getTgtDeviceId() {
        return this.tgtDeviceId;
    }

    public void setTgtDeviceId(String tgtDeviceId) {
        this.tgtDeviceId = tgtDeviceId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            logger.info((Object)"getProcStatus is success:", -1L);
            this.updateProcessNameParams(new String[]{this.snapshotName});
            this.updateProcessDetail("ism.drm.galax.recovery.snapshotlun.already.unmapped", new String[]{this.snapshotName});
            return true;
        }
        this.updateProcessNameParams(new String[]{this.snapshotName});
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getStorageType(this.tgtDeviceId);
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot as = new ArraySnapshot();
        as.setSnapshotId(this.snapshotId);
        as.setSnapshotName(this.snapshotName);
        logger.info((Object)("removeSnapshotFromHost paras:" + this.tgtDeviceId + "-" + as), -1L);
        OperationResult result = this.tryRepeatDeleteMapping(proxy, this.tgtDeviceId, as);
        logger.info((Object)("removeSnapshotFromHost result:" + result), -1L);
        if (null == result || !result.isSuccess()) {
            this.updateProcessDetail("lego.err." + (null == result ? Long.valueOf(-1L) : result.getErrorCode()), null == result ? new String[]{} : result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getUnMappingSnapshotProcResultKey((String)this.lunId, (String)this.snapshotId, (String)this.hostMoId, (String)this.tgtDeviceId);
    }

    private OperationResult tryRepeatDeleteMapping(IStorageSnapshotManager proxy, String deviceId, ArraySnapshot as) {
        OperationResult result = null;
        Lun lun = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getTargetLunById(deviceId, this.lunId);
        for (int i = 16; i > 0; --i) {
            try {
                result = proxy.removeSnapshotBySrcLUN(deviceId, (Snapshot)as, lun.getLunId());
            }
            catch (Exception e) {
                logger.error((Object)("proxy.removeSnapshotBySrcLUN.Throwable:" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            }
            if (null != result && result.isSuccess()) break;
            try {
                logger.info((Object)("removeSnapshotFromHost faild: waiting for " + i + " seconds to retry."), -1L);
                Thread.sleep((long)i * 1000L);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("tryRepeatDeleteMapping sleep error:" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            }
        }
        return result;
    }

    public void updateProcessName() {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoverPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        this.setProcName(this.calcProcessName(recoverPlan));
    }

    private String calcProcessName(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            return "com.huawei.ism.drm.galax.storage.recovery.process.subprocess.VmDeleteSnapMapFromHostSubProcessor.local";
        }
        return ((Object)((Object)this)).getClass().getName();
    }
}

