/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.process.subprocess;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.recovery.process.subprocess.GalaxMappingSnapshotSubProcessor;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class VmMappingSnapshotToHostSubProcessor
extends GalaxMappingSnapshotSubProcessor {
    private static final long serialVersionUID = -605945335707030317L;
    private static final Log logger = LogFactory.getInstance(VmMappingSnapshotToHostSubProcessor.class);

    @Override
    protected OperationResult mappingSnapshot() {
        OperationResult operationResult;
        logger.info((Object)"begin to mappingSnapshot.", 90160758786816L);
        Lun lun = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getTargetLunById(this.getDeviceId(), this.getLunId());
        if (null == lun) {
            logger.error((Object)("result of query Lun is null, deviceId=" + this.getDeviceId() + ", lunId=" + this.getLunId()), 90160758787071L);
            this.updateProcessName("ism.drm.recovery.snapshot.mapping.failed");
            String[] errorParams = new String[]{this.getLunId(), this.getDeviceId()};
            this.updateProcessDetail("lego.err.1073948685", errorParams);
            return new OperationResult("MappingSnapshot", true, false, String.valueOf(2117645L), new String[0]);
        }
        this.updateProcessNameParams(new String[]{this.getSnapshotName()});
        this.setLunName(lun.getName());
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = ((IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class)).getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setSnapshotId(this.getSnapshotId());
        arraySnapshot.setSnapshotName(this.getSnapshotName());
        logger.info((Object)("begin to proxy.addSnapshotToHost, deviceId=" + this.getDeviceId() + ", lunId=" + lun.getLunId() + "snapshotId=" + arraySnapshot.getSnapshotId()), 90160758786816L);
        try {
            operationResult = proxy.addSnapshotToHost(this.getDeviceId(), lun.getLunId(), (Snapshot)arraySnapshot);
        }
        catch (Exception e) {
            logger.error((Object)("proxy.addSnapshotToHost.Throwable:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            operationResult = null;
        }
        logger.info((Object)("finish proxy.addSnapshotToHost, ret=" + operationResult), 90160758786816L);
        return operationResult;
    }

    @Override
    protected OperationResult mappingSnapshotForLocal() {
        ResourceVO resourceVO = VrmRecoveryUtil.getResourceVO(this.getHostOrGroupId());
        if (null == resourceVO) {
            this.updateProcessName("ism.drm.recovery.snapshot.mapping.failed");
            OperationResult operationResult = this.checkOperationObject();
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{this.getSnapshotName(), resourceVO.getName()});
        this.setHostOrGroupName(resourceVO.getName());
        IRecoveryResourceBaseService recService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setSnapshotId(this.getSnapshotId());
        arraySnapshot.setSnapshotName(this.getSnapshotName());
        this.initSnapshotWWN(proxy, (Snapshot)arraySnapshot);
        String srcLunId = this.getLunId();
        logger.info((Object)("begin to proxy.mappingSnapshot, deviceId=" + this.getDeviceId() + ", lunId=" + srcLunId + "snapshotId=" + arraySnapshot.getSnapshotId() + ", hostId=" + this.getHostOrGroupId()), 90160758786816L);
        OperationResult operationResult = resourceVO instanceof HostVO ? proxy.mappingSnapshot(this.getDeviceId(), srcLunId, (Snapshot)arraySnapshot, (HostVO)resourceVO) : proxy.mappingSnapshot(this.getDeviceId(), srcLunId, (Snapshot)arraySnapshot, (HostGroupVO)resourceVO);
        logger.info((Object)("end to proxy.mappingSnapshot, ret=" + operationResult), 90160758786816L);
        return operationResult;
    }

    private OperationResult checkOperationObject() {
        String[] errorParams = new String[]{this.getHostOrGroupId()};
        String errorCode = String.valueOf(1073948686L);
        return new OperationResult("Mapping", true, false, errorCode, errorParams);
    }

    public void updateProcessName() {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoverPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        this.setProcName(this.calcProcessName(recoverPlan));
    }

    private String calcProcessName(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            return "com.huawei.ism.drm.galax.storage.recovery.process.subprocess.VmMappingSnapshotToHostSubProcessor.local";
        }
        return ((Object)((Object)this)).getClass().getName();
    }
}

