/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.recovery.process.IRecoveryPreChecker;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSBProtectGroupChecker
implements IRecoveryPreChecker {
    private static final Log LOGGER = LogFactory.getInstance(FSBProtectGroupChecker.class);

    public void check(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        Set protectGroups = plan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.warn((Object)("there is no protectgroup in recovery plan, planId=" + plan.getUuid()), 90160758787071L);
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == execType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == execType.getValue()) {
            for (ProtectGroup pg : protectGroups) {
                if (pg.getPoType() != DrmEnumDefine.AppType.GALAX_VM.getValue() || pg.getTemplate().getType() != 33 && pg.getTemplate().getType() != 39) continue;
                if (!FSBProtectGroupChecker.checkPGVmProtectStatus(pg)) {
                    LOGGER.warn((Object)("there is invalidVM in protectgroup, pgId=" + pg.getUuid()), 90160758787071L);
                    throw new LegoCheckedException(1073948909L);
                }
                if (!FSBProtectGroupChecker.checkPGDiskProtectStatus(pg)) {
                    LOGGER.warn((Object)("there is unprotectedDisk in protectgroup, pgId=" + pg.getUuid()), 90160758787071L);
                    throw new LegoCheckedException(1073948918L);
                }
                FSBProtectGroupChecker.checkPGShareVolumeRelateVM(pg);
                this.checkTargetPoolDataStore(pg);
            }
        }
    }

    private static boolean checkPGVmProtectStatus(ProtectGroup protectGroup) {
        for (ProtectObject po : protectGroup.getPolist()) {
            if (po.getPoStatus() == ProtectObjectStatusEnum.VALID.getValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPGDiskProtectStatus(ProtectGroup protectGroup) {
        IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        List diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        for (DiskInfo diskInfo : diskInfoList) {
            if (DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskInfo.getStatus())) continue;
            return false;
        }
        return true;
    }

    private static void checkPGShareVolumeRelateVM(ProtectGroup pg) {
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(pg.getProductSiteId());
        List vmNames = null;
        if (site.getSiteType() == 0) {
            vmNames = FsRecoveryUtil.getInvalidSharedDiskVms((String)pg.getUuid());
        } else {
            RestClient client = SiteUtil.initClient((Site)site);
            String url = String.format("/ws/vrm/getInvalidSharedDiskVms?pgId=%s", pg.getUuid());
            String str = client.get(url, null);
            JSONObject result = JSONObject.fromObject((Object)str);
            vmNames = (List)result.get("vmNameList");
        }
        if (null != vmNames && !vmNames.isEmpty()) {
            StringBuilder vmStr = new StringBuilder();
            for (String vmName : vmNames) {
                vmStr.append(vmName).append(",");
            }
            LOGGER.error((Object)("vm has share volume:" + vmStr));
            throw new LegoCheckedException(1073947682L, new String[]{vmStr.substring(0, vmStr.length() - 1)});
        }
    }

    private void checkTargetPoolDataStore(ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            LOGGER.warn((Object)"pg or polist is empty.");
            return;
        }
        ProtectObject protectObject = (ProtectObject)pg.getPolist().stream().findAny().get();
        StoragePair targetStoragePair = this.getTargetStoragePair(pg, protectObject);
        if (VerifyUtil.isEmpty((Object)targetStoragePair) || VerifyUtil.isEmpty((Map)targetStoragePair.getStoragePools())) {
            LOGGER.warn((Object)"pg:%s targetStoragePair pool is empty.", new Object[]{pg.getName()});
            return;
        }
        String tgtVrmSn = this.getTargetVrmSn(pg, protectObject);
        if (VerifyUtil.isEmpty((String)tgtVrmSn)) {
            LOGGER.warn((Object)"pg:%s tgtVrmSn is empty.", new Object[]{pg.getName()});
            return;
        }
        this.checkDataStore(targetStoragePair, tgtVrmSn);
    }

    private StoragePair getTargetStoragePair(ProtectGroup pg, ProtectObject protectObject) {
        String replicationCfg = pg.getProperty("storagePoolMapping");
        if (VerifyUtil.isEmpty((String)replicationCfg)) {
            LOGGER.warn((Object)"pg:%s replicationCfg is empty.", new Object[]{pg.getName()});
            return null;
        }
        if (VerifyUtil.isEmpty((Collection)protectObject.getUsedStorageResourceSet())) {
            LOGGER.warn((Object)"po:%s UsedStorageResourceSet is empty.", new Object[]{protectObject.getName()});
            return null;
        }
        ReplicationPairConfiguration config = new ReplicationPairConfiguration(replicationCfg);
        String srcDevSN = ((ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().stream().findAny().get()).getResourceProviderSN();
        List storagePairs = config.findStoragePair(srcDevSN);
        if (VerifyUtil.isEmpty((Collection)storagePairs)) {
            LOGGER.warn((Object)"can not find pg:%s storagePars for:%s.", new Object[]{pg.getName(), srcDevSN});
            return null;
        }
        StoragePair targetStoragePair = null;
        for (StoragePair storagePair : storagePairs) {
            if (!storagePair.getSrcDevSN().equals(srcDevSN)) continue;
            targetStoragePair = storagePair;
            break;
        }
        return targetStoragePair;
    }

    private String getTargetVrmSn(ProtectGroup pg, ProtectObject protectObject) {
        if (VerifyUtil.isEmpty((Object)pg.getTemplate()) || VerifyUtil.isEmpty((Collection)pg.getTemplate().getSchedules())) {
            LOGGER.warn((Object)"pg:%s schedules is empty.", new Object[]{pg.getName()});
            return null;
        }
        VmMgrInfo vmMgr = GalaxProxyFactory.createVmMgrInfo(protectObject);
        String productSiteId = pg.getProductSiteId();
        String recoverySiteId = ((Schedule)pg.getTemplate().getSchedules().stream().findAny().get()).getTargetSiteId();
        ResourceMapping res = FsRecoveryUtil.getResourceMapping((String)vmMgr.getLocation(), (boolean)vmMgr.isHostLoc(), (String)"productResourceId", (String)productSiteId, (String)recoverySiteId);
        String tgtVrmSn = null;
        if (null != res) {
            tgtVrmSn = res.getRecoveryResourceProviderId();
        }
        return tgtVrmSn;
    }

    private void checkDataStore(StoragePair targetStoragePair, String tgtVrmSn) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", tgtVrmSn);
        List dsList = CommonDAOLocator.getMoDao().findMoBy(DataStore.class, props);
        HashSet<String> dsPoolIdSet = new HashSet<String>();
        for (DataStore dataStore : dsList) {
            JSONArray array = JSONArray.fromObject((Object)dataStore.getStorageUnits());
            JSONObject obj = JSONObject.fromObject((Object)array.get(0));
            String suName = (String)obj.get("suName");
            if (!"DSWARE".equals(dataStore.getStorageType()) || VerifyUtil.isEmpty((String)suName)) continue;
            dsPoolIdSet.add(suName);
        }
        targetStoragePair.getStoragePools().values().forEach(storagePool -> {
            if (!dsPoolIdSet.contains(storagePool)) {
                LOGGER.error((Object)"can not find datastore for pool:%s", new Object[]{storagePool});
                throw new LegoCheckedException(1073949706L, new String[]{storagePool});
            }
        });
    }
}

