/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.service;

import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.VolumeData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.storage.entity.PgMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.recovery.service.ResMappingRecProcChecker;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.recovery.process.IRecoveryPreChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FreeStateLunChecker
implements IRecoveryPreChecker {
    private static Log logger = LogFactory.getInstance(FreeStateLunChecker.class);

    public void check(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (null == plan || null == execType) {
            logger.error((Object)"Invalid parameters.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)execType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)execType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.equals((Object)execType))) {
            logger.warn((Object)"Skip check.");
            return;
        }
        Set protectGroups = plan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            logger.warn((Object)("there is no protectgroup in recovery plan, planId=" + plan.getUuid()), 90160758787071L);
            return;
        }
        for (ProtectGroup protectGroup : protectGroups) {
            String dsgId;
            if (protectGroup.getPoType() != DrmEnumDefine.AppType.GALAX_VM.getValue() || !ResMappingRecProcChecker.CHECK_TEMPLATE_TYPE.contains(protectGroup.getTemplate().getType()) || VerifyUtil.isEmpty((String)(dsgId = (String)protectGroup.getProps().get(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue()))) || !this.volumeNotBindToVMExist(protectGroup)) continue;
            throw new LegoCheckedException(1073948917L);
        }
    }

    private boolean volumeNotBindToVMExist(ProtectGroup protectGroup) {
        PgMgrInfo pgMgrInfo = GalaxProxyFactory.createPgMgrInfo(protectGroup);
        Site sitePro = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(protectGroup.getProductSiteId());
        if (sitePro.getSiteType() == 0) {
            VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)pgMgrInfo.getPgFcSn());
            for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
                List volumes = VrmManager.getInstance().getVrmVirtualResService().queryVolumeByDataStoreUrn(vrmInfo, dsMgrInfo.getDsUrn(), false);
                for (VolumeData volume : volumes) {
                    if (volume.getBindToVm() == 3) continue;
                    logger.error((Object)("volume not bind to VM detected:" + volume.getName()));
                    return true;
                }
            }
        } else {
            for (DsMgrInfoBase dsMgrInfo : pgMgrInfo.getDsInfos()) {
                RestClient client;
                String result;
                JSONObject jsonObject;
                String url;
                try {
                    url = String.format("/ws/vrm/%s/datastores/%s/details", URLEncoder.encode(URLEncoder.encode(pgMgrInfo.getPgFcSn(), "UTF-8"), "UTF-8"), URLEncoder.encode(URLEncoder.encode(dsMgrInfo.getDsUrn(), "UTF-8"), "UTF-8"));
                }
                catch (Exception e) {
                    logger.error((Object)"encode url error:", (Throwable)e);
                    url = "";
                }
                if (!(jsonObject = JSONObject.fromObject((Object)(result = (client = SiteUtil.initClient((Site)sitePro)).get(url, null)))).getBoolean("hasIsolateVolume")) continue;
                return true;
            }
        }
        return false;
    }
}

