/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.service;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.protection.protectgroup.check.PgResMappingCheckService;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResMappingRecProcChecker
implements IRecoveryProcessChecker {
    static final Set<Integer> CHECK_TEMPLATE_TYPE = new HashSet<Integer>();
    private static final Log LOGGER;

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryPlan plan = context.getRecoveryPlan();
        Set protectGroups = plan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.warn((Object)"There is no protectgroup in recovery plan, planId=%s.", new Object[]{plan.getUuid()});
            return;
        }
        HashSet<String> storageSns = new HashSet<String>();
        for (ProtectGroup pg : protectGroups) {
            if (pg.getPoType() != DrmEnumDefine.AppType.GALAX_VM.getValue() || !CHECK_TEMPLATE_TYPE.contains(pg.getTemplate().getType())) continue;
            this.checkPgResMapping(pg, procType);
            String recSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
            String recoveryArray = GalaxProxyFactory.createPgProxy(pg).getRecoveryArray(recSiteId);
            if (VerifyUtil.isEmpty((String)recoveryArray)) {
                LOGGER.warn((Object)"There is no recoveryArray in protectgroup, pgId=%s.", new Object[]{pg.getUuid()});
                continue;
            }
            storageSns.add(recoveryArray);
        }
        for (String recoveryArray : storageSns) {
            this.refreshStorage(recoveryArray, procType);
        }
    }

    private void checkPgResMapping(ProtectGroup protectGroup, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == procType.getValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == procType.getValue()) {
            return;
        }
        ArrayList<VmMgrInfo> vmMgrInfoList = new ArrayList<VmMgrInfo>();
        for (ProtectObject po : protectGroup.getPolist()) {
            ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
            VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
            vmMgrInfoList.add(vmMgr);
        }
        new PgResMappingCheckService().checkPgResMapping(protectGroup, vmMgrInfoList, protectGroup.getPoProviderSN());
    }

    private void refreshStorage(String recoveryArray, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (procType.getValue() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() || procType.getValue() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            return;
        }
        StorageReprotectManagerProxy.getInstance().refreshStorage(recoveryArray);
        LOGGER.info((Object)"Refreshing storage successed. SN:%s.", new Object[]{recoveryArray});
    }

    public String getName() {
        return this.getClass().getName();
    }

    private void checkDisks(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            return;
        }
        if (protectGroup.getTemplate().getType() != 33 && protectGroup.getTemplate().getType() != 39) {
            return;
        }
        Set<String> poStorageInfoWwns = this.getPoStorageInfoWwns(protectGroup);
        Set polist = protectGroup.getPolist();
        polist.forEach(protectObject -> {
            List disks = ((IVrmService)ServiceLocator.getInstance().getService(IVrmService.class)).getVmConfigDiskTypes(protectObject.getMoUuid(), protectObject.getProviderSN());
            if (VerifyUtil.isEmpty((Collection)disks)) {
                return;
            }
            Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
            HashSet protectedDiskNames = new HashSet();
            usedStorageResourceSet.forEach(poStorageInfo -> {
                if (VerifyUtil.isEmpty((String)poStorageInfo.getResourceName())) {
                    return;
                }
                protectedDiskNames.add(poStorageInfo.getResourceName());
            });
            HashMap diskVolumeUuidMap = new HashMap();
            disks.forEach(disk -> {
                if (!protectedDiskNames.contains(disk.getVolumeUuid())) {
                    this.throwUnprotectedDiskException(protectGroup, (ProtectObject)protectObject, disk.getDiskName());
                }
                diskVolumeUuidMap.put(disk.getVolumeUuid(), disk.getDiskName());
            });
            usedStorageResourceSet.forEach(protectObjectStorageInfo -> {
                if (diskVolumeUuidMap.containsKey(protectObjectStorageInfo.getResourceName()) && !poStorageInfoWwns.contains(protectObjectStorageInfo.getLunWWN())) {
                    this.throwUnprotectedDiskException(protectGroup, (ProtectObject)protectObject, (String)diskVolumeUuidMap.get(protectObjectStorageInfo.getResourceName()));
                }
            });
        });
    }

    private void throwUnprotectedDiskException(ProtectGroup protectGroup, ProtectObject protectObject, String diskName) {
        LOGGER.error((Object)"Disk ({2}) in VM ({1}) in protected group ({0}) at the production site is not protected.", new Object[]{protectGroup.getName(), protectObject.getName(), diskName});
        throw new LegoCheckedException(1073947730L, new String[]{protectGroup.getName(), protectObject.getName(), diskName});
    }

    private Set<String> getPoStorageInfoWwns(ProtectGroup protectGroup) {
        HashSet<String> pairIds = new HashSet<String>();
        protectGroup.getReplicaList().forEach(protectGroupReplica -> protectGroupReplica.getReplicas().forEach(protectObjectReplica -> protectObjectReplica.getStorageInfos().forEach(relicaStorageInfo -> pairIds.add(relicaStorageInfo.getProtectObjectStorageWwn()))));
        return pairIds;
    }

    static {
        CHECK_TEMPLATE_TYPE.add(18);
        CHECK_TEMPLATE_TYPE.add(20);
        CHECK_TEMPLATE_TYPE.add(23);
        CHECK_TEMPLATE_TYPE.add(24);
        CHECK_TEMPLATE_TYPE.add(0);
        CHECK_TEMPLATE_TYPE.add(1);
        CHECK_TEMPLATE_TYPE.add(33);
        CHECK_TEMPLATE_TYPE.add(39);
        CHECK_TEMPLATE_TYPE.add(26);
        CHECK_TEMPLATE_TYPE.add(27);
        LOGGER = LogFactory.getInstance(ResMappingRecProcChecker.class);
    }
}

