/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.recovery.service;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmConstant;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.galax.recovery.service.AbstractFusionSphereRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.HostToPowerOn;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService;
import com.huawei.ism.drm.galax.storage.entity.VmMgrInfo;
import com.huawei.ism.drm.galax.storage.proxy.GalaxProxyFactory;
import com.huawei.ism.drm.galax.storage.proxy.ProtectObjectProxy;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.galax.storage.support.dao.BaseStoragePgDao;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.criterion.Criterion;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService", desc="", interfaceClass=IStorageRecoveryPlanService.class)
public class StorageRecoveryPlanService
extends AbstractFusionSphereRecoveryPlanService {
    private Log logger = LogFactory.getInstance(StorageRecoveryPlanService.class);
    private String trace = "trace";
    private IManagementServerBaseService managementServerService;
    private BaseStoragePgDao baseStoragePgDao;

    public IManagementServerBaseService getManagementServerService() {
        return this.managementServerService;
    }

    public void setManagementServerService(IManagementServerBaseService managementServerService) {
        this.managementServerService = managementServerService;
    }

    public BaseStoragePgDao getBaseStoragePgDao() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.baseStoragePgDao;
    }

    public void setBaseStoragePgDao(BaseStoragePgDao baseStoragePgDao) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.baseStoragePgDao = baseStoragePgDao;
    }

    public boolean isTemplate(ProtectObject po) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return GalaxProxyFactory.createPoProxy(po).isTemplate();
    }

    public List<RecoveryPlan> getAllRecoveryPlan() {
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList<RecoveryPlan>();
        List criterionList = this.getBaseDao().translatePropsToCriterions(new ArrayList());
        List list = this.getBaseDao().createCriteria(RecoveryPlan.class, "planName", true, criterionList.toArray(new Criterion[criterionList.size()]));
        Page page = Page.createPage((int)0, (int)Integer.MAX_VALUE, (List)((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(DrmConstant.DEFAULT_USER_ID, list));
        if (page != null) {
            recoveryPlans.addAll(page.getResult());
        }
        return recoveryPlans;
    }

    private void checkParams(String param) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)param)) {
            this.logger.error((Object)"@@The param is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public List<ComputeNode> queryPowerOnHost(String planId, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(planId);
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String remoteCloudSn = this.baseStoragePgDao.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(Arrays.asList(remoteCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return Collections.emptyList();
        }
        return RecoveryPlanUtil.getPowerOnHost((RecoveryPlan)plan);
    }

    public List<ComputeNode> queryUnSetHost(String planId, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(planId);
        Site site = this.getSiteService().getSiteById(recoverySiteId, Long.valueOf(userId));
        if (site == null) {
            this.logger.error((Object)"not found recovery plan disaster site by uuid(%s)", new Object[]{recoverySiteId});
            throw new LegoCheckedException(1073948719L);
        }
        if (site.getSiteType() == 1) {
            String data = this.managementServerService.get(site.getServerUuid(), "/ws/fusionsphere/hosts/action/getAvailableHost?planId={planId}&&recoverySiteId={siteId}", new JSONObject().set((Object)"planId", (Object)planId).set((Object)"siteId", (Object)recoverySiteId));
            if (VerifyUtil.isEmpty((String)data)) {
                return Collections.emptyList();
            }
            return JSONArray.fromObject((Object)data).toBean(ComputeNode.class);
        }
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String remoteCloudSn = this.baseStoragePgDao.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(Arrays.asList(remoteCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return Collections.emptyList();
        }
        List<ComputeNode> recHostList = this.getRemoteComputeNode(plan, recoverySiteId);
        List<ComputeNode> unSetHostList = this.filterUnSetHostInPlan(planId, recoverySiteId, recHostList, userId);
        return unSetHostList;
    }

    private List<ComputeNode> filterUnSetHostInPlan(String planId, String recoverySiteId, List<ComputeNode> remoteHostList, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<ComputeNode> powerOnHostInRp = this.queryPowerOnHost(planId, recoverySiteId, userId);
        if (VerifyUtil.isEmpty(powerOnHostInRp)) {
            this.logger.info((Object)"@@there is no powerOnHost in recoveryPlan ", 90160758786816L);
            return remoteHostList;
        }
        ArrayList<String> urns = new ArrayList<String>();
        for (ComputeNode cn : powerOnHostInRp) {
            urns.add(cn.getUrn());
        }
        ArrayList<ComputeNode> hostList = new ArrayList<ComputeNode>();
        for (ComputeNode cn : remoteHostList) {
            if (urns.contains(cn.getUrn())) continue;
            hostList.add(cn);
        }
        return hostList;
    }

    private List<ComputeNode> getRemoteComputeNode(RecoveryPlan plan, String recoverySiteId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HashMap<String, ComputeNode> hostMap = new HashMap<String, ComputeNode>();
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        Set poList = pg.getPolist();
        for (ProtectObject po : poList) {
            this.fillHostMap(po, plan, hostMap, recoverySiteId);
        }
        ArrayList<ComputeNode> cnList = new ArrayList<ComputeNode>(hostMap.values());
        Collections.sort(cnList, new Comparator<ComputeNode>(){

            @Override
            public int compare(ComputeNode arg0, ComputeNode arg1) {
                if (arg0.getName() == null || arg1.getName() == null) {
                    return -1;
                }
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return cnList;
    }

    private void fillHostMap(ProtectObject po, RecoveryPlan plan, Map<String, ComputeNode> hostMap, String recoverySiteId) {
        String recoveryUrn;
        this.logger.trace((Object)(this.trace + " trace message"));
        ProtectObjectProxy poProxy = GalaxProxyFactory.createPoProxy(po);
        VmMgrInfo vmMgr = poProxy.getPoMgrInfo();
        String hostOrClusterUrn = vmMgr.getLocation();
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)plan);
        String string = recoveryUrn = this.isLocalPlan(plan) ? this.getRecovryHostClusterForLocal(hostOrClusterUrn, plan) : this.getRecovryHostClusterForRep(hostOrClusterUrn, productSiteId, recoverySiteId);
        if (!vmMgr.isHostLoc()) {
            List cnInClusterList = RecoveryPlanUtil.getAvaliableComputeNode((String)recoveryUrn);
            for (ComputeNode computeNode : cnInClusterList) {
                hostMap.put(computeNode.getUuid(), computeNode);
            }
        } else {
            ComputeNode remoteComputeNode = (ComputeNode)CommonDAOLocator.getMoDao().getMo(ComputeNode.class, "uuid", (Object)recoveryUrn);
            hostMap.put(recoveryUrn, remoteComputeNode);
        }
    }

    private String getRecovryHostClusterForRep(String hostOrClusterUrn, String productSiteId, String recoverySiteId) {
        ResourceMapping rm;
        this.logger.trace((Object)(this.trace + " trace message"));
        if (!VerifyUtil.isEmpty((String)productSiteId) && !VerifyUtil.isEmpty((String)recoverySiteId)) {
            Site recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
            if (0 != recoverySite.getSiteType()) {
                rm = StorageRecoveryPlanService.queryRemoteResourceMapping(hostOrClusterUrn, recoverySite);
            } else {
                ResourceMapping queryRm;
                ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
                QueryCondition conditionProductResourceId = new QueryCondition("productResourceId", (Object)hostOrClusterUrn);
                props.add(conditionProductResourceId);
                QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
                props.add(conditionRecoverySiteId);
                rm = queryRm = FsRecoveryUtil.getResourceMapping(props, (String)"productResourceProviderId", (String)hostOrClusterUrn);
            }
        } else {
            rm = this.baseStoragePgDao.getDaoAdapter().getResourceMappingByProductRes("productResourceId", hostOrClusterUrn);
        }
        String recoveryUrn = null;
        if (null != rm) {
            recoveryUrn = rm.getRecoveryResourceId();
            if (rm.getRecoveryResourceId().equals(hostOrClusterUrn)) {
                recoveryUrn = rm.getProductResourceId();
            }
        }
        return recoveryUrn;
    }

    private static ResourceMapping queryRemoteResourceMapping(String hostOrClusterUrn, Site recoverySite) {
        ResourceMapping rm = null;
        QueryCondition cond = new QueryCondition("recoverySiteId", (Object)recoverySite.getSiteId());
        List list = FsRecoveryUtil.getRemoteResourceMappings((Site)recoverySite, (QueryCondition)cond);
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (ResourceMapping resourceMapping : list) {
                if (recoverySite.getSiteId().equals(resourceMapping.getRecoverySiteId()) && hostOrClusterUrn.equals(resourceMapping.getProductResourceId())) {
                    rm = resourceMapping;
                    break;
                }
                if (!recoverySite.getSiteId().equals(resourceMapping.getProductSiteId()) || !hostOrClusterUrn.equals(resourceMapping.getRecoveryResourceId())) continue;
                rm = resourceMapping;
                break;
            }
        }
        return rm;
    }

    private String getRecovryHostClusterForLocal(String hostOrClusterUrn, RecoveryPlan plan) {
        this.logger.trace((Object)(this.trace + " trace message"));
        String array = FsRecoveryUtil.getGlobalSettingFromPlan((RecoveryPlan)plan, (String)"testHostCluster");
        JSONObject jObject = VrmRecoveryUtil.getMappingSettingFromPlan(array, "srcHostClusterId", hostOrClusterUrn);
        return jObject.getString("remoteHostClusterId");
    }

    private boolean isLocalPlan(RecoveryPlan plan) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType();
    }

    public void setPowerOnHost(String planId, String recoverySiteId, List<String> hostUrnList, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(planId);
        if (null == hostUrnList) {
            this.logger.error((Object)"@@The hostUrnList is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String recoveryCloudSn = this.baseStoragePgDao.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(Arrays.asList(recoveryCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return;
        }
        ArrayList<HostToPowerOn> hostList = new ArrayList<HostToPowerOn>();
        for (String hostUrn : hostUrnList) {
            this.fillPowerHost(hostUrn, recoveryCloudSn, hostList);
        }
        String powerOnHost = CommonUtil.beanToJson(hostList);
        plan.getGlobalSettings().put("PoweronHost", powerOnHost);
        this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)plan);
    }

    private void fillPowerHost(String hostUrn, String recoveryCloudSn, List<HostToPowerOn> hostList) {
        this.logger.trace((Object)(this.trace + " trace message"));
        ComputeNode host = (ComputeNode)CommonDAOLocator.getMoDao().getMo(ComputeNode.class, "uuid", (Object)hostUrn);
        if (VerifyUtil.isEmpty((Object)host)) {
            this.logger.error((Object)("@@The host is not exist, hostUrn:" + hostUrn), 90160758784001L);
            return;
        }
        String topMoUuidOfHost = host.getTopMoUuid();
        if (!recoveryCloudSn.startsWith("Dr_Vrm")) {
            FusionManager recCloudPlatform = this.getFmService().getDependenceFmByVrm(topMoUuidOfHost);
            if (null == recCloudPlatform) {
                this.logger.error((Object)("recCloudPlatform is null, hostUrn:" + hostUrn), 90160758784001L);
                return;
            }
            topMoUuidOfHost = recCloudPlatform.getSn();
        }
        if (null == topMoUuidOfHost || !topMoUuidOfHost.equals(recoveryCloudSn)) {
            this.logger.error((Object)("The Host does not belong to recCloudPlatform, hostUrn:" + hostUrn + " and recoveryCloudSn:" + recoveryCloudSn), 90160758784001L);
            return;
        }
        HostToPowerOn cn = new HostToPowerOn();
        cn.setUri(host.getUri());
        cn.setUrn(host.getUrn());
        hostList.add(cn);
    }

    public Set<String> getNetworkUrnsByPlan(String planId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HashSet<String> networkUrnSet = new HashSet<String>();
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        Set poSet = pg.getPolist();
        if (VerifyUtil.isEmpty((Collection)poSet)) {
            this.logger.error((Object)("there is no protect object in plan, id=" + planId), 90160758787071L);
            return networkUrnSet;
        }
        for (ProtectObject po : poSet) {
            ProtectObjectProxy poProxy = new ProtectObjectProxy(po);
            if (!GalaxVM.VMProviderType.FM.getValue().equals(poProxy.getVMProviderType())) {
                this.logger.error((Object)("this plan is not under FusionSphere, id=" + planId), 90160758787071L);
                return networkUrnSet;
            }
            for (ResourcepoolVMServiceV2Stub.Nic nic : poProxy.getFMNicList()) {
                networkUrnSet.add(FmUtils.getFmResourceUrn((String)pg.getPoProviderSN(), (String)FmNetwork.class.getSimpleName(), (String)nic.getNetworkid()));
            }
        }
        return networkUrnSet;
    }

    public Set<String> getSecGroupUrnsByPlan(String planId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HashSet<String> secGroupUrnSet = new HashSet<String>();
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        Set poSet = pg.getPolist();
        if (VerifyUtil.isEmpty((Collection)poSet)) {
            this.logger.error((Object)("there is no protect object in plan, id=" + planId), 90160758787071L);
            return secGroupUrnSet;
        }
        for (ProtectObject po : poSet) {
            this.fillGroupUrn(secGroupUrnSet, po, pg);
        }
        return secGroupUrnSet;
    }

    private void fillGroupUrn(Set<String> secGroupUrnSet, ProtectObject po, ProtectGroup pg) {
        this.logger.trace((Object)(this.trace + " trace message"));
        ProtectObjectProxy poProxy = new ProtectObjectProxy(po);
        if (!GalaxVM.VMProviderType.FM.getValue().equals(poProxy.getVMProviderType())) {
            this.logger.error((Object)"this plan is not under FusionSphere", 90160758787071L);
            return;
        }
        for (ResourcepoolVMServiceV2Stub.Nic nic : poProxy.getFMNicList()) {
            if ("-1".equals(nic.getSgId())) continue;
            secGroupUrnSet.add(FmUtils.getFmResourceUrn((String)pg.getPoProviderSN(), (String)SecurityGroup.class.getSimpleName(), (String)nic.getSgId()));
        }
    }

    protected String getRecoveryCloudSn(RecoveryPlan plan, String recoverySiteId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.baseStoragePgDao.getRecoveryCloudSn(plan, recoverySiteId);
    }

    protected ResourceMapping getResourceMappingByProductRes(String key, String value) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.baseStoragePgDao.getDaoAdapter().getResourceMappingByProductRes(key, value);
    }
}

