/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.storage.support.dao;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.storage.recovery.common.VrmRecoveryUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public final class BaseStoragePgDao {
    private static BaseStoragePgDao instance = new BaseStoragePgDao();
    private final Log logger = LogFactory.getInstance(this.getClass());
    private IDaoAdapter daoAdapter;
    private IFmService fmService;

    private BaseStoragePgDao() {
    }

    public static BaseStoragePgDao getInstance() {
        return instance;
    }

    public IFmService getFmService() {
        return this.fmService;
    }

    public void setFmService(IFmService fmService) {
        this.fmService = fmService;
    }

    public void setDaoAdapter(IDaoAdapter daoAdapter) {
        this.daoAdapter = daoAdapter;
    }

    public IDaoAdapter getDaoAdapter() {
        return this.daoAdapter;
    }

    public String getRecoveryCloudSn(RecoveryPlan plan, String recoverySiteId) {
        String localCloudSn = null;
        Set pgs = plan.getProtectGroups();
        Iterator it = pgs.iterator();
        if (it.hasNext()) {
            ProtectGroup pg = (ProtectGroup)it.next();
            if (VerifyUtil.isEmpty((Collection)pg.getPolist())) {
                this.logger.error((Object)"poList is empty.", 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            localCloudSn = ((ProtectObject)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getPolist())).getProviderSN();
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType() && null != localCloudSn) {
            return this.getRecoveryCloudSnForLocal(localCloudSn, plan);
        }
        return this.getRecoveryCloudSnForRep(localCloudSn, plan, recoverySiteId);
    }

    private String getRecoveryCloudSnForRep(String localCloudSn, RecoveryPlan plan, String recoverySiteId) {
        String remoteCloudSn;
        try {
            Set pgs;
            Iterator iterator;
            ResourceMapping rm = this.daoAdapter.getResourceMappingByProductRes("productResourceProviderId", localCloudSn);
            if (!VerifyUtil.isEmpty((String)recoverySiteId) && (iterator = (pgs = plan.getProtectGroups()).iterator()).hasNext()) {
                ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
                QueryCondition conditionProductResourceId = new QueryCondition("productResourceProviderId", (Object)localCloudSn);
                props.add(conditionProductResourceId);
                QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
                props.add(conditionRecoverySiteId);
                ResourceMapping queryRm = FsRecoveryUtil.getResourceMapping(props, (String)"productResourceProviderId", (String)localCloudSn);
                if (!VerifyUtil.isEmpty((Object)queryRm)) {
                    rm = queryRm;
                }
            }
            remoteCloudSn = rm.getRecoveryResourceProviderId();
            if (rm.getRecoveryResourceProviderId().equals(localCloudSn)) {
                remoteCloudSn = rm.getProductResourceProviderId();
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"ResourceMapping does not exist", 90160758787071L);
            throw e;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"get ResourceMapping by productResourceProviderId failed", 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return remoteCloudSn;
    }

    private String getRecoveryCloudSnForLocal(String localCloudSn, RecoveryPlan plan) {
        String array = FsRecoveryUtil.getGlobalSettingFromPlan((RecoveryPlan)plan, (String)"testHostCluster");
        JSONObject jObject = VrmRecoveryUtil.getMappingSettingFromPlan(array, "srcCloudId", localCloudSn);
        if (jObject.isEmpty()) {
            return localCloudSn;
        }
        return jObject.getString("remoteCloudId");
    }

    public List<GalaxVM> queryGalaxVMByVmUuids(Set<String> vmUuids) {
        return this.daoAdapter.queryGalaxVMByVmUuids(vmUuids);
    }

    public List<DataStore> getDataStoresByVmUuids(Set<String> vmUuids) {
        return this.daoAdapter.getDataStoresByVmUuids(vmUuids);
    }

    public List<GalaxVM> getGalaxVMsByDsg(String dsgId) {
        String[] dsgIds = new String[]{dsgId};
        List dsgs = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getDataStoreGroupByIds(dsgIds, ProtectionTypeEnum.STORAGE_REPLICATION.getValue());
        if (VerifyUtil.isEmpty((Collection)dsgs)) {
            throw new LegoCheckedException(1073947393L);
        }
        Set vmUuidSet = ((VirtualDataStoreGroup)dsgs.get(0)).getVmUuidSet();
        if (VerifyUtil.isEmpty((Collection)vmUuidSet)) {
            this.logger.error((Object)("there is no vm in datastore gourp, dsgId=" + dsgId), 90160758787071L);
            return null;
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)vmUuidSet.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        return CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
    }
}

