/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.connection;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageResponseHandler;
import com.huawei.lego.core.base.thread.MemeryContext;
import com.huawei.lego.core.sdk.exception.FusionStorageException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class FsbRestConnection
extends RestConnection {
    private static final Log LOGGER = LogFactory.getInstance(FsbRestConnection.class);
    private static final String X_AUTH_TOKEN = "X-Auth-Token";
    private static final String REFERER_HEADER = "Referer";
    private static final String BASIC_URL = "/dsware/service";
    private static final String LOGIN_URL = "/dsware/service/{version}/sec/login";
    private static final String LOGOUT_URL = "/dsware/service/{version}/sec/logout";
    private static final String DEVICE_SN_URL = "/dsware/service/{version}/cluster/sn";
    private static final String VERSION_URL = "/dsware/service/rest/version";
    private static final String SERVICE_CMD_URL = "serviceCmd";
    private static final int RETRY_TIMES = 3;
    private static final long INVALID_TOKEN_ERRCOED = 10000003L;
    private static final long INVALID_TOKEN_ERRCOED_FS8 = 1077949069L;
    private static final long USER_PWD_ERRCODE = 36002014L;
    private static final long USER_PWD_ERRCODE_FS8 = 1077987870L;
    private static final int RELEASE_PERIOD = 900000;
    private static final int MAX_FAILED_TIME = 2;
    private static final Set<String> WHITE_LIST_URL_SET = ImmutableSet.of((Object)"/v2/", (Object)"/dfv/");
    private static final String PLACEHOLDER_REGULAR_EXPRESSION = "^/?\\{[^}]+\\}.*";
    private AtomicInteger failedCounter = new AtomicInteger(0);
    private long firstFailedTime = -1L;
    private long secondFailedTime = -1L;
    private RestClient client;
    private String version;

    public FsbRestConnection(String ipAddress, int port, String username, String password) {
        super(ipAddress, port, username, password);
        FusionStorageResponseHandler handler = new FusionStorageResponseHandler();
        this.client = new RestClient(ipAddress, port, username, password, (IResponseHandler)handler, new String[0]);
        this.initVersion();
        LOGGER.debug((Object)"Get FusionStorage connect success. ipAddress=%s, port=%s", new Object[]{ipAddress, port});
    }

    private synchronized void incAuthFailedTimes() {
        if (this.failedCounter.get() >= 2) {
            return;
        }
        int times = this.failedCounter.incrementAndGet();
        if (times == 1) {
            this.firstFailedTime = System.currentTimeMillis();
            return;
        }
        if (times == 2) {
            this.secondFailedTime = System.currentTimeMillis();
        }
    }

    private synchronized void desAuthFailedTimes() {
        if (this.failedCounter.get() <= 0) {
            return;
        }
        int times = this.failedCounter.getAndDecrement();
        if (times == 2) {
            this.firstFailedTime = this.secondFailedTime;
            this.secondFailedTime = -1L;
            return;
        }
        if (times == 1) {
            this.secondFailedTime = -1L;
            this.firstFailedTime = -1L;
        }
    }

    private synchronized void resetAuthFailedTimes() {
        this.firstFailedTime = -1L;
        this.secondFailedTime = -1L;
        this.failedCounter.set(0);
    }

    private synchronized boolean canAuthentication() {
        String msg = MessageFormatUtil.format((String)"Connection:[{0}], failed auth time:[{1}], first fail time:[{2}]", (Object[])new Object[]{this.getIpAddress(), this.failedCounter.get(), String.valueOf(this.firstFailedTime)});
        LOGGER.debug((Object)msg);
        if (this.failedCounter.get() == 0) {
            return true;
        }
        long duration = System.currentTimeMillis() - this.firstFailedTime;
        if (duration >= 900000L) {
            String info = MessageFormatUtil.format((String)"First failed auth time duration:[{0}], move to next cycle.", (Object[])new Object[]{duration});
            LOGGER.debug((Object)info);
            this.desAuthFailedTimes();
            return true;
        }
        return this.failedCounter.get() < 2;
    }

    public synchronized void authenticate() {
        Header[] responseHeaders;
        ServiceResponse response;
        JSONObject message = new JSONObject();
        message.put((Object)"userName", (Object)this.getUserName());
        message.put((Object)"password", (Object)this.getPassword());
        HashMap headers = new HashMap();
        if (!this.canAuthentication()) {
            String errMsg = MessageFormatUtil.format((String)"auth to ip:[{0}] failed exceed max times:[{1}] in duration:[{2}], no need to do authentication", (Object[])new Object[]{this.getIpAddress(), this.failedCounter.get(), 900000});
            LOGGER.warn((Object)errMsg);
            throw new FusionStorageException(36002014L);
        }
        try {
            LOGGER.debug((Object)"Send login Msg: url =%s", new Object[]{LOGIN_URL});
            response = this.client.post(LOGIN_URL, message.toString(), this.builderUriVariables(LOGIN_URL), headers);
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() == 36002014L || ex.getErrorCode() == 1077987870L) {
                String errMsg = MessageFormatUtil.format((String)"authentication failed,ip:[{0}], error code:[{1}], increase failed times.", (Object[])new Object[]{this.getIpAddress(), String.valueOf(ex.getErrorCode())});
                LOGGER.error((Object)errMsg);
                this.incAuthFailedTimes();
            }
            throw ex;
        }
        this.resetAuthFailedTimes();
        for (Header header : responseHeaders = response.getResponseHeaders()) {
            String value = header.getValue();
            if (!X_AUTH_TOKEN.equals(header.getName()) || value == null) continue;
            this.setToken(value);
            break;
        }
        if (this.getToken() == null) {
            String errorMsg = "Login to FusionStorage failed. token is null.";
            LOGGER.error((Object)errorMsg, 90160758784000L);
            throw new LegoCheckedException(0x5000509L, errorMsg);
        }
        if (!this.updateDeviceId()) {
            LOGGER.error((Object)"The connection is not valid. ip=%s, devSn=%s.", new Object[]{this.getIpAddress(), SecurityUtil.desensitizeId((String)this.getDeviceId())});
            this.logout();
            throw new LegoCheckedException(1073947393L);
        }
    }

    public String getVersion() {
        return this.getVersion(false);
    }

    public String getVersion(boolean shouldCheck) {
        if (this.version == null && shouldCheck) {
            LOGGER.error((Object)"Get version from FSB failed. version is null and shouldCheck is true.");
            throw new LegoCheckedException(-1L);
        }
        return this.version;
    }

    public void logout() {
        try {
            LOGGER.debug((Object)"Send logout Msg to [%s:%s]: url=%s", new Object[]{this.getIpAddress(), this.getPort(), LOGIN_URL});
            this.client.post(LOGOUT_URL, null, this.builderUriVariables(LOGOUT_URL), this.builderTokenHeader());
        }
        catch (LegoCheckedException e) {
            String errorMsg = "Logout from FusionStorage failed";
            LOGGER.error((Object)errorMsg, (Throwable)e, 90160758784000L);
        }
    }

    private boolean updateDeviceId() {
        String response;
        try {
            response = this.retries(() -> this.client.get(DEVICE_SN_URL, this.builderUriVariables(DEVICE_SN_URL), this.builderTokenHeader()));
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Connect FusionStorage failed. connection info[ip=%s, port=%s, devSn=%s]", new Object[]{this.getIpAddress(), this.getPort(), SecurityUtil.desensitizeId((String)this.getDeviceId())});
            return false;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)response);
        String sn = jsonObject.getString("sn");
        if (sn == null) {
            LOGGER.debug((Object)"Connected FusionStorage sn is null. devId=%s, Response str=%s", new Object[]{SecurityUtil.desensitizeId((String)this.getDeviceId()), response});
            return false;
        }
        String deviceId = this.getDeviceId();
        if (deviceId != null && !"0".equals(deviceId) && !deviceId.equals(sn)) {
            LOGGER.debug((Object)"DeviceSN of FusionStorage has changed. deviceId=%s, response sn=%s", new Object[]{deviceId, SecurityUtil.desensitizeId((String)sn)});
            return false;
        }
        this.setDeviceId(sn);
        return true;
    }

    public boolean isConnected() {
        return this.updateDeviceId();
    }

    public boolean isValid() {
        return this.updateDeviceId();
    }

    public String post(String url, String message, Map<String, ?> uriVariables) {
        String finalUrl = this.complete(url);
        LOGGER.info((Object)"Send post Msg to [%s:%s]. urlStr=%s, message=%s, uriVariables=%s", new Object[]{this.client.getIp(), this.client.getPort(), finalUrl, message, uriVariables});
        String response = this.retries(() -> this.client.post(finalUrl, message, this.builderUriVariables(finalUrl, uriVariables), this.builderTokenHeader()));
        LOGGER.debug((Object)"Receive post Msg from [%s:%s]: response str=%s", new Object[]{this.client.getIp(), this.client.getPort(), response});
        return response;
    }

    public String post(String url, String message) {
        return this.post(url, message, null);
    }

    public String postForObject(String url, Object json) {
        return this.postForObject(url, json, null);
    }

    public String postForObject(String url, Object json, Map<String, ?> uriVariables) {
        return this.retries(() -> this.post(url, JSONObject.fromObject((Object)json).toString(), uriVariables));
    }

    <T> T retries(Supplier<T> action) {
        int retry = 0;
        LegoCheckedException ex = null;
        while (retry < 3) {
            try {
                return (T)MemeryContext.with((Object)"show.url", (Object)true, () -> action.get());
            }
            catch (LegoCheckedException e) {
                ex = e;
                if (e.getErrorCode() == 10000003L || e.getErrorCode() == 1077949069L) {
                    String message = MessageFormatUtil.format((String)"Connection:[{0}], Token became invalid, Need to retry the action. Retry times:[{1}]", (Object[])new Object[]{this.getIpAddress(), ++retry});
                    LOGGER.warn((Object)message);
                    this.authenticate();
                    continue;
                }
                LOGGER.error((Object)("Get other exception, no need to retry, connection:" + this.getIpAddress()));
                throw e;
            }
        }
        throw ex;
    }

    public String put(String url, String message, Map<String, ?> uriVariables) {
        String finalUrl = this.complete(url);
        LOGGER.info((Object)"Send put Msg to [%s:%s]: urlStr=%s, message=%s, uriVariables=%s", new Object[]{this.client.getIp(), this.client.getPort(), finalUrl, message, uriVariables});
        String response = this.retries(() -> this.client.put(finalUrl, message, this.builderUriVariables(finalUrl, uriVariables), this.builderTokenHeader()));
        LOGGER.info((Object)"Receive put Msg from [%s:%s]: response str=%s", new Object[]{this.client.getIp(), this.client.getPort(), response});
        return response;
    }

    public String delete(String url, String message, Map<String, ?> uriVariables) {
        String finalUrl = this.complete(url);
        LOGGER.info((Object)"Send delete Msg to [%s:%s]: urlStr=%s, message=%s, uriVariables=%s", new Object[]{this.client.getIp(), this.client.getPort(), finalUrl, message, uriVariables});
        String response = this.retries(() -> this.client.delete(finalUrl, message, this.builderUriVariables(finalUrl, uriVariables), this.builderTokenHeader()));
        LOGGER.info((Object)"Receive delete Msg from [%s:%s]: response str=%s", new Object[]{this.client.getIp(), this.client.getPort(), response});
        return response;
    }

    public String getForString(String url, Map<String, ?> uriVariables) {
        String finalUrl = this.complete(url);
        LOGGER.debug((Object)"Send get Msg to [%s:%s]: urlStr=%s, uriVariables=%s", new Object[]{this.client.getIp(), this.client.getPort(), finalUrl, uriVariables});
        String response = this.retries(() -> this.client.get(finalUrl, this.builderUriVariables(finalUrl, uriVariables), this.builderTokenHeader()));
        LOGGER.debug((Object)"Receive get Msg from [%s:%s]: response str=%s", new Object[]{this.client.getIp(), this.client.getPort(), response});
        return response;
    }

    public String getByFixUrl(String url) {
        String finalUrl = BASIC_URL + url;
        LOGGER.debug((Object)"Send get Msg to [%s:%s]: urlStr=%s", new Object[]{this.client.getIp(), this.client.getPort(), finalUrl});
        String response = this.retries(() -> this.client.get(finalUrl, null, this.builderTokenHeader()));
        LOGGER.debug((Object)"Receive get Msg from [%s:%s]: response str=%s", new Object[]{this.client.getIp(), this.client.getPort(), response});
        return response;
    }

    public JSONArray getStringBatch(String url, int pageSize) {
        boolean isFinished = false;
        JSONArray results = new JSONArray();
        String completeUrl = this.complete(url);
        int index = 0;
        while (!isFinished) {
            StringBuilder builder = new StringBuilder(completeUrl);
            builder.append(completeUrl.indexOf(63) != -1 ? (char)'&' : '?').append("range=[").append(index).append('-').append(index + pageSize).append(']');
            String query = builder.toString();
            LOGGER.debug((Object)"Send getBatch Msg to [%s:%s]: urlStr=%s", new Object[]{this.client.getIp(), this.client.getPort(), query});
            String jsonStr = this.retries(() -> this.client.get(query, this.builderUriVariables(query, null), this.builderTokenHeader()));
            JSONObject jsonResult = JSONObject.fromObject((Object)jsonStr);
            JSONArray dataValue = jsonResult.getJSONArray("data");
            if (dataValue == null) {
                LOGGER.error((Object)"Batch query request return empty data! Url: %s", new Object[]{completeUrl});
                throw new LegoCheckedException(2117645L);
            }
            LOGGER.debug((Object)"Receive getBatch Msg from [%s:%s]: response data size=%s", new Object[]{this.client.getIp(), this.client.getPort(), dataValue.size()});
            if (dataValue.size() != 0) {
                results.addAll((Collection)dataValue);
            }
            index += dataValue.size();
            if (dataValue.size() >= pageSize) continue;
            isFinished = true;
        }
        return results;
    }

    private List<Header> builderTokenHeader() {
        BasicHeader tokenHeader = new BasicHeader(X_AUTH_TOKEN, (Object)this.getToken());
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)tokenHeader);
        return headers;
    }

    private void initVersion() {
        StringBuilder refererValue = new StringBuilder("https://");
        refererValue.append(this.getIpAddress()).append("/rest.html");
        BasicHeader referer = new BasicHeader(REFERER_HEADER, (Object)refererValue.toString());
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(referer);
        String responseStr = this.client.get(VERSION_URL, null, headers);
        try {
            JSONObject responseJson = JSONObject.fromObject((Object)responseStr);
            if (responseJson != null) {
                this.version = responseJson.getString("currentVersion");
                LOGGER.debug((Object)"get FusionStorage version. version = %s", new Object[]{this.version});
            }
        }
        catch (LegoCheckedException e) {
            String errorMsg = "Cannot get version of FusionStorage REST interface. ipAddress is " + this.getIpAddress() + ", port is " + this.getPort();
            LOGGER.error((Object)errorMsg, (Throwable)e, 90160758784000L);
        }
    }

    private Map<String, String> builderUriVariables(String url) {
        return this.builderUriVariables(url, null);
    }

    private Map<String, String> builderUriVariables(String url, Map<String, ?> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params != null) {
            params.entrySet().stream().forEach(e -> {
                String cfr_ignored_0 = result.put((String)e.getKey(), Optional.ofNullable(e.getValue()).map(Object::toString).orElse(null));
            });
        }
        if (url.indexOf("{rest}") != -1) {
            result.put("rest", this.getBasicUrl(url) + '/' + this.getVersion(true));
        }
        if (url.indexOf("base") != -1) {
            result.put("base", this.getBasicUrl(url));
        }
        if (url.indexOf("{version}") != -1) {
            result.put("version", this.getVersion(true));
        }
        return result;
    }

    private String complete(String url) {
        block6: {
            block5: {
                if (VERSION_URL.equals(url)) break block5;
                if (!WHITE_LIST_URL_SET.stream().anyMatch(url::contains)) break block6;
            }
            return url;
        }
        String completeUrl = url;
        if (!completeUrl.matches(PLACEHOLDER_REGULAR_EXPRESSION)) {
            completeUrl = "/{rest}/" + completeUrl.replaceFirst("^/", "");
        }
        if (completeUrl.contains(SERVICE_CMD_URL)) {
            completeUrl = completeUrl.replace("rest", "base");
        }
        return completeUrl;
    }

    private String getBasicUrl(String url) {
        return url.startsWith("/") ? BASIC_URL.substring(1) : BASIC_URL;
    }
}

