/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.connection;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.AbstractRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class FsbRestConnectionManager
extends AbstractRestConnectionManager<FsbRestConnection> {
    private static final Log logger = LogFactory.getInstance(FsbRestConnectionManager.class);
    public static final String PROTOCOL_TYPE = "FSB-REST";
    private static final FsbRestConnectionManager INSTANCE = new FsbRestConnectionManager();
    private Map<String, FsbRestConnection> connectionMap = new HashMap<String, FsbRestConnection>();

    private FsbRestConnectionManager() {
    }

    public static FsbRestConnectionManager getInstance() {
        return INSTANCE;
    }

    public String getProtocolType() {
        return PROTOCOL_TYPE;
    }

    public FsbRestConnection castConnection(RestConnection connection) {
        if (connection instanceof FsbRestConnection) {
            return (FsbRestConnection)connection;
        }
        logger.error((Object)"Connection for device %s is not FusionStorageRestConnection type.", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
        throw new LegoCheckedException(1073947393L);
    }

    public FsbRestConnection buildConnection(String ipAddress, int port, String username, String password) {
        FsbRestConnection connection = this.getFsbRestConnection(ipAddress, port, username, password);
        connection.authenticate();
        return connection;
    }

    private FsbRestConnection getFsbRestConnection(String ipAddress, int port, String username, String password) {
        if (VerifyUtil.isEmpty(this.connectionMap) || !this.connectionMap.containsKey(ipAddress)) {
            this.connectionMap.put(ipAddress, new FsbRestConnection(ipAddress, port, username, password));
            return this.connectionMap.get(ipAddress);
        }
        FsbRestConnection conn = this.connectionMap.get(ipAddress);
        if (conn.getPort() != port || !conn.getUserName().equals(username) || !conn.getPassword().equals(password)) {
            conn = new FsbRestConnection(ipAddress, port, username, password);
            this.connectionMap.put(ipAddress, conn);
        }
        return conn;
    }

    protected Log getLogger() {
        return logger;
    }
}

