/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.connection;

import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.lego.core.sdk.exception.FusionStorageException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import org.apache.hc.core5.http.HttpRequest;

public class FusionStorageResponseHandler
implements IResponseHandler {
    private static final Log LOGGER = LogFactory.getInstance(FusionStorageResponseHandler.class);
    private static final int SUCCESS = 0;
    private static final String RESULT_KEY = "result";
    private static final String DESCRIBE_KEY = "describe";
    private static final String ERROR_CODE_KEY = "errorCode";
    private static final String ERROR_KEY = "error";
    private static final String CODE_KEY = "code";
    private static final String DESCRIPTION_KEY = "description";
    private static final String DETAIL_KEY = "detail";
    private static final int INTERNAL_SERVER_ERROR = 500;

    public void handleReponse(ServiceResponse response) {
        JSONObject jsonObject;
        String requestUri;
        if (response == null) {
            LOGGER.error((Object)"Response is empty.");
            throw new LegoCheckedException(1073947647L);
        }
        HttpRequest request = response.getRequest();
        String string = requestUri = request != null ? request.getRequestUri() : "";
        if (response.getStatusCode() == 404 || response.getStatusCode() >= 500) {
            String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Response status:[{1}], ResponseText:[{2}]", (Object[])new Object[]{requestUri, response.getStatusCode(), response.getResponseString()});
            LOGGER.error((Object)errorMsg);
            throw new LegoCheckedException(1073947395L);
        }
        String responseText = response.getResponseString();
        try {
            jsonObject = JSONObject.fromObject((Object)responseText);
        }
        catch (LegoCheckedException ex) {
            String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Cannot parse fs response text:[{1}], Response status:[{2}],error info :[{4}]", (Object[])new Object[]{requestUri, responseText, response.getStatusCode(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            LOGGER.error((Object)errorMsg);
            throw ex;
        }
        if (jsonObject.containsKey((Object)RESULT_KEY)) {
            this.extracted(requestUri, jsonObject);
        } else if (jsonObject.containsKey((Object)ERROR_KEY)) {
            this.handleErrorKey(jsonObject, requestUri);
        }
    }

    private void extracted(String requestUri, JSONObject jsonObject) {
        JSONArray jsonArray;
        int result = FusionStorageCommonUtil.getResultCode(jsonObject);
        if (result == 0) {
            return;
        }
        JSONObject newJsonObject = jsonObject;
        if (jsonObject.containsKey((Object)DETAIL_KEY) && !jsonObject.containsKey((Object)ERROR_CODE_KEY) && !VerifyUtil.isEmpty((Collection)(jsonArray = jsonObject.getJSONArray(DETAIL_KEY))) && jsonArray.iterator().hasNext()) {
            newJsonObject = JSONObject.fromObject(jsonArray.iterator().next());
        }
        this.handleResultKey(newJsonObject, result, requestUri);
    }

    private void handleErrorKey(JSONObject jsonObject, String requestUri) {
        JSONObject errorValue = jsonObject.getJSONObject(ERROR_KEY);
        long errorCode = errorValue.getInt(CODE_KEY);
        if (errorCode != 0L) {
            String errorInfo = errorValue.getString(DESCRIPTION_KEY);
            String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Response Error Info:[{1}], errorCode:[{2}]", (Object[])new Object[]{requestUri, errorInfo, String.valueOf(errorCode)});
            LOGGER.error((Object)errorMsg);
            throw new FusionStorageException(errorCode, errorInfo);
        }
    }

    private void handleResultKey(JSONObject jsonObject, long result, String requestUri) {
        String errorInfo = "";
        long errorCode = result;
        if (jsonObject.containsKey((Object)ERROR_CODE_KEY)) {
            errorCode = jsonObject.getLong(ERROR_CODE_KEY);
            errorInfo = jsonObject.getString(DESCRIPTION_KEY);
        } else if (jsonObject.containsKey((Object)DESCRIBE_KEY)) {
            errorInfo = jsonObject.getString(DESCRIBE_KEY);
        } else if (jsonObject.getJSONObject(RESULT_KEY).containsKey((Object)DESCRIPTION_KEY)) {
            errorInfo = jsonObject.getJSONObject(RESULT_KEY).getString(DESCRIPTION_KEY);
        } else {
            LOGGER.warn((Object)"Can't find request:%s error info.", new Object[]{requestUri});
        }
        String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Response Error Info:[{1}], errorCode:[{2}]", (Object[])new Object[]{requestUri, errorInfo, String.valueOf(errorCode)});
        LOGGER.error((Object)errorMsg);
        throw new FusionStorageException(errorCode, errorInfo);
    }
}

