/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.discovery;

import com.huawei.ism.cbb.proxy.service.IDevProtocolCollect;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.Map;

public class FusionStorageRestProtocolCollect
implements IDevProtocolCollect {
    public static final String SYS_OID_REST = "huawei-fusionstorage";
    public static final String MANAGEMENT_PROTOCOL_TYPE = "FSB-REST";
    private static final Log LOGGER = LogFactory.getInstance(FusionStorageRestProtocolCollect.class);

    public String getProtocolName() {
        return MANAGEMENT_PROTOCOL_TYPE;
    }

    public boolean collectInfo(DiscoveryPolicy discoveryPolicy, Map<String, String> extendParam) {
        LOGGER.debug((Object)"try to connect fusionstorage block device.");
        FsbRestConnection connection = this.initRestConnection(discoveryPolicy);
        String version = connection.getVersion();
        if (!VerifyUtil.isEmpty((String)version)) {
            LOGGER.info((Object)"match fusion storage rest protocol success!");
            this.updateExtendParam(extendParam);
            return true;
        }
        return false;
    }

    private void updateExtendParam(Map<String, String> extendParam) {
        extendParam.put("sysOid", SYS_OID_REST);
        extendParam.put("managementProtocol", MANAGEMENT_PROTOCOL_TYPE);
        extendParam.put("protocol", MANAGEMENT_PROTOCOL_TYPE);
    }

    private FsbRestConnection initRestConnection(DiscoveryPolicy discoveryPolicy) {
        FsbRestConnection connection = null;
        if (null == discoveryPolicy) {
            LOGGER.error((Object)"discovery policy is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String ip = discoveryPolicy.getStartIP();
        Map paramMap = discoveryPolicy.getParamMap();
        String username = (String)paramMap.get("name");
        String password = (String)paramMap.get("password");
        password = DiscParamValidator.decodeByLength((String)password);
        if (VerifyUtil.isEmpty((String)username) || VerifyUtil.isEmpty((String)password)) {
            LOGGER.error((Object)"username or password is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String port = (String)paramMap.get("port");
        if (VerifyUtil.isEmpty((String)port)) {
            port = ResourceHelper.getValue((String)"fsb.port");
        }
        connection = new FsbRestConnection(ip, NumberUtil.parseInteger((Object)port), username, password);
        LOGGER.debug((Object)"construct fusionstorage rest connection success.");
        return connection;
    }
}

