/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.discovery.process;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnectionManager;
import com.huawei.ism.drm.storage.fsb.eumn.HyperMetroOperateEnum;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.BatchQueryHyperMetroPairReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.ControlClusterServiceCmd;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.ControlClustersResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroPairServiceCmd;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HypermetroPairResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.QueryControlClusterReq;
import com.huawei.ism.drm.storage.fsb.util.BeanConverter;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageRestTransition;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.util.ManagedObjectUtil;
import com.huawei.lego.core.sdk.exception.FusionStorageException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FusionStorageInfoRetriver
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(FusionStorageInfoRetriver.class);
    private static final int PAGE_SIZE = 40;
    private static final int LINK_PAGE_SIZE = 100;
    private static final int LUN_PAGE_SIZE = 1000;
    private static final int LUN_MAX_PAGE = 650;
    private static final String SERVICE_TYPE = "dr";
    private static final String OP_CMD = "drCmd";
    private static final int DEFAULT_HYPER_METRO_START_ID = 0;

    public boolean process(AbstractContext context) {
        StorageNE storage = (StorageNE)context.getAttribute("StorageDevice", StorageNE.class);
        if (null == storage) {
            logger.error((Object)"storageDevice is null.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)("begin to retrieve fusionstorage resource, sn:" + SecurityUtil.desensitizeId((String)storage.getSn())));
        FsbRestConnection connection = (FsbRestConnection)FsbRestConnectionManager.getInstance().getConnection(storage.getSn());
        FusionStorageUnit fusionStorageUnit = this.queryStorageUnit(connection);
        StorageNE storageNE = new StorageNE();
        this.processStorage(storageNE, fusionStorageUnit);
        Collection<StoragePool> pools = this.queryFusionStoragePools(connection, fusionStorageUnit);
        pools.forEach(pool -> this.queryFusionStorageLuns(connection, (StoragePool)pool));
        this.queryFusionStorageLinks(connection, fusionStorageUnit);
        this.queryFusionStorageReplicationPairs(connection, fusionStorageUnit);
        this.queryFusionStorageReplicationGroups(connection, fusionStorageUnit);
        this.queryFusionStorageInitiator(connection, fusionStorageUnit);
        this.queryFusionStorageBlockClient(connection, fusionStorageUnit);
        this.queryFusionStorageHyperMetroPairs(connection, fusionStorageUnit);
        context.setAttribute("ArrayUnit", (Object)fusionStorageUnit);
        context.setAttribute("StorageArray", (Object)storageNE);
        logger.debug((Object)"Retrieve fusionstorage resource finished.");
        return true;
    }

    private void processStorage(StorageNE storage, FusionStorageUnit unit) {
        storage.setProductModel(unit.getProductModel());
        storage.addChildMo((ManagedObject)unit);
        storage.setName(unit.getName());
        storage.setMainType(unit.getMainType());
        storage.setSubType(unit.getSubType());
        storage.setUuid("FSB_Storage:" + unit.getDevSn());
        storage.setSn(unit.getDevSn());
        storage.setIpAddress(unit.getIpAddress());
        storage.setLinkIp(unit.getLinkIp());
        storage.setIsTopMo(Boolean.valueOf(true));
        storage.setManaged(Boolean.valueOf(true));
        storage.setManufacturer("ism.storage.manufacture.0huawei");
        storage.setManagementProtocol("FSB-REST");
        unit.setParentMo((ManagedObject)storage);
        unit.setTopMoUuid(storage.getUuid());
        unit.setManaged(Boolean.valueOf(true));
    }

    private FusionStorageUnit queryStorageUnit(FsbRestConnection connection) {
        String result = connection.getForString("/systemSummary", null);
        logger.debug((Object)"query FusionStorage Unit from [ip:%s, sn=%s] finished. response str=%s", new Object[]{connection.getIpAddress(), SecurityUtil.desensitizeId((String)connection.getDeviceId()), result});
        FusionStorageUnit unit = FusionStorageRestTransition.transitionStorageUnit(connection.getDeviceId(), result);
        if (null != unit) {
            unit.setIpAddress(connection.getIpAddress());
            unit.setLinkIp(connection.getIpAddress());
        }
        return unit;
    }

    private Collection<StoragePool> queryFusionStoragePools(FsbRestConnection connection, FusionStorageUnit unit) {
        logger.debug((Object)"query storagepool start. SN:%s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
        String responseStr = connection.getForString("/storagePool", null);
        JSONObject responseJson = JSONObject.fromObject((Object)responseStr);
        JSONArray jsonPoolArray = responseJson.getJSONArray("storagePools");
        if (null == jsonPoolArray) {
            logger.error((Object)"Query StoragePools return empty. devSn=%s,response=%s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId()), responseStr});
            throw new LegoCheckedException(2117645L);
        }
        List<StoragePool> list = jsonPoolArray.filter(JSONObject.class).stream().map(pool -> FusionStorageRestTransition.transitionStoragePool(connection.getDeviceId(), pool)).collect(Collectors.toList());
        ManagedObjectUtil.associate(list, (ManagedObject)unit);
        logger.debug((Object)"query storagepool finished, size:%s, SN:%s", new Object[]{String.valueOf(list.size()), SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return list;
    }

    private Collection<XveLun> queryFusionStorageLuns(FsbRestConnection connection, StoragePool pool) {
        ArrayList<XveLun> luns = new ArrayList<XveLun>();
        int currentPage = 1;
        int pageSize = 1000;
        boolean notFinished = true;
        logger.debug((Object)"query volume start. SN:%s, pool:%s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId()), pool.getPoolId()});
        while (notFinished) {
            JSONObject param = new JSONObject();
            param.put((Object)"poolId", (Object)pool.getPoolId());
            param.put((Object)"pageNum", (Object)String.valueOf(currentPage));
            param.put((Object)"pageSize", (Object)String.valueOf(pageSize));
            String responseStr = connection.post("/volume/list", param.toString(), null);
            JSONObject responseJson = JSONObject.fromObject((Object)responseStr);
            JSONArray jsonLunArray = responseJson.getJSONArray("volumeList");
            if (null == jsonLunArray) {
                logger.warn((Object)("Query FusionStorage VolumeList return empty Data, JSON:" + responseStr));
                throw new LegoCheckedException(2117645L);
            }
            List tmpList = jsonLunArray.filter(JSONObject.class).stream().map(lunObj -> {
                XveLun lun = FusionStorageRestTransition.transitionLun(connection.getDeviceId(), lunObj);
                lun.setStoragePoolName(pool.getName());
                return lun;
            }).collect(Collectors.toList());
            ManagedObjectUtil.associate(tmpList, (ManagedObject)pool);
            luns.addAll(tmpList);
            if (jsonLunArray.size() >= pageSize && ++currentPage <= 650) continue;
            notFinished = false;
        }
        logger.debug((Object)"query volume finished, SN:%s, pool:%s, Lun size:%d", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId()), pool.getPoolId(), luns.size()});
        return luns;
    }

    private Collection<ReplicationLink> queryFusionStorageLinks(FsbRestConnection connection, FusionStorageUnit unit) {
        JSONObject firstObj;
        JSONArray replicationLinksArray;
        logger.debug((Object)"query storage link start. SN:%s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
        try {
            replicationLinksArray = connection.getStringBatch("/remote_device", 100);
        }
        catch (FusionStorageException ex) {
            return Collections.emptyList();
        }
        if (null == replicationLinksArray || replicationLinksArray.size() <= 0) {
            logger.debug((Object)"replication link query response from storage[%s] is null or empty.", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
            return Collections.emptyList();
        }
        if (!(replicationLinksArray.size() != 1 || (firstObj = replicationLinksArray.getJSONObject(0)).containsKey((Object)"id") && firstObj.containsKey((Object)"system_wwn"))) {
            logger.debug((Object)"storage[%s] has no replication link info .", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
            return Collections.emptyList();
        }
        List<ReplicationLink> replicationLinks = replicationLinksArray.filter(JSONObject.class).stream().map(jsonObject -> FusionStorageRestTransition.transitionReplicationLink(connection.getDeviceId(), jsonObject)).collect(Collectors.toList());
        ManagedObjectUtil.associate(replicationLinks, (ManagedObject)unit);
        logger.debug((Object)"query storage link finish. size:%s, SN:%s", new Object[]{String.valueOf(replicationLinks.size()), SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return replicationLinks;
    }

    private Collection<Initiator> queryFusionStorageInitiator(FsbRestConnection connection, FusionStorageUnit unit) {
        logger.debug((Object)"query initiator start. SN:%s", new Object[]{SecurityUtil.desensitizeId((String)unit.getDevSn())});
        String result = connection.postForObject("/port/list", null);
        JSONObject jsonResult = JSONObject.fromObject((Object)result);
        JSONArray dataValue = jsonResult.getJSONArray("data");
        if (null == dataValue) {
            logger.error((Object)"Query FusionStorage Initiator return empty data, connection dev =%s,response=%s:", new Object[]{connection.getDeviceId(), result});
            throw new LegoCheckedException(2117645L);
        }
        List<Initiator> initiators = dataValue.filter(JSONObject.class).stream().map(jsonObject -> FusionStorageRestTransition.transitionInitiator(connection.getDeviceId(), jsonObject)).collect(Collectors.toList());
        ManagedObjectUtil.associate(initiators, (ManagedObject)unit);
        logger.debug((Object)"query initiator finish. size:%s, SN:%s", new Object[]{String.valueOf(initiators.size()), SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return initiators;
    }

    private Collection<Initiator> queryFusionStorageBlockClient(FsbRestConnection connection, FusionStorageUnit unit) {
        logger.debug((Object)"query BlockClient start. SN:%s", new Object[]{connection.getDeviceId()});
        String responseStr = connection.getByFixUrl("/cluster/dswareclient/queryDSwareClientHost");
        JSONObject responseJson = JSONObject.fromObject((Object)responseStr);
        JSONArray jsonPoolArray = responseJson.getJSONArray("clients");
        if (null == jsonPoolArray) {
            logger.error((Object)"Query BlockClient return empty. devSn: %s,response: %s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId()), responseStr});
            return Collections.emptyList();
        }
        List<Initiator> initiators = jsonPoolArray.filter(JSONObject.class).stream().map(blockClient -> FusionStorageRestTransition.transitionBlockClient(connection.getDeviceId(), blockClient)).collect(Collectors.toList());
        ManagedObjectUtil.associate(initiators, (ManagedObject)unit);
        logger.debug((Object)"query BlockClient finished, SN\uff1a%s", new Object[]{SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return initiators;
    }

    private Collection<ReplicationPair> queryFusionStorageReplicationPairs(FsbRestConnection connection, FusionStorageUnit unit) {
        JSONArray pairsArray;
        logger.debug((Object)"query replication pair begin.SN:%s", new Object[]{SecurityUtil.desensitizeId((String)unit.getDevSn())});
        try {
            pairsArray = connection.getStringBatch("/REPLICATIONPAIR", 40);
        }
        catch (FusionStorageException ex) {
            return Collections.emptyList();
        }
        List<ReplicationPair> pairs = pairsArray.filter(JSONObject.class).stream().map(item -> FusionStorageRestTransition.transitionReplicationPair(connection.getDeviceId(), item, unit.getTopMoUuid())).collect(Collectors.toList());
        ManagedObjectUtil.associate(pairs, (ManagedObject)unit);
        logger.debug((Object)"query replication pair finished. pair size:%s, SN:%s", new Object[]{String.valueOf(pairs.size()), SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return pairs;
    }

    private Collection<HypermetroPair> queryFusionStorageHyperMetroPairs(FsbRestConnection connection, FusionStorageUnit unit) {
        String devSn = unit.getDevSn();
        logger.debug((Object)"query hypermetro pair begin.SN:%s", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
        List<Integer> clusterIdList = this.queryClusterId(connection);
        HashSet<HypermetroPair> hypermetroPairs = new HashSet<HypermetroPair>();
        for (Integer id : clusterIdList) {
            String strId = String.valueOf(id);
            hypermetroPairs.addAll(this.queryHyperMetroPair(connection, devSn, strId));
        }
        Iterator iterator = hypermetroPairs.iterator();
        while (iterator.hasNext()) {
            HypermetroPair pair = (HypermetroPair)iterator.next();
            String pairId = pair.getId();
            String localObjId = pair.getLocalobjid();
            String remoteId = pair.getRemoteobjid();
            if (VerifyUtil.isEmpty((String)pairId) || VerifyUtil.isEmpty((String)localObjId) || VerifyUtil.isEmpty((String)remoteId)) {
                iterator.remove();
                logger.warn((Object)"Pair info is wrong. (%s)", new Object[]{pair.toString()});
                continue;
            }
            pair.setTopMoUuid(unit.getTopMoUuid());
            String uuid = CommUtil.combineString((String[])new String[]{"pair", unit.getUuid(), UUIDGenerator.getUUID()});
            pair.setUuid(uuid);
        }
        ManagedObjectUtil.associate(hypermetroPairs, (ManagedObject)unit);
        logger.debug((Object)"query hypermetro pair finished. pair size:%s, SN:%s", new Object[]{String.valueOf(hypermetroPairs.size()), SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return hypermetroPairs;
    }

    private List<Integer> queryClusterId(FsbRestConnection connection) {
        QueryControlClusterReq queryControlClusterReq = new QueryControlClusterReq();
        queryControlClusterReq.setServiceType(SERVICE_TYPE);
        queryControlClusterReq.setSubOp(HyperMetroOperateEnum.QUERY_CONTROL_CLUSTER.getName());
        queryControlClusterReq.setOp(OP_CMD);
        String result = connection.postForObject("/serviceCmd", JSONObject.fromObject((Object)queryControlClusterReq));
        ControlClustersResponse controlClustersResponse = (ControlClustersResponse)JSONObject.toBean((String)result, ControlClustersResponse.class);
        ArrayList<Integer> clusterIdList = new ArrayList<Integer>();
        if (VerifyUtil.isEmpty((Object)controlClustersResponse)) {
            return Collections.emptyList();
        }
        for (ControlClusterServiceCmd item : controlClustersResponse.getServiceCmdData()) {
            clusterIdList.add(item.getControlClusterId());
        }
        return clusterIdList;
    }

    private List<HypermetroPair> queryHyperMetroPair(FsbRestConnection connection, String devSn, String clusterId) {
        String controlClusterId = String.valueOf(clusterId);
        BatchQueryHyperMetroPairReq batchQueryHyperMetroPairReq = new BatchQueryHyperMetroPairReq();
        batchQueryHyperMetroPairReq.setControlClusterId(controlClusterId);
        batchQueryHyperMetroPairReq.setId(0);
        batchQueryHyperMetroPairReq.setServiceType(SERVICE_TYPE);
        batchQueryHyperMetroPairReq.setSubOp(HyperMetroOperateEnum.GET_BATCH_HYPER_METRO_PAIR.getName());
        batchQueryHyperMetroPairReq.setCount(20);
        batchQueryHyperMetroPairReq.setOp(OP_CMD);
        ArrayList<HyperMetroPairServiceCmd> cmdList = new ArrayList<HyperMetroPairServiceCmd>();
        HypermetroPairResponse response = null;
        while (response == null || response.getServiceCmdData().size() == 20) {
            String result = connection.postForObject("/serviceCmd", JSONObject.fromObject((Object)batchQueryHyperMetroPairReq));
            response = (HypermetroPairResponse)JSONObject.toBean((String)result, HypermetroPairResponse.class);
            if (response == null) continue;
            cmdList.addAll(response.getServiceCmdData());
            batchQueryHyperMetroPairReq.setId(batchQueryHyperMetroPairReq.getId() + 20);
        }
        if (VerifyUtil.isEmpty((Object)response)) {
            return Collections.emptyList();
        }
        return BeanConverter.convertListWithClass(cmdList, HypermetroPair.class, null, (sourceObject, targetObject) -> {
            targetObject.setSrcDevSN(devSn);
            targetObject.setDomainid(sourceObject.getDomainId());
            targetObject.setRemoteobjid(String.valueOf(sourceObject.getRemoteObjID()));
            targetObject.setLocalobjid(String.valueOf(sourceObject.getLocalObjID()));
            targetObject.setHealthstatus(sourceObject.getHealthStatus());
            targetObject.setRunningState(sourceObject.getRunningStatus());
            targetObject.setHcresourcetype(sourceObject.getHcResourceType());
            targetObject.setControlClusterId(controlClusterId);
            targetObject.setLocalobjname(sourceObject.getLocalObjName());
            targetObject.setRemoteobjname(sourceObject.getRemoteObjName());
        }).stream().filter(hypermetroPair -> StringUtils.isNotEmpty((CharSequence)hypermetroPair.getId())).collect(Collectors.toList());
    }

    private Collection<ReplicationGroup> queryFusionStorageReplicationGroups(FsbRestConnection connection, FusionStorageUnit unit) {
        JSONArray repGroups;
        logger.debug((Object)"query replication group start. SN: %s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
        try {
            repGroups = connection.getStringBatch("/CONSISTENTGROUP", 40);
        }
        catch (FusionStorageException ex) {
            logger.error((Throwable)ex, (Object)"query replication error. SN: %s", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
            return Collections.emptyList();
        }
        List<ReplicationGroup> replicationGroups = repGroups.filter(JSONObject.class).stream().map(replicationGroupJson -> FusionStorageRestTransition.transitionReplicationGroup(connection.getDeviceId(), replicationGroupJson)).collect(Collectors.toList());
        ManagedObjectUtil.associate(replicationGroups, (ManagedObject)unit);
        logger.debug((Object)"query replication group finished. size:%s, SN:%s", new Object[]{String.valueOf(replicationGroups.size()), SecurityUtil.desensitizeId((String)unit.getDevSn())});
        return replicationGroups;
    }

    public void postProcess(AbstractContext context) {
        logger.info((Object)"nothing need to process in this phase.");
    }

    public void clean(AbstractContext context) {
        logger.info((Object)"nothing need to clean.");
    }
}

