/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.factory;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaExtendTools;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.protection.replica.factory.AbstractReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CloneVolumeReplicaFactory
extends AbstractReplicaFactory {
    private static Log logger = LogFactory.getInstance(CloneVolumeReplicaFactory.class);

    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        ProtectGroupReplica cloneReplica = null;
        try {
            cloneReplica = (ProtectGroupReplica)sourceReplica.clone();
            cloneReplica.setId(UUIDGenerator.getUUID());
            cloneReplica.setName(this.buildReplicaName(sourceReplica));
            cloneReplica.setSourceReplicaId(sourceReplica.getId());
            cloneReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            cloneReplica.setMountedHost("");
            cloneReplica.addProperty("planId", null);
            cloneReplica.setGeneration(Integer.valueOf(2));
            StorageSnapshotManagerProxy proxy = StorageSnapshotManagerProxy.getInstance();
            String devId = sourceReplica.getRecoveryArray();
            IStorageSnapshotManager snapshotManager = proxy.getStorageSnapshotMgrByDevId(devId);
            Set replicaList = cloneReplica.getReplicas();
            HashMap<String, Snapshot> context = new HashMap<String, Snapshot>();
            for (ProtectObjectReplica protectObjectReplica : replicaList) {
                RelicaStorageInfo storageInfo;
                protectObjectReplica.setId(UUIDGenerator.getUUID());
                Set protectObjectStorageList = protectObjectReplica.getStorageInfos();
                Iterator iterator = protectObjectStorageList.iterator();
                while (iterator.hasNext() && (storageInfo = (RelicaStorageInfo)iterator.next()) instanceof LocalStorageReplica) {
                    storageInfo.setId(UUIDGenerator.getUUID());
                    String devSn = storageInfo.getSrcStorageProviderSN();
                    String srcSnapshotId = storageInfo.getStorageId();
                    String srcLun = storageInfo.getSrcStorageId();
                    String copyName = "CloneFrom_" + srcLun + "_" + System.currentTimeMillis();
                    Snapshot snapshot = (Snapshot)context.get(storageInfo.getSrcStorageId());
                    if (null == snapshot) {
                        snapshot = snapshotManager.copySnapshot(devSn, srcSnapshotId, copyName);
                        context.put(storageInfo.getSrcStorageId(), snapshot);
                    }
                    storageInfo.setStorageId(snapshot.getId());
                    ((LocalStorageReplica)storageInfo).setSnapshotName(copyName);
                }
            }
            cloneReplica.setType(9);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"An error occurred while cloning a copy");
        }
        return cloneReplica;
    }

    public boolean validReplica(ProtectGroupReplica replica, boolean needHandleException) {
        return CheckReplicaExtendTools.checkSnapshotCorrect((ProtectGroupReplica)replica, (boolean)needHandleException);
    }

    protected void deleteReplica(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String devSn = replica.getStorageDeviceId();
        String deviceType = recoveryService.getStorageType(devSn);
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        replica.getReplicas().stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
            Set storageReplicaList = item.getStorageInfos();
            storageReplicaList.stream().filter(si -> !VerifyUtil.isEmpty((Object)si)).forEach(si -> {
                try {
                    proxy.deleteLun(devSn, null, ((LocalStorageReplica)si).getSnapshotName());
                }
                catch (Exception e) {
                    this.dealDeleteReplicaException(devSn, ((LocalStorageReplica)si).getSnapshotName(), e, isNeedSendAlarm);
                }
            });
        });
    }

    private void dealDeleteReplicaException(String devSn, String name, Exception e, boolean isNeedSendAlarm) {
        logger.error((Object)("delete repica error.name:" + name), (Throwable)e);
        if (isNeedSendAlarm) {
            String ipAddress = this.getIpAddress(devSn);
            String[] params = new String[]{name, ipAddress};
            AlarmReporter.sendAlarm((String)"0x3230061", null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])params);
        } else {
            ExceptionUtil.rethrowException((Throwable)e, (String)"delete Snapshot error.", (long)1073948679L, null, (Log)logger);
        }
    }

    public int getFactoryType() {
        return 9;
    }
}

