/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HypermetroConstantDefine;
import com.huawei.ism.drm.storage.constant.HcResourceType;
import com.huawei.ism.drm.storage.constant.RecoveryPolicy;
import com.huawei.ism.drm.storage.fsb.eumn.CpType;
import com.huawei.ism.drm.storage.fsb.eumn.HyperMetroDomainType;
import com.huawei.ism.drm.storage.fsb.eumn.HyperMetroOperateEnum;
import com.huawei.ism.drm.storage.fsb.eumn.PriorityStationType;
import com.huawei.ism.drm.storage.fsb.handler.FusionStorageHyperMetroHandler;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.BaseHyperMetroResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.BatchQueryHyperMetroDomainReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.BatchQueryHyperMetroPairReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.ControlClusterServiceCmd;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.ControlClustersResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.CreateHyperMetroConsistentGroupReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.CreateHypermetroPairReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.DeleteConsistentGroupReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.DeleteHyperMetroPairReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.DisableHyperMetroPairReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.DisabledConsistentGroupReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroConsistentGroupCmdData;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroConsistentGroupResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroDomainResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroPairServiceCmd;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroPairToConsistentGroupReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HyperMetroServiceCmd;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.HypermetroPairResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.QueryConsistentGroup;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.QueryControlClusterReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.QueryHyperMetroPairReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.QueryHyperMetroPairToConsistentGroupReq;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.StartHyperMetroGroupResponse;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.SwapHyperMetroCgRep;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.SwapHyperMetroPairRep;
import com.huawei.ism.drm.storage.fsb.model.hypermetro.SyncPairToConsistentGroupReq;
import com.huawei.ism.drm.storage.fsb.service.IFusionStorageCommonManager;
import com.huawei.ism.drm.storage.fsb.util.BeanConverter;
import com.huawei.ism.drm.storage.manager.sdk.model.ControlCluster;
import com.huawei.ism.drm.storage.manager.sdk.model.StorageHyperMetroDomain;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroEnumDefine;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.topo.utils.TopoBuildUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FusionStorageHyperMetroManagerAdapter
implements IStorageHyperMetroManager,
IFusionStorageCommonManager {
    private static final String SERVICE_TYPE = "dr";
    private static final String OP_CMD = "drCmd";
    private static final int DEFAULT_HYPER_METRO_START_ID = 0;
    private static final int DEFAULT_HYPER_METRO_COUNT = 2;
    private static final String HYPER_METRO_PAIR = "HyperMetroPair";
    private static final int METRO_PAIR_REQ_COUNT = 20;
    private static final Map<String, HypermetroEnumDefine.RUNNING_STATE> RUNNING_STATUS_MAP = ImmutableMap.builder().put((Object)"PAUSE", (Object)HypermetroEnumDefine.RUNNING_STATE.PAUSE).put((Object)"SYNCHRONIZING", (Object)HypermetroEnumDefine.RUNNING_STATE.SYNCHRONIZING).put((Object)"NORMAL", (Object)HypermetroEnumDefine.RUNNING_STATE.NORMAL).build();
    private static final List<String> NORMAL_RUNNING_STATUS = ImmutableList.builder().add((Object)HypermetroConstantDefine.PairRunningStatus.NORMAL.getStatus()).add((Object)HypermetroConstantDefine.PairRunningStatus.SYNCHRONIZING.getStatus()).add((Object)HypermetroConstantDefine.PairRunningStatus.FORCE_STARTED.getStatus()).add((Object)HypermetroConstantDefine.PairRunningStatus.TO_BE_SYNCHRONIZED.getStatus()).add((Object)HypermetroConstantDefine.PairRunningStatus.CREATING.getStatus()).build();
    private static final List<String> NORMAL_HEALTH_STATUS = ImmutableList.of((Object)HypermetroConstantDefine.HealthStatus.NORMAL.getStatus()).asList();
    private FusionStorageHyperMetroHandler fusionStorageHyperMetroHandler;

    public void setFusionStorageHyperMetroHandler(FusionStorageHyperMetroHandler fusionStorageHyperMetroHandler) {
        this.fusionStorageHyperMetroHandler = fusionStorageHyperMetroHandler;
    }

    public HyperMetroPair queryHyperMetroPair(String devSn, String pairId, String vstoreId) {
        return null;
    }

    public List<HyperMetroPair> queryHyperMetroPairsByCg(String devSn, String cgId) {
        return null;
    }

    public HyperMetroConsistentGroup queryHyperMetroCGroup(String devSn, String cgId) {
        return null;
    }

    public List<QuorumServerLink> queryQuorumServerLinks(String devSn, String serverId) {
        return null;
    }

    public void synchronize(String devSn, String id, boolean isCg, String vstoreId) {
    }

    public void disable(String devSn, String id, DrmEnumDefine.RoleType role, boolean isCg, String vstoreId) {
    }

    public void swap(String devSn, String id, Integer resourceType, boolean isCg) {
        TopoBuildUtil.logger.debug((Object)"Enter swap, sn=%s, id=%s, resourceType=%d, isCg=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), id, resourceType, isCg});
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.swapHyperMetroConsistentGroup(devSn, id);
        } else {
            this.swapHyperMetroPair(devSn, null, id);
        }
    }

    public void startup(String devSn, String pairId) {
    }

    public void shutdown(String devSn, String pairId) {
    }

    public List<HyperMetroPair> queryHyperMetroPairs(String devSn, String vstoreId) {
        return null;
    }

    public List<StorageHyperMetroDomain> queryHypermetroDomain(String devSn, String remoteSn, String controlClusterId) {
        BatchQueryHyperMetroDomainReq queryHyperMetroDomainReq = new BatchQueryHyperMetroDomainReq();
        queryHyperMetroDomainReq.setId(0);
        queryHyperMetroDomainReq.setCount(2);
        queryHyperMetroDomainReq.setControlClusterId(controlClusterId);
        queryHyperMetroDomainReq.setServiceType(SERVICE_TYPE);
        queryHyperMetroDomainReq.setSubOp(HyperMetroOperateEnum.BATCH_QUERY_HYPER_METRO_DOMAIN.getName());
        HyperMetroDomainResponse response = this.fusionStorageHyperMetroHandler.batchQueryHyperMetroDomain(devSn, queryHyperMetroDomainReq);
        ArrayList<StorageHyperMetroDomain> list = new ArrayList<StorageHyperMetroDomain>();
        for (HyperMetroServiceCmd hyperMetroServiceCmd : response.getServiceCmdData()) {
            StorageHyperMetroDomain hyperMetroDomain = new StorageHyperMetroDomain();
            hyperMetroDomain.setCpType(Integer.valueOf(CpType.getCpTypeByName(hyperMetroServiceCmd.getCpType()).getValue()));
            hyperMetroDomain.setDomainType(Integer.valueOf(HyperMetroDomainType.getHyperMetroDomainTypeByName(hyperMetroServiceCmd.getDomainType()).getValue()));
            hyperMetroDomain.setRunningStatus(hyperMetroServiceCmd.getRunningStatus());
            hyperMetroDomain.setRemoteDeviceId(hyperMetroServiceCmd.getRemoteDeviceId());
            hyperMetroDomain.setName(hyperMetroServiceCmd.getName());
            hyperMetroDomain.setType(hyperMetroServiceCmd.getType());
            hyperMetroDomain.setHyperMetroDomainId(hyperMetroServiceCmd.getHyperMetroDomainId());
            list.add(hyperMetroDomain);
        }
        return list;
    }

    public List<ControlCluster> queryControlClusters(String cloudSn) {
        QueryControlClusterReq queryControlClusterReq = new QueryControlClusterReq();
        queryControlClusterReq.setServiceType(SERVICE_TYPE);
        queryControlClusterReq.setSubOp(HyperMetroOperateEnum.QUERY_CONTROL_CLUSTER.getName());
        queryControlClusterReq.setOp(OP_CMD);
        ControlClustersResponse controlClustersResponse = this.fusionStorageHyperMetroHandler.queryControlCluster(cloudSn, queryControlClusterReq);
        ArrayList<ControlCluster> list = new ArrayList<ControlCluster>();
        for (ControlClusterServiceCmd controlClusterServiceCmd : controlClustersResponse.getServiceCmdData()) {
            ControlCluster controlCluster = new ControlCluster();
            controlCluster.setClusterName(controlClusterServiceCmd.getClusterName());
            controlCluster.setControlClusterId(controlClusterServiceCmd.getControlClusterId());
            controlCluster.setCreateStatus(controlClusterServiceCmd.getCreateStatus());
            controlCluster.setPowerStatus(controlClusterServiceCmd.getPowerStatus());
            controlCluster.setServiceType(controlClusterServiceCmd.getServiceType());
            list.add(controlCluster);
        }
        return list;
    }

    public HypermetroGroup createHypermetroCGroup(HypermetroGroup hypermetroGroup) {
        CreateHyperMetroConsistentGroupReq hyperMetroConsistentGroupReq = new CreateHyperMetroConsistentGroupReq();
        hyperMetroConsistentGroupReq.setServiceType(SERVICE_TYPE);
        hyperMetroConsistentGroupReq.setSubOp(HyperMetroOperateEnum.CREATE_HYPER_METRO_CONSISTENT_GROUP.getName());
        hyperMetroConsistentGroupReq.setControlClusterId(hypermetroGroup.getControlClusterId());
        hyperMetroConsistentGroupReq.setName(hypermetroGroup.getName());
        hyperMetroConsistentGroupReq.setDomainId(hypermetroGroup.getDomainid());
        hyperMetroConsistentGroupReq.setRecoveryPolicy(RecoveryPolicy.EXC_AND_REC_MODE_AUTO.getName());
        hyperMetroConsistentGroupReq.setPriorityStationType(PriorityStationType.LOCAL.getName());
        TopoBuildUtil.logger.info((Object)"createHypermetroCGroup hyperMetroConsistentGroupReq=%s", new Object[]{JSONObject.fromObject((Object)hyperMetroConsistentGroupReq).toString()});
        HyperMetroConsistentGroupResponse response = this.fusionStorageHyperMetroHandler.createHyperMetroConsistentGroup(hypermetroGroup.getSrcDevSN(), hyperMetroConsistentGroupReq);
        if (response.isSuccess()) {
            HyperMetroConsistentGroupCmdData data = response.getServiceCmdData().get(0);
            HypermetroGroup group = this.queryHypermetroCGroup(hypermetroGroup.getSrcDevSN(), hypermetroGroup.getControlClusterId(), data.getId());
            return group;
        }
        throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
    }

    public HypermetroGroup queryHypermetroCGroup(String srcDevSN, String controlClusterId, String cgId) {
        QueryConsistentGroup queryConsistentGroup = new QueryConsistentGroup();
        queryConsistentGroup.setControlClusterId(controlClusterId);
        queryConsistentGroup.setId(cgId);
        queryConsistentGroup.setServiceType(SERVICE_TYPE);
        queryConsistentGroup.setSubOp(HyperMetroOperateEnum.GET_HYPER_METRO_CONSISTENT_GROUP.getName());
        HyperMetroConsistentGroupResponse response = this.fusionStorageHyperMetroHandler.getHyperMetroConsistentGroup(srcDevSN, queryConsistentGroup);
        if (response.isSuccess()) {
            List<HyperMetroConsistentGroupCmdData> list = response.getServiceCmdData();
            HyperMetroConsistentGroupCmdData data = list.get(0);
            HypermetroGroup hypermetroGroup = new HypermetroGroup();
            hypermetroGroup.setId(data.getId());
            hypermetroGroup.setEmpty(Boolean.parseBoolean(data.getIsEmpty()));
            hypermetroGroup.setHealStatus(data.getHealthStatus());
            hypermetroGroup.setnType(data.getType());
            hypermetroGroup.setSpeed(Integer.parseInt(data.getSpeed()));
            hypermetroGroup.setPriorityStationType(data.getPriorityStationType());
            hypermetroGroup.setRecoveryPolicy(data.getRecoveryPolicy());
            hypermetroGroup.setRunningStatus(data.getRunningStatus());
            hypermetroGroup.setResourceType(data.getResourceType());
            hypermetroGroup.setControlClusterId(controlClusterId);
            hypermetroGroup.setSrcDevSN(srcDevSN);
            return hypermetroGroup;
        }
        throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
    }

    public void pausedHypermetroCGroup(String srcDevSN, String controlClusterId, String cgId, Boolean isPrimary) {
        TopoBuildUtil.logger.info((Object)"pausedHypermetroCGroup strDevSN=%s,controlClusterId=%s,cgId=%s,isPrimary=%s", new Object[]{srcDevSN, controlClusterId, cgId, isPrimary});
        DisabledConsistentGroupReq disabledConsistentGroupReq = new DisabledConsistentGroupReq();
        disabledConsistentGroupReq.setControlClusterId(controlClusterId);
        disabledConsistentGroupReq.setId(cgId);
        disabledConsistentGroupReq.setServiceType(SERVICE_TYPE);
        disabledConsistentGroupReq.setSubOp(HyperMetroOperateEnum.DISABLE_HYPER_METRO_CONSISTENT_GROUP.getName());
        disabledConsistentGroupReq.setPrimary(isPrimary);
        disabledConsistentGroupReq.setOp(OP_CMD);
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.disabledConsistentGroup(srcDevSN, disabledConsistentGroupReq);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"pausedHypermetroCGroup error=%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public List<HypermetroPair> queryHypermetroPairs(String devSn, String controlClusterId, String domainId, Map<String, String> filters) {
        BatchQueryHyperMetroPairReq batchQueryHyperMetroPairReq = new BatchQueryHyperMetroPairReq();
        batchQueryHyperMetroPairReq.setControlClusterId(controlClusterId);
        batchQueryHyperMetroPairReq.setServiceType(SERVICE_TYPE);
        batchQueryHyperMetroPairReq.setHyperMetroDomainId(domainId);
        batchQueryHyperMetroPairReq.setSubOp(HyperMetroOperateEnum.GET_BATCH_HYPER_METRO_PAIR.getName());
        batchQueryHyperMetroPairReq.setOp(OP_CMD);
        if (!VerifyUtil.isEmpty(filters)) {
            batchQueryHyperMetroPairReq.setLocalObjName(filters.get("localObjName"));
        }
        HashSet hypermetroPairSet = new HashSet();
        int startIndex = 0;
        while (true) {
            batchQueryHyperMetroPairReq.setId(startIndex);
            batchQueryHyperMetroPairReq.setCount(20);
            HypermetroPairResponse response = this.fusionStorageHyperMetroHandler.queryHypermetroPairs(devSn, batchQueryHyperMetroPairReq);
            if (response.isSuccess()) {
                List hypermetroPairs = BeanConverter.convertListWithClass(response.getServiceCmdData(), HypermetroPair.class, null, (sourceObject, targetObject) -> this.setHypermetroPair(devSn, controlClusterId, (HyperMetroPairServiceCmd)sourceObject, (HypermetroPair)targetObject)).stream().filter(hypermetroPair -> StringUtils.isNotEmpty((CharSequence)hypermetroPair.getId())).collect(Collectors.toList());
                hypermetroPairSet.addAll(hypermetroPairs);
                if (hypermetroPairs.size() < 20) {
                    break;
                }
            } else {
                return Collections.emptyList();
            }
            startIndex += 20;
        }
        if (!VerifyUtil.isEmpty(filters)) {
            String localName = filters.get("localObjName");
            return hypermetroPairSet.stream().filter(hypermetroPair -> StringUtils.isNotEmpty((CharSequence)hypermetroPair.getLocalobjname()) && hypermetroPair.getLocalobjname().equals(localName)).collect(Collectors.toList());
        }
        return new ArrayList<HypermetroPair>(hypermetroPairSet);
    }

    public HypermetroPair queryHypermetroPair(String devSn, String controlClusterId, String pairId) {
        Optional<HypermetroPair> optionalHypermetroPair;
        QueryHyperMetroPairReq queryHyperMetroPairReq = new QueryHyperMetroPairReq();
        queryHyperMetroPairReq.setControlClusterId(controlClusterId);
        queryHyperMetroPairReq.setId(pairId);
        queryHyperMetroPairReq.setServiceType(SERVICE_TYPE);
        queryHyperMetroPairReq.setSubOp(HyperMetroOperateEnum.GET_ONE_HYPER_METRO_PAIR.getName());
        HypermetroPairResponse response = this.fusionStorageHyperMetroHandler.queryHyperMetroPair(devSn, queryHyperMetroPairReq);
        if (response.isSuccess() && (optionalHypermetroPair = BeanConverter.convertWithClass(response.getServiceCmdData().get(0), HypermetroPair.class, null, (sourceObject, targetObject) -> this.setHypermetroPair(devSn, controlClusterId, (HyperMetroPairServiceCmd)sourceObject, (HypermetroPair)targetObject))).isPresent()) {
            return optionalHypermetroPair.get();
        }
        throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
    }

    private void setHypermetroPair(String devSn, String controlClusterId, HyperMetroPairServiceCmd source, HypermetroPair target) {
        target.setSrcDevSN(devSn);
        target.setDomainid(source.getDomainId());
        target.setRemoteobjid(String.valueOf(source.getRemoteObjID()));
        target.setLocalobjid(String.valueOf(source.getLocalObjID()));
        target.setHealthstatus(source.getHealthStatus());
        target.setRunningState(source.getRunningStatus());
        target.setHcresourcetype(source.getHcResourceType());
        target.setControlClusterId(controlClusterId);
        target.setLocalobjname(source.getLocalObjName());
        target.setRemoteobjname(source.getRemoteObjName());
    }

    public HypermetroPair createHypermetroPair(HypermetroPair hypermetroPair) {
        TopoBuildUtil.logger.debug((Object)"Start to create hypermetroPair");
        CreateHypermetroPairReq createHypermetroPairReq = new CreateHypermetroPairReq();
        createHypermetroPairReq.setServiceType(SERVICE_TYPE);
        createHypermetroPairReq.setControlClusterId(hypermetroPair.getControlClusterId());
        createHypermetroPairReq.setSubOp(HyperMetroOperateEnum.CREATE_HYPER_METRO_PAIR.getName());
        createHypermetroPairReq.setDomainId(hypermetroPair.getDomainid());
        createHypermetroPairReq.setHcResourceType(HcResourceType.ST_LUN.getName());
        createHypermetroPairReq.setFirstSync(true);
        createHypermetroPairReq.setRecoveryPolicy(RecoveryPolicy.EXC_AND_REC_MODE_AUTO.getName());
        createHypermetroPairReq.setLocalObjID(hypermetroPair.getLocalobjid());
        createHypermetroPairReq.setRemoteObjID(hypermetroPair.getRemoteobjid());
        TopoBuildUtil.logger.info((Object)"createHypermetroPair createHypermetroPairReq=%s", new Object[]{JSONObject.fromObject((Object)createHypermetroPairReq).toString()});
        HypermetroPairResponse response = this.fusionStorageHyperMetroHandler.createHypermetroPair(hypermetroPair.getSrcDevSN(), createHypermetroPairReq);
        TopoBuildUtil.logger.debug((Object)"End to create hypermetroPair:%s", new Object[]{JSONObject.fromObject((Object)response).toString()});
        if (response.isSuccess()) {
            if (CollectionUtils.isEmpty(response.getServiceCmdData())) {
                return new HypermetroPair();
            }
            HyperMetroPairServiceCmd hyperMetroPairServiceCmd = response.getServiceCmdData().get(0);
            Optional<HypermetroPair> optionalHypermetroPair = BeanConverter.convertWithClass(hyperMetroPairServiceCmd, HypermetroPair.class, null, (sourceObject, targetObject) -> this.setHypermetroPair(hypermetroPair.getSrcDevSN(), hypermetroPair.getControlClusterId(), (HyperMetroPairServiceCmd)sourceObject, (HypermetroPair)targetObject));
            if (optionalHypermetroPair.isPresent()) {
                hypermetroPair.setId(optionalHypermetroPair.get().getId());
                return optionalHypermetroPair.get();
            }
        }
        return new HypermetroPair();
    }

    public void startHypermetroCGroup(String srcDevSN, String controlClusterId, String cgId) {
        SyncPairToConsistentGroupReq consistentGroupReq = new SyncPairToConsistentGroupReq();
        consistentGroupReq.setControlClusterId(controlClusterId);
        consistentGroupReq.setId(cgId);
        consistentGroupReq.setOp(OP_CMD);
        consistentGroupReq.setServiceType(SERVICE_TYPE);
        consistentGroupReq.setSubOp(HyperMetroOperateEnum.SYSNC_START_HYPER_METRO_CONSISTENT_GROUP.getName());
        StartHyperMetroGroupResponse response = this.fusionStorageHyperMetroHandler.forceStartConsistentGroup(srcDevSN, consistentGroupReq);
        TopoBuildUtil.logger.info((Object)"startHypermetroCGroup response=%s", new Object[]{response.getData()});
    }

    public void addHypermetroPairs(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs) {
        List<HypermetroPair> hyperMetroPairs = this.getHypermetroPairsByCgId(hypermetroGroup.getSrcDevSN(), hypermetroGroup.getControlClusterId(), hypermetroGroup.getId());
        HashSet pairIdLists = new HashSet();
        hyperMetroPairs.stream().forEach(pair -> pairIdLists.add(pair.getId()));
        for (HypermetroPair pair2 : pairs) {
            if (pairIdLists.contains(pair2.getId())) {
                TopoBuildUtil.logger.info((Object)"HypermetroPair(%s) is belonged hypermetroGroup(%s)", new Object[]{pair2.getId(), hypermetroGroup.getId()});
                continue;
            }
            this.addPairsToHypermetroGroup(hypermetroGroup, pair2);
        }
    }

    private void addPairsToHypermetroGroup(HypermetroGroup hypermetroGroup, HypermetroPair pair) {
        HyperMetroPairToConsistentGroupReq hyperMetroPairToConsistentGroupReq = new HyperMetroPairToConsistentGroupReq();
        hyperMetroPairToConsistentGroupReq.setControlClusterId(hypermetroGroup.getControlClusterId());
        hyperMetroPairToConsistentGroupReq.setAssociateObjID(pair.getId());
        hyperMetroPairToConsistentGroupReq.setAssociateObjType(HYPER_METRO_PAIR);
        hyperMetroPairToConsistentGroupReq.setId(hypermetroGroup.getId());
        hyperMetroPairToConsistentGroupReq.setServiceType(SERVICE_TYPE);
        hyperMetroPairToConsistentGroupReq.setOp(OP_CMD);
        hyperMetroPairToConsistentGroupReq.setSubOp(HyperMetroOperateEnum.ADD_PAIR_TO_HYPER_METRO_CONSISTENT_GROUP.getName());
        TopoBuildUtil.logger.info((Object)"addPairsToHypermetroGroup hyperMetroPairToConsistentGroupReq=%s", new Object[]{JSONObject.fromObject((Object)hyperMetroPairToConsistentGroupReq).toString()});
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.addPairToConsistentGroup(hypermetroGroup.getSrcDevSN(), hyperMetroPairToConsistentGroupReq);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"addPairsToHypermetroGroup error=%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public void pauseHypermetroPair(String srcDevSN, String controlClusterId, String pairId, Boolean isPrimary) {
        TopoBuildUtil.logger.info((Object)"pauseHypermetroPair srcDevSN=%s,controlClusterId=%s,pairId=%s,isPrimary=%s", new Object[]{srcDevSN, controlClusterId, pairId, isPrimary});
        DisableHyperMetroPairReq disableHyperMetroPairReq = new DisableHyperMetroPairReq();
        disableHyperMetroPairReq.setControlClusterId(controlClusterId);
        disableHyperMetroPairReq.setId(pairId);
        disableHyperMetroPairReq.setPrimary(isPrimary);
        disableHyperMetroPairReq.setServiceType(SERVICE_TYPE);
        disableHyperMetroPairReq.setSubOp(HyperMetroOperateEnum.DISABLE_HYPER_METRO_PAIR.getName());
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.disableHyperMetroPair(srcDevSN, disableHyperMetroPairReq);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"pauseHypermetroPair error=%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public void deleteHypermetroPair(String srcDevSN, String controlClusterId, String pairId, Boolean isLocalDelete) {
        TopoBuildUtil.logger.info((Object)"deleteHypermetroPair srcDevSN=%s,controlClusterId=%s,pairId=%s,isLocalDelete=%s", new Object[]{srcDevSN, controlClusterId, pairId, isLocalDelete});
        DeleteHyperMetroPairReq deleteHyperMetroPairReq = new DeleteHyperMetroPairReq();
        deleteHyperMetroPairReq.setControlClusterId(controlClusterId);
        deleteHyperMetroPairReq.setId(pairId);
        deleteHyperMetroPairReq.setLocalDelete(isLocalDelete);
        deleteHyperMetroPairReq.setServiceType(SERVICE_TYPE);
        deleteHyperMetroPairReq.setSubOp(HyperMetroOperateEnum.DELETE_HYPER_METRO_PAIR.getName());
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.deleteHypermetroPair(srcDevSN, deleteHyperMetroPairReq);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"deleteHypermetroPair error=%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public void deleteHypermetroCGroup(String devSn, String controlClusterId, String cgId) {
        TopoBuildUtil.logger.info((Object)"deleteHypermetroCGroup devSn=%s,controlClusterId=%s,cgId=%s,", new Object[]{devSn, controlClusterId, cgId});
        DeleteConsistentGroupReq deleteConsistentGroupReq = new DeleteConsistentGroupReq();
        deleteConsistentGroupReq.setControlClusterId(controlClusterId);
        deleteConsistentGroupReq.setId(cgId);
        deleteConsistentGroupReq.setServiceType(SERVICE_TYPE);
        deleteConsistentGroupReq.setSubOp(HyperMetroOperateEnum.DELETE_HYPER_METRO_CONSISTENT_GROUP.getName());
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.deleteHypermetroCGroup(devSn, deleteConsistentGroupReq);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"deleteHypermetroCGroup error=%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public void removeHypermetroPairs(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs) {
        if (CollectionUtils.isEmpty(pairs)) {
            return;
        }
        for (HypermetroPair pair : pairs) {
            this.delHypermetroPairsToGroup(hypermetroGroup, pair);
        }
    }

    private void delHypermetroPairsToGroup(HypermetroGroup hypermetroGroup, HypermetroPair pair) {
        HyperMetroPairToConsistentGroupReq hyperMetroPairGroupReq = new HyperMetroPairToConsistentGroupReq();
        hyperMetroPairGroupReq.setControlClusterId(hypermetroGroup.getControlClusterId());
        hyperMetroPairGroupReq.setId(hypermetroGroup.getId());
        hyperMetroPairGroupReq.setServiceType(SERVICE_TYPE);
        hyperMetroPairGroupReq.setSubOp(HyperMetroOperateEnum.DELETE_PAIR_OF_HYPER_METRO_CONSISTENT_GROUP.getName());
        hyperMetroPairGroupReq.setAssociateObjType(HYPER_METRO_PAIR);
        hyperMetroPairGroupReq.setAssociateObjID(pair.getId());
        hyperMetroPairGroupReq.setOp(OP_CMD);
        TopoBuildUtil.logger.info((Object)"delHypermetroPairsToGroup hyperMetroPairGroupReq= %s", new Object[]{JSONObject.fromObject((Object)hyperMetroPairGroupReq).toString()});
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.removePairToConsistentGroup(hypermetroGroup.getSrcDevSN(), hyperMetroPairGroupReq);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"delHypermetroPairsToGroup error=%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public List<HypermetroPair> getHypermetroPairsByCgId(String devSn, String controlClusterId, String cgId) {
        QueryHyperMetroPairToConsistentGroupReq queryHyperMetroPairToConsistentGroupReq = new QueryHyperMetroPairToConsistentGroupReq();
        queryHyperMetroPairToConsistentGroupReq.setControlClusterId(controlClusterId);
        queryHyperMetroPairToConsistentGroupReq.setId(cgId);
        queryHyperMetroPairToConsistentGroupReq.setServiceType(SERVICE_TYPE);
        queryHyperMetroPairToConsistentGroupReq.setSubOp(HyperMetroOperateEnum.GET_PAIRS_HYPER_METRO_CONSISTENT_GROUP.getName());
        int startIndex = 0;
        int bachSize = 40;
        HashSet hypermetroPairSet = new HashSet();
        while (true) {
            queryHyperMetroPairToConsistentGroupReq.setLocation(String.valueOf(startIndex));
            queryHyperMetroPairToConsistentGroupReq.setCount(bachSize);
            HypermetroPairResponse response = this.fusionStorageHyperMetroHandler.getPairsHyperMetroConsistentGroup(devSn, queryHyperMetroPairToConsistentGroupReq);
            if (response.isSuccess()) {
                List hypermetroPairs = BeanConverter.convertListWithClass(response.getServiceCmdData(), HypermetroPair.class, null, (sourceObject, targetObject) -> this.setHypermetroPair(devSn, controlClusterId, (HyperMetroPairServiceCmd)sourceObject, (HypermetroPair)targetObject)).stream().filter(hypermetroPair -> StringUtils.isNotEmpty((CharSequence)hypermetroPair.getId())).collect(Collectors.toList());
                hypermetroPairSet.addAll(hypermetroPairs);
                if (hypermetroPairs.size() < 40) {
                    return new ArrayList<HypermetroPair>(hypermetroPairSet);
                }
            } else {
                return Collections.emptyList();
            }
            startIndex += 40;
        }
    }

    public void swapHyperMetroPair(String devSn, String controlClusterId, String pairId) {
        SwapHyperMetroPairRep swapHyperMetroPairRep = new SwapHyperMetroPairRep();
        swapHyperMetroPairRep.setControlClusterId("0");
        swapHyperMetroPairRep.setId(pairId);
        swapHyperMetroPairRep.setServiceType(SERVICE_TYPE);
        swapHyperMetroPairRep.setSubOp(HyperMetroOperateEnum.SWAP_HYPER_METRO_PAIR.getName());
        TopoBuildUtil.logger.info((Object)"SwapHyperMetroPairRep hyperMetroPairGroupReq: %s", new Object[]{JSONObject.fromObject((Object)swapHyperMetroPairRep).toString()});
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.swapHyperMetroPair(devSn, swapHyperMetroPairRep);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"SwapHyperMetroPairRep error:%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    private void swapHyperMetroConsistentGroup(String devSn, String cgId) {
        SwapHyperMetroCgRep swapHyperMetroCgRep = new SwapHyperMetroCgRep();
        swapHyperMetroCgRep.setControlClusterId("0");
        swapHyperMetroCgRep.setId(cgId);
        swapHyperMetroCgRep.setServiceType(SERVICE_TYPE);
        swapHyperMetroCgRep.setSubOp(HyperMetroOperateEnum.SWAP_HYPER_METRO_CONSISTENT_GROUP.getName());
        TopoBuildUtil.logger.info((Object)"SwapHyperMetroPairRep hyperMetroPairGroupReq: %s", new Object[]{JSONObject.fromObject((Object)swapHyperMetroCgRep).toString()});
        BaseHyperMetroResponse response = this.fusionStorageHyperMetroHandler.swapHyperMetroCg(devSn, swapHyperMetroCgRep);
        if (!response.isSuccess()) {
            TopoBuildUtil.logger.error((Object)"SwapHyperMetroCgRep error:%s", new Object[]{response.getMessage()});
            throw new LegoCheckedException((long)response.getErrorCode(), response.getMessage());
        }
    }

    public boolean isAccordantExpectForRunningStatus(String value, String key) {
        VerifyUtil.checkStrs((String[])new String[]{value, key});
        return value.equals(RUNNING_STATUS_MAP.get(key).getType());
    }

    public List<HypermetroPair> getLocalHyperMetroPairs(String srcDevSn, Set<String> lunIds) {
        VerifyUtil.checkObjs((Object[])new Object[]{srcDevSn, lunIds});
        String[] lunIdArray = lunIds.toArray(new String[0]);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("srcDevSN", srcDevSn);
        props.put("localobjid", lunIdArray);
        return CommonDAOLocator.getMoDao().findMoBy(HypermetroPair.class, props);
    }

    public boolean isHypermetroPairStatusAvailable(HypermetroPair pair) {
        return this.isHyperMetroPairStatusAvailable(pair, NORMAL_RUNNING_STATUS, NORMAL_HEALTH_STATUS);
    }

    @Override
    public String getStorageType() {
        return FusionStorageUnit.class.getName();
    }
}

