/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.service;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.fsb.FusionStorageConstants;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnectionManager;
import com.huawei.ism.drm.storage.fsb.handler.FusionStorageHandler;
import com.huawei.ism.drm.storage.fsb.service.IFusionStorageCommonManager;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageRestTransition;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FusionStorageLunManagerAdapter
implements IFusionStorageCommonManager,
IStorageLunManager {
    private static final Log logger = LogFactory.getInstance(FusionStorageLunManagerAdapter.class);
    private static final int ENCRYPTED = 1;
    private FusionStorageHandler fusionStorageHanler;

    public FusionStorageHandler getFusionStorageHanler() {
        return this.fusionStorageHanler;
    }

    public void setFusionStorageHanler(FusionStorageHandler fusionStorageHanler) {
        this.fusionStorageHanler = fusionStorageHanler;
    }

    public List<Lun> queryLuns(String deviceSn, List<String> lunIds) {
        lunIds = CommonUtil.getOrEmpty(lunIds);
        FusionStorageCommonUtil.paramsCheck(deviceSn, lunIds);
        return ExecutionService.map((Collection)lunIds, lunId -> this.fusionStorageHanler.getVolumeByLunId(deviceSn, (String)lunId));
    }

    public List<Lun> queryLunsByNames(String deviceSn, List<String> lunNames) {
        lunNames = CommonUtil.getOrEmpty(lunNames);
        FusionStorageCommonUtil.paramsCheck(deviceSn, lunNames);
        return ExecutionService.map((Collection)lunNames, lunName -> this.fusionStorageHanler.getVolumeByLunName(deviceSn, (String)lunName));
    }

    public boolean isLunMapped(String deviceSN, String resourceId) {
        return this.fusionStorageHanler.isLunMapped(deviceSN, resourceId);
    }

    public String prepareMapping(String devSn, HostVO hostVo) {
        logger.trace((Object)"Nothing need to do.");
        return null;
    }

    public OperationResult mappingLun(String deviceSN, String resourceId, HostVO hostVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSN, resourceId);
        return this.fusionStorageHanler.mapping(deviceSN, volumeName, (ResourceVO)hostVO);
    }

    public OperationResult removeLunMapping(String devSn, String resourceId, HostVO hostVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(devSn, resourceId);
        return this.fusionStorageHanler.unmapping(devSn, volumeName, (ResourceVO)hostVO);
    }

    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        logger.trace((Object)"Nothing need to do.");
        return null;
    }

    public OperationResult mappingLun(String deviceSN, String resourceId, HostGroupVO hostGroupVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSN, resourceId);
        return this.fusionStorageHanler.mapping(deviceSN, volumeName, (ResourceVO)hostGroupVO);
    }

    public OperationResult removeLunMapping(String deviceSN, String resourceId, HostGroupVO hostGroupVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSN, resourceId);
        return this.fusionStorageHanler.unmapping(deviceSN, volumeName, (ResourceVO)hostGroupVO);
    }

    public OperationResult addLunToLunGroup(String devSn, String resourceId, List<HostVO> hostVoList, String lunGroupId, Map<String, Object> caches) {
        throw new LegoCheckedException(100663460L, "Not Supported");
    }

    public Lun createLun(Lun lun) {
        String response;
        if (lun == null) {
            logger.error((Object)"Create lun fail, invalid input param.");
            return null;
        }
        FsbRestConnection connection = (FsbRestConnection)FsbRestConnectionManager.getInstance().getConnection(lun.getDevSn());
        if (lun.getEncrypted() != null && lun.getEncrypted() == 1 && lun.getCryptAlg() != null) {
            JSONObject params = this.buildCreateVolumeV2Params(lun);
            response = connection.post("/api/v2/block_service/volumes", params.toString(), null);
        } else {
            JSONObject params = this.buildCreateVolumeParams(lun);
            response = connection.post("/volume/create", params.toString(), null);
        }
        if (!FusionStorageCommonUtil.isSuccessResult(response)) {
            logger.error((Object)"Create lun fail. create lun info[devSn=%s, poolId=%s, volName=%s, volSize=%s], response str=%s", new Object[]{lun.getDevSn(), lun.getStoragePoolId(), lun.getName(), lun.getCapacity(), response});
            return null;
        }
        return this.fusionStorageHanler.getVolumeByLunName(lun.getDevSn(), lun.getName());
    }

    private JSONObject buildCreateVolumeParams(Lun lun) {
        JSONObject params = new JSONObject();
        params.put((Object)"volName", (Object)lun.getName());
        params.put((Object)"volSize", (Object)lun.getCapacity());
        params.put((Object)"poolId", (Object)NumberUtil.convertToInteger((Object)lun.getStoragePoolId()));
        return params;
    }

    private JSONObject buildCreateVolumeV2Params(Lun lun) {
        JSONObject params = new JSONObject();
        params.put((Object)"name", (Object)lun.getName());
        params.put((Object)"capacity", (Object)lun.getCapacity());
        params.put((Object)"pool_id", (Object)NumberUtil.convertToInteger((Object)lun.getStoragePoolId()));
        params.put((Object)"encrypted", (Object)lun.getEncrypted());
        params.put((Object)"crypt_alg", (Object)lun.getCryptAlg());
        return params;
    }

    public void deleteLun(String devSn, List<String> lunIds, List<String> lunNames) {
        List<String> rmNames;
        boolean isNamesEmpty = VerifyUtil.isEmpty(lunNames);
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty(lunIds) && isNamesEmpty) {
            logger.error((Object)"Delete lun fail, input param invalid.");
            return;
        }
        List<String> list = rmNames = isNamesEmpty ? this.getLunNamesByIds(devSn, lunIds) : lunNames;
        if (VerifyUtil.isEmpty(rmNames)) {
            logger.error((Object)"Delete lun fail, lunIds: %s.", new Object[]{lunIds});
            return;
        }
        JSONObject params = new JSONObject();
        params.put((Object)"volNames", rmNames);
        FsbRestConnection connection = (FsbRestConnection)FsbRestConnectionManager.getInstance().getConnection(devSn);
        String response = connection.post("/volume/delete", params.toString(), null);
        if (!FusionStorageCommonUtil.isSuccessResult(response)) {
            logger.error((Object)"Delete lun fail. devSn=%s, params=%s, response str=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), params.toString(), response});
            throw new LegoCheckedException(0x300001L);
        }
    }

    private List<String> getLunNamesByIds(String devSn, List<String> lunIds) {
        return this.queryLuns(devSn, lunIds).stream().map(ManagedObject::getName).collect(Collectors.toList());
    }

    public Lun getLunById(String devSN, String lunId) {
        if (null == devSN || null == lunId) {
            logger.error((Object)"input param is null. devSn=%s, lunId=%s.", new Object[]{devSN, lunId});
            return null;
        }
        return this.fusionStorageHanler.getVolumeByLunId(devSN, lunId);
    }

    public Lun getLunByWWN(String devSN, String lunWWN) {
        if (null == devSN || null == lunWWN) {
            logger.error((Object)"Delete lun fail, input param is null.devSn=%s, lunWWn=%s.", new Object[]{devSN, lunWWN});
            return null;
        }
        FsbRestConnection connection = (FsbRestConnection)FsbRestConnectionManager.getInstance().getConnection(devSN);
        StringBuilder url = new StringBuilder("/lun/wwn/list");
        url.append('?').append("wwn").append("=0x").append(lunWWN);
        String res = connection.getForString(url.toString(), null);
        JSONObject jsonResponse = JSONObject.fromObject((Object)res);
        if (jsonResponse.containsKey((Object)"errorCode") && "32151404".equals(jsonResponse.getString("errorCode"))) {
            logger.error((Object)"get Lun by WWN fail. request url = %s, response str = %s.", new Object[]{url, res});
            return null;
        }
        if (null == jsonResponse.getJSONObject("lunDetailInfo")) {
            logger.error((Object)"json response got error! lunDetailInfo not exist. request url = %s, response str = %s.", new Object[]{url, res});
            throw new LegoCheckedException(1073947393L);
        }
        return FusionStorageRestTransition.transitionLun(devSN, jsonResponse.getJSONObject("lunDetailInfo"));
    }

    public Lun getLunByName(String devSN, String lunName) {
        Lun lun;
        if (null == devSN || null == lunName) {
            logger.error((Object)"get lun by name fail, input param is null. devS=%s, lunName=%s.", new Object[]{devSN, lunName});
            return null;
        }
        try {
            lun = this.fusionStorageHanler.getVolumeByLunName(devSN, lunName);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"get lun by name fail, devSn:%s, volName:%s. ", new Object[]{devSN, lunName});
            if (FusionStorageConstants.FSB_VOLUME_OR_SNAPSHOT_NOT_EXIST.contains(ex.getErrorCode())) {
                logger.debug((Object)"volume not exist.");
                return null;
            }
            return null;
        }
        return lun;
    }

    public Optional<Lun> getLunByIdV2(String devSN, String lunId) {
        if (devSN == null || lunId == null) {
            logger.error((Object)"Get lun by name fail, input param is null. devS=%s, lunId=%s.", new Object[]{devSN, lunId});
            return Optional.empty();
        }
        try {
            return this.fusionStorageHanler.getVolumeByLunIdV2(devSN, lunId);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Get lun by id failed, devSn:%s, lunId:%s, errorCode:%s.", new Object[]{devSN, lunId, ex.getErrorCode()});
            return Optional.empty();
        }
    }

    public boolean expandLun(Lun lun) {
        if (lun == null) {
            logger.error((Object)"Expand lun fail, invalid input param.");
            return false;
        }
        this.fusionStorageHanler.expandVolByName(lun.getDevSn(), lun.getName(), Math.toIntExact(lun.getCapacity()));
        return true;
    }
}

