/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.service;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnectionManager;
import com.huawei.ism.drm.storage.fsb.handler.FusionStorageHandler;
import com.huawei.ism.drm.storage.fsb.service.IFusionStorageCommonManager;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FusionStorageSnapshotManagerAdapter
implements IFusionStorageCommonManager,
IStorageSnapshotManager {
    private static final Log logger = LogFactory.getInstance(FusionStorageSnapshotManagerAdapter.class);
    private static final char SNAPNAME_WWN_SPLIT = '@';
    private FusionStorageHandler fusionStorageHanler;

    public FusionStorageHandler getFusionStorageHanler() {
        return this.fusionStorageHanler;
    }

    public void setFusionStorageHanler(FusionStorageHandler fusionStorageHanler) {
        this.fusionStorageHanler = fusionStorageHanler;
    }

    public OperationResult addSnapshotToHost(String deviceId, String srcResourceId, Snapshot snapshot) {
        throw new LegoCheckedException(100663460L);
    }

    public OperationResult removeSnapshotFromHost(String deviceId, Snapshot snapshot, HostVO host) {
        return this.removeSnapshot(deviceId, snapshot, (ResourceVO)host);
    }

    public OperationResult removeSnapshotFromHostGroup(String deviceId, Snapshot snapshot, HostGroupVO hostGroup) {
        return this.removeSnapshot(deviceId, snapshot, (ResourceVO)hostGroup);
    }

    private OperationResult removeSnapshot(String deviceId, Snapshot snapshot, ResourceVO resourceVO) {
        FusionStorageCommonUtil.paramsCheck(deviceId, snapshot, resourceVO);
        logger.debug((Object)"Start removeSnapshot, devSn:%s, snapshotName:%s, resourceVO:%s", new Object[]{SecurityUtil.desensitizeId((String)deviceId), snapshot.getSnapshotName(), resourceVO.getName()});
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getSnapshotId());
        OperationResult result = this.fusionStorageHanler.unmapping(deviceId, cloneVolName, resourceVO);
        if (result.isSuccess()) {
            try {
                this.fusionStorageHanler.deleteVolByName(deviceId, cloneVolName);
                return new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, true, new String[]{snapshot.getSnapshotName()});
            }
            catch (LegoCheckedException e) {
                return new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, false, String.valueOf(e.getErrorCode()), new String[]{snapshot.getSnapshotName()});
            }
        }
        logger.error((Object)"Failed removeSnapshot, devSn:%s, snapshotName:%s, resourceVO:%s", new Object[]{SecurityUtil.desensitizeId((String)deviceId), snapshot.getSnapshotName(), resourceVO.getName()});
        return result;
    }

    public OperationResult removeSnapshotBySrcLUN(String deviceId, Snapshot snapshot, String srcResourceId) {
        return this.deleteSnapshot(deviceId, snapshot).appendArgs(new String[]{srcResourceId});
    }

    public Snapshot createSnapshot(String deviceSN, List<String> srcResourceIds, Snapshot snapshot) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, srcResourceIds, snapshot);
        logger.debug((Object)"Start createSnapshot, devSn:%s, snapshotName:%s", new Object[]{SecurityUtil.desensitizeId((String)deviceSN), snapshot.getSnapshotName()});
        String snapName = snapshot.getName();
        snapshot.setSnapshotId(snapName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(deviceSN).append('@').append(snapName);
        snapshot.setWwn(stringBuilder.toString());
        return snapshot;
    }

    public OperationResult deleteSnapshot(String deviceSN, Snapshot arraySnapshot) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, arraySnapshot, arraySnapshot.getSnapshotId());
        if (VerifyUtil.isEmpty((String)arraySnapshot.getName())) {
            arraySnapshot.setSnapshotName(arraySnapshot.getSnapshotId());
        }
        logger.debug((Object)"Start deleteSnapshot, deviceSN:%s, snapshotName:%s", new Object[]{deviceSN, arraySnapshot.getSnapshotName()});
        FsbRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSN);
        Snapshot snapshot = this.fusionStorageHanler.getSnapshotByName(deviceSN, arraySnapshot.getSnapshotName());
        if (snapshot == null) {
            logger.error((Object)"Failed getSnapshotByName, snapshot not exist in deviceSN:%s, snapshotName:%s", new Object[]{deviceSN, arraySnapshot.getSnapshotName()});
            return new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        try {
            String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getName());
            this.fusionStorageHanler.deleteVolByName(deviceSN, cloneVolName);
            JSONObject params = new JSONObject();
            params.put((Object)"snapshotName", (Object)snapshot.getName());
            String res = connection.postForObject("/snapshot/delete", params);
            logger.debug((Object)"End deleteSnapshot, deviceSN:%s, snapshotName:%s, cloneVolName:%s. response: %s", new Object[]{deviceSN, arraySnapshot.getSnapshotName(), cloneVolName, res});
            return new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Throwable)e, (Object)"Deleting snapshot failed. SnapshotId:%s, SnapshotName:%s, DeviceId:%s", new Object[]{arraySnapshot.getSnapshotId(), arraySnapshot.getSnapshotName(), deviceSN});
            return new OperationResult("ism.drm.delete.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), new String[]{arraySnapshot.getName()});
        }
    }

    public OperationResult activeSnapshot(String deviceSN, List<String> snapshotIds) {
        logger.debug((Object)"protect execute active snapshot");
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshotIds);
        try {
            this.fusionStorageHanler.createSnapshotConsistent(deviceSN, snapshotIds);
            return new OperationResult("ism.drm.active.snapshot.operation", true, true, new String[]{snapshotIds.toString()});
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Snapshot active error, errorCode=%s, devSN=%s, snapshotIds=[%s].", new Object[]{ex.getErrorCode(), SecurityUtil.desensitizeId((String)deviceSN), String.join((CharSequence)",", snapshotIds)});
            return new OperationResult("ism.drm.active.snapshot.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{snapshotIds.toString()});
        }
    }

    public OperationResult activeSnapshotAfterStop(String deviceSN, List<String> snapshotIds) {
        logger.debug((Object)"recovery plan active snapshot");
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshotIds);
        try {
            this.fusionStorageHanler.createSnapshotConsistent(deviceSN, snapshotIds);
            List snapshots = ExecutionService.map(snapshotIds, srcSnapshotId -> this.copySnapshot(deviceSN, (String)srcSnapshotId, this.fusionStorageHanler.getCloneVolNameBySnapshotId((String)srcSnapshotId)));
            List<String> items = snapshots.stream().map(s -> s.getSrcResourceUuid() + ">" + s.getWwn()).collect(Collectors.toList());
            return new OperationResult("ism.drm.active.snapshot.operation", true, true, items.toArray(new String[items.size()]));
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Snapshot active error, errorCode=%s, devSN=%s, snapshotIds=[%s].", new Object[]{ex.getErrorCode(), SecurityUtil.desensitizeId((String)deviceSN), String.join((CharSequence)",", snapshotIds)});
            return new OperationResult("ism.drm.active.snapshot.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{snapshotIds.toString()});
        }
    }

    public OperationResult reCreateSnapshot(String deviceSN, List<String> snapshotIds) {
        throw new LegoCheckedException(100663460L, "Not support snapshot re-create");
    }

    public OperationResult activeOrReCreateSnapshot(String deviceSN, Snapshot snapshot) {
        throw new LegoCheckedException(100663460L, "Not support snapshot active or re-create");
    }

    public OperationResult disableSnapshot(String deviceSN, Snapshot snapshot) {
        logger.debug((Object)"start to disableSnapshot");
        return this.deleteSnapshot(deviceSN, snapshot);
    }

    public boolean isSnapshotExist(String deviceSN, Snapshot snapshot) {
        List<Object> snapshots;
        try {
            snapshots = this.getSnapshot(deviceSN, snapshot);
        }
        catch (LegoCheckedException e) {
            snapshots = Collections.emptyList();
        }
        return !snapshots.isEmpty();
    }

    public List<Snapshot> getSnapshot(String deviceSN, Snapshot snapshot) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshot);
        snapshot.setName(snapshot.getSnapshotId());
        Snapshot s = this.fusionStorageHanler.getSnapshotByName(deviceSN, snapshot.getName());
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        if (null != s) {
            result.add(s);
        }
        return result;
    }

    public OperationResult restoreSnapshot(String deviceSN, Snapshot snapshot, String restoreSpeed) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshot);
        logger.debug((Object)"Start restoreSnapshot. devSn:%s, snapshotName:%s, restoreSpeed:%s.", new Object[]{SecurityUtil.desensitizeId((String)deviceSN), snapshot.getSnapshotName(), restoreSpeed});
        FsbRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSN);
        String snapshotName = snapshot.getName();
        Lun lun = this.fusionStorageHanler.getVolumeBySnapshot(deviceSN, snapshotName);
        String lunName = lun.getName();
        JSONObject params = new JSONObject();
        params.put((Object)"snapshotName", (Object)snapshotName);
        params.put((Object)"volumeName", (Object)lunName);
        try {
            connection.postForObject("/snapshot/rollback", params);
            logger.debug((Object)"Restore snapshot finished. devSn:%s, snapshotName:%s.", new Object[]{SecurityUtil.desensitizeId((String)deviceSN), snapshot.getSnapshotName()});
            return new OperationResult("ism.drm.restore.snapshot.operation", true, true, new String[]{snapshotName});
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Restore snapshot error, errorCode=%s, devSN=%s, params=[%s].", new Object[]{ex.getErrorCode(), SecurityUtil.desensitizeId((String)deviceSN), params.toString()});
            return new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{snapshotName});
        }
    }

    public OperationResult mappingSnapshot(String devSn, String srcResourceId, Snapshot snapshot, HostVO hostVo) {
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getSnapshotId());
        return this.fusionStorageHanler.mapping(devSn, cloneVolName, (ResourceVO)hostVo);
    }

    public OperationResult mappingSnapshot(String devSn, String srcResourceId, Snapshot snapshot, HostGroupVO hgVo) {
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getSnapshotId());
        return this.fusionStorageHanler.mapping(devSn, cloneVolName, (ResourceVO)hgVo);
    }

    public Snapshot copySnapshot(String devSn, String srcSnapshotId, String copyName) {
        FusionStorageCommonUtil.paramsCheck(devSn, srcSnapshotId, copyName);
        logger.debug((Object)"Start copySnapshot. devSn:%s, srcSnapshotId:%s, copyName:%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), srcSnapshotId, copyName});
        FsbRestConnection connection = this.getConnection(devSn);
        JSONObject params = new JSONObject();
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(copyName);
        if (cloneVolName.length() > 95) {
            cloneVolName = cloneVolName.substring(0, 60) + Long.toHexString(System.currentTimeMillis()) + "_Clone";
        }
        params.put((Object)"src", (Object)srcSnapshotId);
        params.put((Object)"volName", (Object)cloneVolName);
        connection.postForObject("/snapshot/volume/create", params);
        Snapshot snapshot = new Snapshot();
        snapshot.setDevSn(devSn);
        snapshot.setSnapshotName(cloneVolName);
        snapshot.setSnapshotId(cloneVolName);
        snapshot.setSrcResourceUuid(devSn + "@" + srcSnapshotId);
        Lun lun = this.fusionStorageHanler.getVolumeByLunName(devSn, cloneVolName);
        if (null != lun) {
            snapshot.setWwn(lun.getWwn());
        }
        logger.debug((Object)"Finish copySnapshot. devSn:%s, srcSnapshotId:%s, cloneVolName:%s, Wwn:%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), srcSnapshotId, cloneVolName, snapshot.getWwn()});
        return snapshot;
    }

    public String prepareMapping(String devSn, HostVO hostVo) {
        logger.trace((Object)"Nothing need to do.");
        return null;
    }

    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        logger.trace((Object)"Nothing need to do.");
        return null;
    }

    public OperationResult addSnapshotToLunGroup(String devSn, Snapshot snapshot, String lunGroupId, Map<String, Object> cache) {
        logger.info((Object)"Nothing need to do.");
        return null;
    }

    public List<Snapshot> querySnapshotByLun(String deviceSn, String lunId) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSn, lunId);
        return this.fusionStorageHanler.querySnapshotByLun(deviceSn, volumeName);
    }

    private FsbRestConnection getConnection(String devSn) {
        return (FsbRestConnection)FsbRestConnectionManager.getInstance().getConnection(devSn);
    }
}

