/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public final class BeanConverter {
    private static final Logger log = LoggerFactory.getLogger(BeanConverter.class);

    public static <S, T> List<T> convertListWithClass(List<S> sourceObjects, Class<T> targetCls, String[] ignoreProperties, AfterConvert<S, T> afterConvert) {
        ArrayList<T> targetObjects = new ArrayList<T>();
        if (CollectionUtils.isEmpty(sourceObjects)) {
            return targetObjects;
        }
        for (S sourceObject : sourceObjects) {
            Optional<T> targetObject = BeanConverter.convertWithClass(sourceObject, targetCls, ignoreProperties, afterConvert);
            if (targetObject.isPresent()) {
                targetObjects.add(targetObject.get());
                continue;
            }
            log.warn("[Op:convertListWithClass] null object in list");
        }
        return targetObjects;
    }

    public static <S, T> Optional<T> convertWithClass(S sourceObject, Class<T> targetCls, String[] ignoreProperties, AfterConvert<S, T> afterConvert) {
        if (sourceObject == null) {
            return Optional.empty();
        }
        Object targetObject = null;
        try {
            targetObject = targetCls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("[op:convert] {} new instance exception", (Object)targetCls.getSimpleName());
        }
        BeanConverter.convert(sourceObject, targetObject, ignoreProperties, afterConvert);
        return Optional.ofNullable(targetObject);
    }

    public static <S, T> void convert(S sourceObject, T targetObject, String[] ignoreProperties, AfterConvert<S, T> afterConvert) {
        if (sourceObject == null || targetObject == null) {
            return;
        }
        BeanUtils.copyProperties(sourceObject, targetObject, (String[])ignoreProperties);
        if (afterConvert != null) {
            afterConvert.afterConvert(sourceObject, targetObject);
        }
    }

    @FunctionalInterface
    public static interface AfterConvert<S, T> {
        public void afterConvert(S var1, T var2);
    }
}

