/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.util;

import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FsbRestConnectionManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import org.apache.commons.lang3.StringUtils;

public class FusionStorageCommonUtil {
    private static final Log logger = LogFactory.getInstance(FusionStorageCommonUtil.class);

    public static FsbRestConnection getConnection(String devSn) {
        return (FsbRestConnection)FsbRestConnectionManager.getInstance().getConnection(devSn);
    }

    public static boolean isSuccessResult(String jsonRes) {
        int resultCode = FusionStorageCommonUtil.getResultCode(jsonRes);
        if (resultCode != 0) {
            logger.error((Object)"Failed result is null or not 0.");
            return false;
        }
        return true;
    }

    public static int getResultCode(String jsonRes) {
        JSONObject responseJson = JSONObject.fromObject((Object)jsonRes);
        return FusionStorageCommonUtil.getResultCode(responseJson);
    }

    public static int getResultCode(JSONObject responseJson) {
        String resultStr = responseJson.getString("result");
        int resultCode = StringUtils.isNumeric((CharSequence)resultStr) ? responseJson.getInt("result") : responseJson.getJSONObject("result").getInt("code");
        return resultCode;
    }

    public static boolean isSuccessResponse(JSONObject responseJson) {
        boolean optResult = true;
        if (responseJson.containsKey((Object)"error")) {
            JSONObject errorJson = responseJson.getJSONObject("error");
            if (null == errorJson || !errorJson.containsKey((Object)"code") || errorJson.getInt("code") != 0) {
                optResult = false;
            }
        } else {
            optResult = false;
        }
        return optResult;
    }

    public static void paramsCheck(Object ... args) {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!VerifyUtil.isEmpty((Object)args[i])) continue;
                logger.error((Object)("params is null, params number:" + args.length + ", null param is the" + i + "th"));
                throw new LegoCheckedException(1073947393L);
            }
        }
    }
}

