/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup;

import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.backup.service.IBackupProxyService;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.backup.service.IBackupProxyService", desc="", interfaceClass=IBackupProxyService.class)
public class BackupProxyServiceImpl
extends IsmBaseService
implements IBackupProxyService {
    private static Log logger = LogFactory.getInstance(BackupProxyServiceImpl.class);
    private List<IObjectObserver> observerList = new ArrayList<IObjectObserver>();

    public void addObserver(IObjectObserver observer, Map<?, ?> properties) {
        logger.trace((Object)"addObserver");
        if (BackupProxy.class.getName().equals(observer.getObserverType())) {
            this.observerList.add(observer);
        }
    }

    public void notifyObserverList(MessageEvent event, String notifyType) {
        logger.debug((Object)("enter notifyObserverList. notifyType:" + notifyType));
        try {
            for (IObjectObserver observer : this.getObserverList()) {
                if ("before".equals(notifyType)) {
                    observer.before(event);
                    continue;
                }
                logger.error((Object)("notifyType is " + notifyType), 90160758786898L);
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to notify observer.", (Throwable)le, 90160758786898L);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify observer.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to notify observer.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public List<IObjectObserver> getObserverList() {
        return this.observerList;
    }

    public void createBackupProxy(BackupProxy proxy) {
        if (this.isProxyNameExist(proxy.getName()).booleanValue()) {
            throw new LegoCheckedException(1073947392L);
        }
        if (!VerifyUtil.isEmpty((String)proxy.getPassword())) {
            String password = WccEncryptor.encrypt((String)proxy.getPassword());
            proxy.setPassword(password);
        }
        proxy.setProxyId(UUIDGenerator.getUUID());
        try {
            long count = CommonDAOLocator.getBaseDao().getTotalCount("select count(proxyId) from BackupProxy", new Object[0]);
            if (count >= 64L) {
                logger.error((Object)"BackupProxy is more than [%s]", 64L);
                throw new SpecCheckedException("proxy_quantity", 64L, count);
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)proxy);
        }
        catch (DataAccessException e) {
            logger.error((Object)"create proxy error", (Throwable)e, 0L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void updateBackupProxy(BackupProxy proxy) {
        MessageEvent event = MessageEvent.createMessageEvent((int)1, (Object[])new Object[]{proxy});
        this.notifyObserverList(event, "before");
        try {
            String password = "";
            if (!VerifyUtil.isEmpty((String)proxy.getPassword())) {
                password = WccEncryptor.encrypt((String)proxy.getPassword());
            }
            if (!proxy.getAnonymous().booleanValue() && VerifyUtil.isEmpty((String)proxy.getPassword())) {
                BackupProxy proxyDB = (BackupProxy)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(BackupProxy.class, (Serializable)((Object)proxy.getProxyId()));
                if (VerifyUtil.isEmpty((Object)proxyDB)) {
                    logger.error((Object)"The proxy is not exist");
                    String errorMessage = "The proxy is not exist";
                    throw new LegoCheckedException(1073947394L, errorMessage);
                }
                password = proxyDB.getPassword();
            }
            proxy.setPassword(password);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)proxy);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"update proxy error", (Throwable)ex, 0L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public void deleteBackupProxy(String proxyId) {
        BackupProxy proxy = (BackupProxy)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(BackupProxy.class, (Serializable)((Object)proxyId));
        if (null == proxy) {
            return;
        }
        MessageEvent event = MessageEvent.createMessageEvent((int)2, (Object[])new Object[]{proxy});
        this.notifyObserverList(event, "before");
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)proxy);
            return;
        }
        catch (DataAccessException e) {
            logger.error((Object)"delete proxy error", (Throwable)e, 0L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public List<BackupProxy> listBackupProxy() {
        String hql = "from BackupProxy as st order by st.name asc";
        return this.executeQuery(hql);
    }

    public BackupProxy getBackupProxy(String proxyId) {
        if (VerifyUtil.isEmpty((String)proxyId)) {
            logger.error((Object)("proxyId=" + proxyId), 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
        BackupProxy proxy = null;
        try {
            proxy = (BackupProxy)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(BackupProxy.class, (Serializable)((Object)proxyId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get proxy:" + proxyId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return proxy;
    }

    private Boolean isProxyNameExist(String name) {
        try {
            List proxyList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from BackupProxy as st where st.name = ? ", new Object[]{name});
            return !VerifyUtil.isEmpty((Collection)proxyList);
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get proxyList:" + name), (Throwable)e, 0L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private List<BackupProxy> executeQuery(String hql) {
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get proxyList", (Throwable)ex, 0L);
            return new ArrayList<BackupProxy>();
        }
    }
}

