/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.backup.model.CloudRegion;
import com.huawei.ism.drm.backup.service.ICloudRegionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.backup.service.ICloudRegionService", desc="", interfaceClass=ICloudRegionService.class)
public class CloudRegionServiceImpl
extends BaseService
implements ICloudRegionService {
    private static Log logger = LogFactory.getInstance(CloudRegionServiceImpl.class);

    public void createCloudRegion(CloudRegion cloudRegion) {
        if (this.isloudRegionNameExist(cloudRegion.getName()).booleanValue()) {
            throw new LegoCheckedException(1073947392L);
        }
        cloudRegion.setUuid(UUIDGenerator.getUUID());
        cloudRegion.setIspreSet(Boolean.valueOf(false));
        try {
            long count = CommonDAOLocator.getBaseDao().getTotalCount("select count(uuid) from CloudRegion", new Object[0]);
            if (count >= 1024L) {
                throw new SpecCheckedException("cloud_region_quantity", 1024L, count);
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)cloudRegion);
        }
        catch (DataAccessException e) {
            logger.error((Object)"create cloudRegion error", (Throwable)e, 0L);
            ExceptionUtil.rethrowException((Throwable)e, (String)("create cloudRegion error:" + cloudRegion.getUuid()), (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public void updateCloudRegion(CloudRegion cloudRegion) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)cloudRegion);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"update cloudRegion error", (Throwable)ex, 0L);
            ExceptionUtil.rethrowException((Throwable)ex, (String)("delete cloudRegion error:" + cloudRegion.getUuid()), (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public void deleteCloudRegion(String uuid) {
        CloudRegion cloudRegion = (CloudRegion)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(CloudRegion.class, (Serializable)((Object)uuid));
        if (null == cloudRegion) {
            return;
        }
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)cloudRegion);
            return;
        }
        catch (DataAccessException e) {
            logger.error((Object)"delete cloudRegion error", (Throwable)e, 0L);
            ExceptionUtil.rethrowException((Throwable)e, (String)("delete cloudRegion error:" + uuid), (long)-1L, (String[])new String[0], (Log)logger);
            return;
        }
    }

    public List<CloudRegion> listCloudRegion() {
        String hql = "from CloudRegion as st order by st.name asc";
        return this.executeQuery(hql);
    }

    public CloudRegion getCloudRegion(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            throw new LegoCheckedException(1073947393L, "the cloudRegion uuid is empty");
        }
        CloudRegion cloudRegion = null;
        try {
            cloudRegion = (CloudRegion)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(CloudRegion.class, (Serializable)((Object)uuid));
        }
        catch (Exception e) {
            logger.error((Object)("failed to get cloudRegion:" + uuid), (Throwable)e, 0L);
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get cloudRegion:" + uuid), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return cloudRegion;
    }

    private Boolean isloudRegionNameExist(String name) {
        try {
            List cloudRegionList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from CloudRegion as st where st.name = ? ", new Object[]{name});
            return !VerifyUtil.isEmpty((Collection)cloudRegionList);
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get cloudRegionList:" + name), (Throwable)e, 0L);
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get cloudRegionList:" + name), (long)-1L, (String[])new String[0], (Log)logger);
            return false;
        }
    }

    private List<CloudRegion> executeQuery(String hql) {
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get cloudRegionList", (Throwable)ex, 0L);
            return new ArrayList<CloudRegion>();
        }
    }
}

