/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.backup.model.BackupStoragePool;
import com.huawei.ism.drm.backup.model.BackupStorageRepository;
import com.huawei.ism.drm.backup.service.IBackupStorageService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteCheckService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.site.sdk.service.IDeleteSiteService", desc="", interfaceClass=ISiteCheckService.class)
public class DeleteCloudSiteServiceImpl
implements ISiteCheckService {
    private static final Log logger = LogFactory.getInstance(DeleteCloudSiteServiceImpl.class);

    public void checkCanDeleteSite(String siteId) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            return;
        }
        if (!site.getIsCloudSite().booleanValue()) {
            return;
        }
        List schedules = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Schedule where protectedType = ?", (Object[])new Integer[]{101});
        for (Schedule schedule : schedules) {
            Site cloudSite;
            BackupStoragePool backupStoragePool;
            if (schedule.getProtectedType() != ScheduleProtectedType.CLOUD_BACKUP.getValue() || VerifyUtil.isEmpty((String)schedule.getExtParameterDatas()) || VerifyUtil.isEmpty((Object)(backupStoragePool = this.getPoolBySchedule(schedule))) || VerifyUtil.isEmpty((String)backupStoragePool.getSiteId()) || backupStoragePool.getStorageType() != 100 || VerifyUtil.isEmpty((Object)(cloudSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(backupStoragePool.getSiteId()))) || !cloudSite.getSiteId().equals(siteId)) continue;
            logger.error((Object)("the site is used" + siteId));
            throw new LegoCheckedException(1073947656L);
        }
        this.checkMountOrRecovery(siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMountOrRecovery(String siteId) {
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select * from ti_rp_globalsettings where PROPNAME = :PROPNAME and PROPVALUE = :PROPVALUE";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setParameter("PROPNAME", (Object)"DISASTER_SITE_ID");
            query.setParameter("PROPVALUE", (Object)siteId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                logger.error((Object)("the site is used by recoveryplan" + siteId));
                throw new LegoCheckedException(1073947656L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying ti_rp_globalsettings failed, siteId:" + siteId + "PROPNAME: DISASTER_SITE_ID" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    private BackupStoragePool getPoolBySchedule(Schedule schedule) {
        List backupStorageRepositorys;
        BackupStoragePool backupStoragePool = null;
        Map extMap = (Map)JSONObject.toBean((String)schedule.getExtParameterDatas(), Map.class);
        String repositoryName = (String)extMap.get("repositoryName");
        HashMap<String, String> filter = new HashMap<String, String>();
        if (!VerifyUtil.isEmpty((String)repositoryName)) {
            filter.put("name", repositoryName);
        }
        if (!VerifyUtil.isEmpty((Collection)(backupStorageRepositorys = ((IBackupStorageService)ServiceLocator.getInstance().getService(IBackupStorageService.class)).listBackupStorageRepository(schedule.getTargetSn(), filter)))) {
            filter.clear();
            String storagePoolName = Optional.ofNullable(backupStorageRepositorys.stream().filter(o -> o != null && o.getName().equals(repositoryName)).findFirst()).get().orElse(new BackupStorageRepository()).getStoragePoolName();
            if (VerifyUtil.isEmpty((String)storagePoolName)) {
                logger.debug((Object)"The storagePoolName is null, repositoryName is %s", new Object[]{repositoryName});
                return null;
            }
            filter.put("poolName", storagePoolName);
            List backupStoragePools = ((IBackupStorageService)ServiceLocator.getInstance().getService(IBackupStorageService.class)).listBackupStoragePool(schedule.getTargetSn(), filter);
            if (!VerifyUtil.isEmpty((Collection)backupStoragePools)) {
                backupStoragePool = Optional.ofNullable(backupStoragePools.stream().filter(o -> o != null && o.getName().equals(storagePoolName)).findFirst()).get().orElse(null);
            }
        }
        if (!VerifyUtil.isEmpty(backupStoragePool) && VerifyUtil.isEmpty((Object)(backupStoragePool = ((IBackupStorageService)ServiceLocator.getInstance().getService(IBackupStorageService.class)).getBackupStoragePool(schedule.getTargetSn(), backupStoragePool.getPoolId())))) {
            logger.info((Object)"the backupStoragePool is null");
            throw new LegoCheckedException(2117645L);
        }
        return backupStoragePool;
    }

    protected Session getHibernateSession() {
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        return session;
    }
}

