/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup.observer;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class SiteProxyOperateObserver
implements IObjectObserver {
    private static Log logger = LogFactory.getInstance(SiteProxyOperateObserver.class);

    public void before(MessageEvent event) {
        logger.info((Object)"enter before");
        Map objectMap = event.getMessageMap();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Map)objectMap)) {
            return;
        }
        for (Map.Entry entry : objectMap.entrySet()) {
            BackupProxy proxy;
            Object object = entry.getValue();
            if (!((String)entry.getKey()).equals(BackupProxy.class.getSimpleName()) || VerifyUtil.isEmpty(object) || !(object instanceof BackupProxy) || !this.checkParam(proxy = (BackupProxy)object)) continue;
            if (messageType == 1) {
                return;
            }
            if (messageType != 2) continue;
            this.isAssociateSite(proxy.getProxyId());
        }
    }

    public void after(MessageEvent event) {
    }

    public String getObserverType() {
        return BackupProxy.class.getName();
    }

    private boolean checkParam(BackupProxy proxy) {
        logger.trace((Object)"enter checkParam");
        return !VerifyUtil.isEmpty((String)proxy.getProxyId());
    }

    private Boolean isAssociateSite(String proxyId) {
        if (VerifyUtil.isEmpty((String)proxyId)) {
            logger.error((Object)("proxyId=" + proxyId), 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
        List<Site> sites = null;
        try {
            sites = this.getSites(proxyId);
        }
        catch (Exception e) {
            logger.error((Object)("unable to get site, proxyId:" + proxyId), new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site, proxyId:" + proxyId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        if (!VerifyUtil.isEmpty(sites)) {
            logger.error((Object)"The Proxy (id: %s) is used by site", new Object[]{proxyId});
            throw new LegoCheckedException(1073947477L, new String[]{sites.toString()});
        }
        return false;
    }

    private List<Site> getSites(String proxyId) {
        try {
            List sites = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site as st where st.proxyId = ? ", new Object[]{proxyId});
            return sites;
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get siteList, proxyId:" + proxyId), (Throwable)e, 0L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }
}

