/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.service.impl.RecoveryManager;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreProcessorManager;
import com.huawei.ism.drm.recovery.framework.task.LocalRecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.MountReplicaBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTaskExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.task.IRecoveryBackTask;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Map;

@Service(name="com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager", desc="", interfaceClass=ILocalRecoveryManager.class)
public class LocalRecoveryManager
extends RecoveryManager
implements ILocalRecoveryManager {
    private static final Log logger = LogFactory.getInstance(LocalRecoveryManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRollBackSnapshot(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            RecoveryPlan recoveryPlan = this.checkAndGetRecoveryPlan(recoveryPlanId, recoveryContext, operator);
            IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
            if (provider == null) {
                logger.debug((Object)"provider is null");
                return;
            }
            Map settings = provider.checkRecoveryContext(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK, recoveryContext, operator);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK);
            settings.put("REPLICA_ID", recoveryContext.get("REPLICA_ID"));
            settings.put("ROLLBACK_RATE", recoveryContext.get("ROLLBACK_RATE"));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            LocalRecoveryBackTask recoveryBackTask = new LocalRecoveryBackTask();
            this.submitRecoveryBackTask(recoveryBackTask, recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    public void startMountSnapshot(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.prepareSuffixType(recoveryPlanId, recoveryContext, "Snapshot");
        LocalRecoveryBackTask task = new LocalRecoveryBackTask();
        this.mountOrTestReplica(task, recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
    }

    public void startUmountSnapshot(String recoveryPlanId, User operator) {
        LocalRecoveryBackTask task = new LocalRecoveryBackTask();
        this.internalUmountReplica(task, recoveryPlanId, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
    }

    public void mountReplica(String planId, Map<String, String> mountParameters, User operator) {
        this.prepareSuffixType(planId, mountParameters, "Replica");
        MountReplicaBackTask task = new MountReplicaBackTask();
        this.mountOrTestReplica(task, planId, mountParameters, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA);
    }

    public void umountReplica(String planId, User operator) {
        MountReplicaBackTask recoveryBackTask = new MountReplicaBackTask();
        this.internalUmountReplica(recoveryBackTask, planId, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUmountReplica(IRecoveryBackTask recoveryBackTask, String recoveryPlanId, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE opType) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkParameters(recoveryPlanId, operator);
            RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(recoveryPlanId, true, false);
            if (null == recoveryPlan) {
                throw new LegoCheckedException(201L);
            }
            this.checkIfProtectObjectExisted(recoveryPlan);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)opType.getValue()));
            this.submitRecoveryBackTask(recoveryBackTask, recoveryPlan, opType, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mountOrTestReplica(IRecoveryBackTask task, String planId, Map<String, String> mountParameters, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE opType) {
        this.checkRecoveryPlanExecuting(planId);
        try {
            IRecoveryProcessBaseProvider provider;
            this.tryLockRecoveryPlan(planId);
            RecoveryPlan recoveryPlan = this.checkAndGetRecoveryPlan(planId, mountParameters, operator);
            HashSet recoverySettings = recoveryPlan.getRecoverySettings();
            if (null == recoverySettings) {
                recoverySettings = new HashSet();
                recoveryPlan.setRecoverySettings(recoverySettings);
            }
            if (null == (provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan))) {
                return;
            }
            Map settings = provider.checkRecoveryContext(planId, opType, mountParameters, operator);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)opType.getValue()));
            settings.put("REPLICA_ID", mountParameters.get("REPLICA_ID"));
            settings.put("volumeType", mountParameters.get("volumeType"));
            recoveryPlan.getGlobalSettings().put("PG_DISASTER_HOST", VerifyUtil.isEmpty((String)mountParameters.get("PG_DISASTER_HOST")) ? "" : mountParameters.get("PG_DISASTER_HOST"));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
            String replicaId = mountParameters.get("REPLICA_ID");
            ProtectGroupReplica replica = service.queryProtectGroupReplicaById(replicaId);
            ILicenseBaseControl licenseController = (ILicenseBaseControl)ServiceLocator.getInstance().getService(ILicenseBaseControl.class);
            licenseController.checkEnablePgCount(replica.getPg());
            this.submitRecoveryBackTask(task, recoveryPlan, opType, operator, mountParameters);
        }
        finally {
            this.unLockRecoveryPlan(planId);
        }
    }

    private RecoveryPlan checkAndGetRecoveryPlan(String planId, Map<String, String> mountParameters, User operator) {
        this.checkParameters(planId, operator);
        this.checkReplicaParameter(mountParameters);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, true, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        return recoveryPlan;
    }

    private void checkReplicaParameter(Map<String, String> parameter) {
        if (VerifyUtil.isEmpty(parameter)) {
            logger.error((Object)"Invalid parameter.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkReplicaId(parameter.get("REPLICA_ID"));
    }

    private void checkReplicaId(String replicaId) {
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)"Invalid parameter.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private synchronized void submitRecoveryBackTask(IRecoveryBackTask recoveryBackTask, RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType, User operator, Map<String, String> recoveryContext) {
        ((IRecoveryPlanService)this.recoveryPlanService).checkBackendRecoveryTaskCount();
        Map<String, Object> initialContextData = this.getInitialContextData(recoveryPlan, null);
        this.setSuffixTypeToContextData(recoveryContext, initialContextData);
        recoveryBackTask.setInitialContextData(initialContextData);
        recoveryBackTask.setRecoveryPlan(recoveryPlan);
        recoveryBackTask.setRecoveryPlanExecuteType(recoveryPlanExecuteType);
        recoveryBackTask.setOperator(operator);
        RecoveryProcessDefinition rpDefinition = this.getRecoveryProcessDef(recoveryPlan, recoveryPlanExecuteType);
        RecoveryProcessSerialExecutor recoveryTemplate = this.getRecoveryTemplate(rpDefinition, recoveryPlanExecuteType);
        recoveryBackTask.setRecoveryProcessTemplate((IProcessor)recoveryTemplate);
        Map preProcessResults = RecoveryPreProcessorManager.getInstance().process(recoveryPlan, recoveryPlanExecuteType);
        recoveryBackTask.setPreProcessResults(preProcessResults);
        RecoveryBackTaskExecutor.submitRecoveryBackTask((IRecoveryBackTask)recoveryBackTask);
    }
}

