/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.service.impl.AbstractRecoveryManager;
import com.huawei.ism.drm.drp.util.RecoveryServiceExtendUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreCheckerManager;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreProcessorManager;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTaskExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.task.ReprotectCallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.task.IRecoveryBackTask;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

@Service(name="com.huawei.ism.drm.drp.sdk.service.IRecoveryManager", desc="", interfaceClass=IRecoveryManager.class)
public class RecoveryManager
extends AbstractRecoveryManager
implements IRecoveryManager {
    private static final Log logger = LogFactory.getInstance(RecoveryManager.class);
    private static final KeyLocker CREATE_TASK_LOCKER = new KeyLocker(RecoveryManager.class, "CREATE_TASK_LOCK");
    private IRecoveryPlanSyncService recoveryPlanSyncService;

    public IRecoveryPlanSyncService getRecoveryPlanSyncService() {
        return this.recoveryPlanSyncService;
    }

    public void setRecoveryPlanSyncService(IRecoveryPlanSyncService recoveryPlanSyncService) {
        this.recoveryPlanSyncService = recoveryPlanSyncService;
    }

    protected void migration(String recoveryPlanId, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, String urlMigration) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(protectGroup.getTemplate().getType());
        if (protectGroup.getTemplate().getType() == 26 && filter.hasOnlyOneNormalReplicationPair(protectGroup)) {
            logger.error((Object)"Ring 3DC does not support this operation,pgName:%s.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948991L);
        }
        this.dealGlobalSettings(recoveryPlan);
        IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        provider.getRecoverySiteId(recoveryPlanId, excuteType, recoveryContext);
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, excuteType);
    }

    protected void checkRecoveryPlanExecuting(String recoveryPlanId) {
        if (RecoveryBackTask.RUN_TASK_LOCKER.isLocked(recoveryPlanId)) {
            logger.error((Object)"The recovery plan is executing. PlanId:%s.", new Object[]{String.valueOf(recoveryPlanId)});
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void tryLockRecoveryPlan(String recoveryPlanId) {
        if (!CREATE_TASK_LOCKER.tryLock(recoveryPlanId)) {
            logger.error((Object)"The recovery plan is executing. PlanId:%s.", new Object[]{String.valueOf(recoveryPlanId)});
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void unLockRecoveryPlan(String recoveryPlanId) {
        CREATE_TASK_LOCKER.unlock(recoveryPlanId);
    }

    private void sendRestRequestToDisasterSite(String recoveryPlanId, Map<String, String> recoveryContext, Site curDisasterSite, String restUrl) {
        this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, curDisasterSite, restUrl, null);
    }

    private void sendRestRequestToDisasterSite(String recoveryPlanId, Map<String, String> recoveryContext, Site curDisasterSite, String restUrl, Map<String, Object> uriVariablesMap) {
        RestClient client = SiteUtil.initClient((Site)curDisasterSite);
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            if (!VerifyUtil.isEmpty(uriVariablesMap)) {
                uriVariables.putAll(uriVariablesMap);
            }
            uriVariables.put("planId", recoveryPlanId);
            uriVariables.put("recoveryContext", recoveryContext);
            JSONObject object = JSONObject.fromObject(recoveryContext);
            client.put(restUrl, object.toString(), uriVariables);
        }
        catch (LegoCheckedException le) {
            ExceptionUtil.rethrowException((Throwable)le, (String)le.getMessage(), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
    }

    private void sendRestRequestToDisasterSite(String recoveryPlanId, Site curDisasterSite, String restUrl) {
        RestClient client = SiteUtil.initClient((Site)curDisasterSite);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("planId", recoveryPlanId);
            client.invoke(restUrl, uriVariables, HttpMethod.PUT);
        }
        catch (LegoCheckedException le) {
            ExceptionUtil.rethrowException((Throwable)le, (String)le.getMessage(), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
            if (provider == null) {
                logger.error((Object)"Provider is null,recoveryPlanId:%s.", new Object[]{recoveryPlanId});
                return;
            }
            HashMap<String, Object> settings = new HashMap<String, String>();
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)execType) || this.validateIsArrayHypermetro(recoveryPlan)) {
                settings.putAll(recoveryContext);
            } else {
                settings = provider.checkRecoveryContext(recoveryPlanId, execType, recoveryContext, operator);
            }
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)execType.getValue()));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVm(recoveryPlan, execType);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)execType.getValue()));
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    protected synchronized void submitRecoveryBackTask(RecoveryPlan plan, RecoveryProcessDefinition rpDefinition, User operator, Map<String, String> recoveryContext) {
        ((IRecoveryPlanService)this.recoveryPlanService).checkBackendRecoveryTaskCount();
        if (plan == null) {
            logger.error((Object)"Param plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (rpDefinition == null) {
            logger.error((Object)"Param rpDefinition is null.");
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)rpDefinition.getProcType());
        Map<String, Object> initialContextData = this.getInitialContextData(plan, rpExecuteType);
        this.setSuffixTypeToContextData(recoveryContext, initialContextData);
        this.setIsConfirmDelProdVmToContextData(recoveryContext, initialContextData);
        this.setContinueTagToContextData(recoveryContext, initialContextData);
        RecoveryBackTask recoveryBackTask = new RecoveryBackTask();
        recoveryBackTask.setInitialContextData(initialContextData);
        recoveryBackTask.setRecoveryPlan(plan);
        recoveryBackTask.setRecoveryPlanExecuteType(rpExecuteType);
        recoveryBackTask.setOperator(operator);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)rpExecuteType)) {
            ReprotectCallBackExcuteRecoveryTask callBackTask = new ReprotectCallBackExcuteRecoveryTask();
            recoveryBackTask.setCallBaskTask(callBackTask);
        }
        RecoveryProcessSerialExecutor recoveryTemplate = this.getRecoveryTemplate(rpDefinition, rpExecuteType);
        recoveryBackTask.setRecoveryProcessTemplate((IProcessor)recoveryTemplate);
        RecoveryPreCheckerManager.getInstance().check(plan, rpExecuteType);
        Map preProcessResults = RecoveryPreProcessorManager.getInstance().process(plan, rpExecuteType);
        recoveryBackTask.setPreProcessResults(preProcessResults);
        logger.info((Object)"Begin submit recovery task. Plan name:%s,id: %s, status:%s, task type:%s", new Object[]{plan.getName(), plan.getPlanId(), plan.getPlanStatus(), rpExecuteType});
        RecoveryBackTaskExecutor.submitRecoveryBackTask((IRecoveryBackTask)recoveryBackTask);
    }

    private void setContinueTagToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("recovery_continue_key")) {
            logger.info((Object)"The recoveryContext is empty or recovery_continue_key is not exist.");
            return;
        }
        initialContextData.put("IS_CONTINUE_PROCESS", recoveryContext.get("recovery_continue_key"));
    }

    private void setIsConfirmDelProdVmToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("is_confirm_del_prod_vm")) {
            logger.info((Object)"The recoveryContext is empty or is_confirm_del_prod_vm is not exist.");
            return;
        }
        initialContextData.put("is_confirm_del_prod_vm", recoveryContext.get("is_confirm_del_prod_vm"));
        initialContextData.put("IS_CONFIRM_REPROTECTION", recoveryContext.get("is_confirm_reprotection"));
    }

    protected RecoveryProcessSerialExecutor getRecoveryTemplate(RecoveryProcessDefinition rpDefinition, DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType) {
        if (rpDefinition == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Set processors = rpDefinition.getRecoveryProcessors();
        List sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)processors);
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((List)sortedProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)recoveryPlanExecuteType);
        if (executor == null) {
            logger.error((Object)"Creating recovery process executor failed.");
            throw new LegoCheckedException(0x300001L);
        }
        return executor;
    }

    protected Map<String, Object> getInitialContextData(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType) {
        HashMap<String, Object> initialContextData = new HashMap<String, Object>();
        String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        String replicaId = (String)plan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        ProtectGroupReplica replica = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId((ProtectGroup)protectGroup, (String)replicaId);
        if (replica == null) {
            IRecoveryProcessBaseService baseService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            replica = baseService.getProtectGroupReplicaBySiteId(protectGroup, disasterSiteId);
        }
        if (replica == null) {
            logger.error((Object)"Method getReplica failed:%s,pg:%s", new Object[]{replicaId, protectGroup.getName()});
            return initialContextData;
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replica = replicaService.queryProtectGroupReplicaById(replica.getId());
        logger.info((Object)"Initial context data, PlanId:%s, SiteId:%s, ReplicaId:%s, Replica:%s", new Object[]{plan.getPlanId(), disasterSiteId, replicaId, replica});
        Set protectObjects = RecoveryProcessUtil.getRecoveryProtectObjects((ProtectGroup)protectGroup, (ProtectGroupReplica)replica, (DrmEnumDefine.RecoveryPlanExecuteTypeE)rpExecuteType);
        initialContextData.put("Recovery_ProtectObjects", protectObjects);
        initialContextData.put("Recovery_ProtectGroup", protectGroup);
        initialContextData.put("Recovery_PgReplica", replica);
        return initialContextData;
    }

    protected RecoveryPlan updateRecoveryPlanSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        if (recoveryPlan == null || VerifyUtil.isEmpty(settings)) {
            return recoveryPlan;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
        settings.put("PRODUCT_SITE_ID", productSiteId);
        HashSet recoverySettings = recoveryPlan.getRecoverySettings();
        if (recoverySettings == null) {
            recoverySettings = new HashSet();
            recoveryPlan.setRecoverySettings(recoverySettings);
        }
        Map globalSettings = recoveryPlan.getGlobalSettings();
        HashMap<String, Object> syncSettings = new HashMap<String, Object>();
        syncSettings.putAll(globalSettings);
        String disasterSiteId = String.valueOf(settings.get("DISASTER_SITE_ID"));
        Set<Map.Entry<String, Object>> settingsEntrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : settingsEntrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) {
                globalSettings.put(key, String.valueOf(value));
                syncSettings.put(key, value);
                continue;
            }
            Map subSettingsMap = (Map)value;
            Set subEntrySet = subSettingsMap.entrySet();
            for (Map.Entry subEntry : subEntrySet) {
                Object subKey = subEntry.getKey();
                Object subValue = subEntry.getValue();
                RecoverySetting recoverySetting = new RecoverySetting();
                recoverySetting.setRecoveryPlan(recoveryPlan);
                recoverySetting.setDisasterSiteId(disasterSiteId);
                recoverySetting.setOwnerId(String.valueOf(subKey));
                recoverySetting.setName(key);
                recoverySetting.setValue(String.valueOf(subValue));
                RecoveryServiceUtil.resetRecoverySetting(recoverySettings, (RecoverySetting)recoverySetting);
            }
        }
        this.syncSettingsToRemote(recoveryPlan, syncSettings);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return recoveryPlan;
    }

    protected void syncSettingsToRemote(final RecoveryPlan recoveryPlan, final Map<String, Object> syncSettings) {
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            return;
        }
        final Iterator<Site> iterator = remoteSites.iterator();
        if (iterator.hasNext()) {
            FixedRecoveryThreadPool.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        RecoveryManager.this.recoveryPlanSyncService.syncGlobalSettingsToRemote((Site)iterator.next(), recoveryPlan.getPlanId(), syncSettings);
                    }
                    catch (Exception e) {
                        logger.error((Object)"SyncSettingsToRemote failed, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    }
                    return Boolean.TRUE;
                }
            });
        }
    }

    private boolean validateIsArrayHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)protectGroups.iterator().next();
        if (pg.getTemplate().getType() != 15) {
            return false;
        }
        ProtectObject po = (ProtectObject)pg.getPolist().iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)"usedStorageResourceSet is empty! pgName : %s, po:%s, poName:%s.", new Object[]{pg.getName(), po.getMoUuid(), po.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.LUN.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDisasterRecovery(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkParameters(recoveryPlanId, recoveryContext, operator);
            RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
            IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
            Map settings = provider.checkRecoveryContext(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, recoveryContext, operator);
            String newDisasterSiteId = null;
            Object disasterSiteValue = settings.get("DISASTER_SITE_ID");
            if (disasterSiteValue != null) {
                newDisasterSiteId = String.valueOf(disasterSiteValue);
            }
            RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, (String)newDisasterSiteId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY);
            this.dealGlobalSettings(recoveryPlan);
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVm(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    public void continuePlannedMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        this.dealGlobalSettings(recoveryPlan);
        String recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, recoveryContext);
        Site recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
        if (recoverySite.getSiteType() != 0) {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            uriVariables.put("actionType", DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue());
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, "/ws/recoveryplans/{planId}/action/{actionType}/continue", uriVariables);
        } else {
            this.handleRecoveryContinue(recoveryPlan, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, recoveryContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryContinue(RecoveryPlan recoveryPlan, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE executeType, Map<String, String> recoveryContext) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkRecoveryPlanPaused(recoveryPlan);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)executeType.getValue()));
            RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(executeType);
            if (rpDefinition == null) {
                logger.error((Object)"The recoveryProcessDefinition is null!");
                throw new LegoCheckedException(1073947393L);
            }
            this.submitRecoveryBackTask(recoveryPlan, rpDefinition, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    private void checkRecoveryPlanPaused(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() != recoveryPlan.getPlanStatus()) {
            String msg = String.format(Locale.ROOT, "The recovery plan is not paused. PlanId:%s .", recoveryPlan.getPlanId());
            logger.error((Object)msg);
            throw new LegoCheckedException(msg);
        }
    }

    public void startRecoveryDrilling(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        String recoverySiteId = null;
        if (this.validateIsArrayHypermetro(recoveryPlan)) {
            this.checkPriorityStationType(recoveryContext);
            recoverySiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
            recoveryContext.put("DISASTER_SITE_ID", recoverySiteId);
        } else {
            recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, recoveryContext);
        }
        Site recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
        this.dealGlobalSettings(recoveryPlan);
        this.prepareSuffixType(recoveryPlanId, recoveryContext, "Drilling");
        if (recoverySite.getSiteType() != 0) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, "/ws/recoveryplans/{planId}/action/test");
        } else {
            this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
        }
    }

    private void checkPriorityStationType(Map<String, String> recoveryContext) {
        String priorityStationType = recoveryContext.get("priorityStationType");
        HashSet<String> types = new HashSet<String>();
        types.add(String.valueOf(0));
        types.add(String.valueOf(1));
        if (VerifyUtil.isEmpty((String)priorityStationType)) {
            logger.error((Object)"The priorityStationType is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!types.contains(priorityStationType)) {
            logger.error((Object)"The priorityStationType is error, priorityStationType: %s.", new Object[]{priorityStationType});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void cleanRecoveryDrilling(String recoveryPlanId, User operator, Map<String, String> recoveryContext) {
        this.checkParameters(recoveryPlanId, operator);
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId);
        Site recoverySite = this.getRecoverySite(recoveryPlan);
        if (recoverySite.getSiteType() != 0) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoverySite, "/ws/recoveryplans/{planId}/action/testCleanup");
        } else {
            this.handleRecoveryOperation(recoveryPlan, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
        }
    }

    private Site getRecoverySite(RecoveryPlan recoveryPlan) {
        String recoverySiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)recoverySiteId)) {
            throw new LegoCheckedException(1073948768L);
        }
        return RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
    }

    private RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (recoveryPlan == null) {
            logger.error((Object)"Param recoveryPlan is null.");
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        return recoveryPlan;
    }

    public void reprotectRecoveryPlan(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (recoveryPlan == null) {
            logger.error((Object)"Reprotect recoveryPlan fail,param recoveryPlan is null.");
            throw new LegoCheckedException(201L);
        }
        Site recoverySite = this.getRecoverySite(recoveryPlan);
        if (recoverySite.getSiteType() != 0) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, "/ws/recoveryplans/{planId}/action/reprotect");
        } else {
            RecoveryServiceUtil.checkReprotectOperationPrivilege((RecoveryPlan)recoveryPlan);
            this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT);
        }
    }
}

