/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCreateEventHandler;
import com.huawei.ism.drm.drp.service.impl.AbstractRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceExtendUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.recovery.service.DrsRecoveryService;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

@Service(name="com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService", desc="", interfaceClass=IRecoveryPlanBaseService.class)
public class RecoveryPlanBaseServiceImpl
extends AbstractRecoveryPlanBaseService
implements IRecoveryPlanBaseService {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanBaseServiceImpl.class);

    protected List<RecoveryPlan> foreignKeyQueryFilter(Long userId, List<RecoveryPlan> srcRps, Map<String, Object> filterMap) {
        ArrayList<RecoveryPlan> resRps = new ArrayList<RecoveryPlan>();
        Integer appType = MapUtils.getInteger(filterMap, (Object)"appType");
        String productSiteId = MapUtils.getString(filterMap, (Object)"productSiteId");
        String protectGroupId = MapUtils.getString(filterMap, (Object)"protectGroupId");
        String createStartTime = MapUtils.getString(filterMap, (Object)"createStartTime");
        String createEndTime = MapUtils.getString(filterMap, (Object)"createEndTime");
        String replicaId = MapUtils.getString(filterMap, (Object)"replicaId");
        String mountSiteId = MapUtils.getString(filterMap, (Object)"mountSiteId");
        String mountHostId = MapUtils.getString(filterMap, (Object)"mountHostId");
        List protectGroups = this.getAllProtectGroups(userId);
        Map planIdPgIdMap = this.getPlanIdPgIdMap();
        Map<String, String> planIdReplcaIdMap = this.getPlanIdReplicaIdMap();
        Map<String, String> replicaIdMountConfigMap = this.getMountConfigMap();
        for (RecoveryPlan rp : srcRps) {
            String pgId = (String)planIdPgIdMap.get(rp.getPlanId());
            ProtectGroup pg = Optional.of(protectGroups.stream().filter(protectGroup -> protectGroup.getUuid().equals(pgId)).findAny()).get().orElse(null);
            if (VerifyUtil.isEmpty((Object)pg)) {
                logger.error((Object)"plan bind pg is null. planId:%s.", new Object[]{rp.getPlanId()});
                continue;
            }
            if (!this.isConditionFilter(protectGroupId, pg.getUuid()) || !this.isConditionFilter(productSiteId, pg.getProductSiteId()) || !this.isConditionFilter(appType, pg.getPoType()) || !this.isTimeRange(createStartTime, createEndTime, rp.getCreateTime())) continue;
            this.mountConfigsFilter(resRps, rp, planIdReplcaIdMap, replicaIdMountConfigMap, replicaId, mountSiteId, mountHostId);
        }
        this.hwStackFilter(filterMap, resRps, protectGroups, planIdPgIdMap);
        return resRps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMountConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = null;
        try {
            map = new HashMap();
            session = this.getHibernateSession();
            String strSql = "select ID,PROPVALUE from ti_protectgroupreplica_prop where PROPNAME=:PROPNAME";
            NativeQuery query = session.createSQLQuery(strSql);
            query.setParameter("PROPNAME", (Object)"mountConfigs");
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || (values = (Object[])object).length != 2) continue;
                map.put(CommUtil.convertToString((Object)values[0]), CommUtil.convertToString((Object)values[1]));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Getting all globalsettings failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPlanIdReplicaIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = null;
        try {
            map = new HashMap();
            session = this.getHibernateSession();
            String strSql = "select PLANID,PROPVALUE from ti_rp_globalsettings where PROPNAME=:PROPNAME";
            NativeQuery query = session.createSQLQuery(strSql);
            query.setParameter("PROPNAME", (Object)"REPLICA_ID");
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || (values = (Object[])object).length != 2) continue;
                map.put(CommUtil.convertToString((Object)values[0]), CommUtil.convertToString((Object)values[1]));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Getting all globalsettings failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return map;
    }

    private void mountConfigsFilter(List<RecoveryPlan> resRps, RecoveryPlan rp, Map<String, String> planIdReplcaIdMap, Map<String, String> replicaIdMountConfigMap, String replicaId, String mountSiteId, String mountHostId) {
        if (rp.getUse().equals(RecoveryPlan.MOUNT_PLAN)) {
            String replicaIdInRp = planIdReplcaIdMap.get(rp.getPlanId());
            if (!this.isConditionFilter(replicaId, replicaIdInRp)) {
                return;
            }
            String mountConfigs = replicaIdMountConfigMap.get(replicaIdInRp);
            if (VerifyUtil.isEmpty((String)mountConfigs)) {
                if (mountHostId == null && mountSiteId == null) {
                    resRps.add(rp);
                }
                logger.error((Object)"mountConfigs is not exist. replicaId:%s.", new Object[]{replicaIdInRp});
                return;
            }
            MountConfiguration mc = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
            String mountSiteIdInRp = mc.getSiteId();
            String mountHostIdInRp = mc.getHostOrGroupSn();
            if (this.isConditionFilter(mountHostId, mountHostIdInRp) && this.isConditionFilter(mountSiteId, mountSiteIdInRp)) {
                HashMap<String, String> globalSetting = new HashMap<String, String>();
                globalSetting.put("mountConfig", mountConfigs);
                rp.setGlobalSettings(globalSetting);
                resRps.add(rp);
            }
        } else if (rp.getUse().equals(RecoveryPlan.RECOVERY_PLAN)) {
            resRps.add(rp);
        }
    }

    protected void fillRecoveryPlan(List<RecoveryPlan> recoveryPlans) {
        if (VerifyUtil.isEmpty(recoveryPlans)) {
            logger.debug((Object)"recoveryPlans is null");
            return;
        }
        Map<Site, List<String>> siteAndPlansMap = this.constructSiteAndPlansMap(recoveryPlans);
        Map<String, Map<String, Object>> planProgressMap = this.queryRecoveryProgressFromRemote(siteAndPlansMap);
        if (VerifyUtil.isEmpty(planProgressMap)) {
            return;
        }
        for (RecoveryPlan obj : recoveryPlans) {
            Map<String, Object> planInfos;
            if (obj.getPlanProgress() > 0 || VerifyUtil.isEmpty(planInfos = planProgressMap.get(obj.getPlanId()))) continue;
            Object planProgress = planInfos.get("planProgress");
            Object planStatus = planInfos.get("planStatus");
            if (planProgress != null) {
                obj.setPlanProgress(((Integer)planProgress).intValue());
            }
            if (planStatus == null) continue;
            obj.setPlanStatus(((Integer)planStatus).intValue());
        }
    }

    private Map<String, Map<String, Object>> queryRecoveryProgressFromRemote(Map<Site, List<String>> siteAndPlansMap) {
        HashMap<String, Map<String, Object>> planProgressMap = new HashMap<String, Map<String, Object>>();
        Set<Map.Entry<Site, List<String>>> entrySet = siteAndPlansMap.entrySet();
        for (Map.Entry<Site, List<String>> entry : entrySet) {
            Site remoteSite = entry.getKey();
            List<String> planIds = entry.getValue();
            if (remoteSite.getSiteType() == 0) continue;
            try {
                RestClient client = SiteUtil.initClient((Site)remoteSite);
                Map result = (Map)client.postSerializableObj(planIds, "/ws/recoveryplans/getRecoveryPlanProgress", Map.class);
                if (VerifyUtil.isEmpty((Map)result)) continue;
                Set set = result.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry planAndProgressEntry = obj = iterator.next();
                    Map planInfos = (Map)planAndProgressEntry.getValue();
                    String planId = String.valueOf(planAndProgressEntry.getKey());
                    Integer progress = Integer.valueOf(String.valueOf(planInfos.get("planProgress")));
                    Integer status = Integer.valueOf(String.valueOf(planInfos.get("planStatus")));
                    HashMap<String, Integer> infos = new HashMap<String, Integer>();
                    infos.put("planProgress", progress);
                    infos.put("planStatus", status);
                    planProgressMap.put(planId, infos);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Getting plan progress failed. SiteName:%s,Ip:%s,PlanIds:%s\u3002", new Object[]{remoteSite.getName(), remoteSite.getSiteId(), planIds.toString()});
            }
        }
        return planProgressMap;
    }

    private Map<Site, List<String>> constructSiteAndPlansMap(List<?> recoveryPlans) {
        HashMap<Site, List<String>> siteAndPlansMap = new HashMap<Site, List<String>>();
        for (Object object : recoveryPlans) {
            RecoveryPlan plan = (RecoveryPlan)object;
            logger.debug((Object)"recoveryPlans is: %s.", new Object[]{plan.getPlanId()});
            plan.setProtectGroups(this.getProtectGroupsByPlanId(plan.getPlanId(), false));
            plan.setGlobalSettings(this.getRecoveryGlobalSettings(plan.getPlanId()));
            Site remoteDisasterSite = RecoveryServiceExtendUtil.getRemoteDisasterSite(plan);
            if (remoteDisasterSite == null) {
                String isReconfigSuccess = (String)plan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
                if (!String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(isReconfigSuccess)) continue;
                ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
                String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)plan);
                remoteDisasterSite = siteService.getSiteById(productSiteId);
            }
            List planIds = siteAndPlansMap.computeIfAbsent(remoteDisasterSite, kk -> new ArrayList());
            planIds.add(plan.getPlanId());
        }
        return siteAndPlansMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ProtectGroup> getProtectGroupsByPlanId(String planId, boolean isQueryPos) {
        HashSet<ProtectGroup> protectGroups = new HashSet();
        Session session = null;
        try {
            session = this.getHibernateSession();
            protectGroups = this.getProtectGroupsByPlanId(planId, session, isQueryPos, false);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getProtectGroupsByPlanId failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
        return protectGroups;
    }

    protected void initRecoveryPlan(RecoveryPlan recoveryPlan, Set<RecoveryProcessDefinition> processes) {
        Object object;
        recoveryPlan.setRecoveryProcesses(processes);
        if (VerifyUtil.isEmpty((Object)recoveryPlan.getCreateTime())) {
            recoveryPlan.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        }
        if ((object = ServiceLocator.getBundleService((String)"DRM_FusionShpere_Base", (String)"DrsRecoveryServiceImpl")) instanceof DrsRecoveryService) {
            DrsRecoveryService drsRecoveryService = (DrsRecoveryService)object;
            drsRecoveryService.needInitDrs(recoveryPlan);
        }
    }

    protected void checkRecoveryPlanForCreate(RecoveryPlan recoveryPlan, boolean supportMultiPlan) {
        this.checkParameterValidityForCreate(recoveryPlan);
        Integer planUse = recoveryPlan.getUse();
        if (VerifyUtil.isEmpty((Object)planUse)) {
            planUse = RecoveryPlanUse.PUBLIC_USE.getValue();
        }
        if (this.isExistedRecoveryPlanByName(recoveryPlan.getName(), planUse)) {
            logger.error((Object)"The plan name already exists. PlanName:%s.", new Object[]{90160758784001L, recoveryPlan.getName()});
            String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site productSite = siteService.getSiteById(productSiteId);
            List localSites = siteService.getAllLocalSites();
            boolean isProductLocal = localSites.contains(productSite);
            Set disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds((RecoveryPlan)recoveryPlan);
            boolean isDisasterLocal = RecoveryServiceUtil.isExistLocalRecoverySite((Set)disasterSiteIds);
            if (isProductLocal && !isDisasterLocal) {
                throw new LegoCheckedException(1073948725L);
            }
            if (!isProductLocal && isDisasterLocal) {
                throw new LegoCheckedException(1073948726L);
            }
            throw new LegoCheckedException(1073947392L);
        }
        if (!supportMultiPlan && this.isExistedAssociatedRecoveryPlan(recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The associated recovery plan already exists. PlanName:%s.", new Object[]{90160758784001L, recoveryPlan.getName()});
            throw new LegoCheckedException(1073948694L);
        }
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            IProtectObjectBaseProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
            if (!provider.needRefreshPgStorageInfoPreBuildReplica(protectGroup)) continue;
            logger.error((Object)"protect group cannot create recovery plan.name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948748L);
        }
        this.checkRecoveryPlanNumLimit(recoveryPlan);
    }

    protected RecoveryProcessor getRecoveryProcessor(RecoveryProcessor processor) {
        RecoveryProcessor newProcessor = new RecoveryProcessor();
        this.constructionBaseProcessor(newProcessor, processor);
        Map props = processor.getProps();
        if (!processor.getIsPreset().booleanValue()) {
            JSONObject executeParams = JSONObject.fromObject(props.get("STEP_PARAMS"));
            Map data = newProcessor.getProps();
            String isUserDefined = (String)props.get("isUserDefined");
            if ("false".equals(isUserDefined)) {
                IHostScriptSchemeService schemeService = (IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class);
                String schemeId = (String)props.get("recoveryScriptSchemeId");
                Map paramValidation = schemeService.getParamValidation(schemeId);
                String stepParamsStr = ScriptParamsUtils.filterSensitiveParam((Map)paramValidation, (String)executeParams.toString());
                data.put("STEP_PARAMS", stepParamsStr);
                data.put("recoveryScriptSchemeId", props.get("recoveryScriptSchemeId"));
            } else {
                data.put("STEP_PARAMS", executeParams.toString());
            }
            data.put("isUserDefined", isUserDefined);
            data.put("position", props.get("position"));
            data.put("EXECUTE_POLICY", props.get("EXECUTE_POLICY"));
        }
        return newProcessor;
    }

    protected void deleteRecoveryPlanExtendAction(RecoveryPlan recoveryPlan, boolean isNeedSyncRemove) {
        block5: {
            if (recoveryPlan.getUse() == 1) {
                IUseCopyDataService copyDataService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
                copyDataService.deleteTask(recoveryPlan);
            }
            if (isNeedSyncRemove) {
                RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN);
                if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType()) {
                    try {
                        long startAA = System.currentTimeMillis();
                        this.setPoRepToRecoveryPlan(recoveryPlan);
                        long startBB = System.currentTimeMillis();
                        this.getRecoveryPlanSyncService().removeRemoteRecoveryPlan(recoveryPlan);
                        long startCC = System.currentTimeMillis();
                        logger.info((Object)"set PoRep To RecoveryPlan cost time:%s, remove RemoteRecoveryPlan cost time:%s.", new Object[]{String.valueOf(startBB - startAA), String.valueOf(startCC - startBB)});
                    }
                    catch (LegoCheckedException ex) {
                        logger.error((Object)"Deleting remote rp failed. id:%s,error is %s.", new Object[]{recoveryPlan.getPlanId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
                        if (ex.getErrorCode() == 201L || ex.getErrorCode() == 1073947394L) break block5;
                        throw ex;
                    }
                }
            }
        }
    }

    public String getHostName(String hostId, Site site, ProtectGroup pg) {
        String hostName = "--";
        if (pg.getPoType() == 10) {
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("uuid", hostId);
            List moLists = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).queryMoList(ManagedObject.class, querys);
            if (!VerifyUtil.isEmpty((Collection)moLists)) {
                ManagedObject mo = (ManagedObject)moLists.get(0);
                hostName = mo.getName();
            }
            return hostName;
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostId);
        if (drResource != null) {
            return drResource.getName();
        }
        DrResource cloudServer = (DrResource)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(DrResource.class, (Serializable)((Object)hostId));
        if (!VerifyUtil.isEmpty((Object)cloudServer)) {
            return cloudServer.getName();
        }
        return hostName;
    }

    public void addRecoveryPlanCreateEventHandler(IRecoveryPlanCreateEventHandler handler, Map<String, Object> props) {
        if (handler != null && !this.recoveryPlanCreateEventHandlers.contains(handler)) {
            this.recoveryPlanCreateEventHandlers.add(handler);
        }
    }
}

