/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanBaseServiceImpl;
import com.huawei.ism.drm.drp.util.RecoveryServiceExtendUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceRemoteUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Service(name="IRecoveryPlanService", desc="", interfaceClass=IRecoveryPlanService.class)
public class RecoveryPlanServiceImpl
extends RecoveryPlanBaseServiceImpl
implements IRecoveryPlanService {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanServiceImpl.class);

    public void checkBackendRecoveryTaskCount() {
        int count = this.getBackRunningRecoveryTaskNum();
        if (count >= 10) {
            throw new LegoCheckedException(1073948713L, new String[]{String.valueOf(10)});
        }
    }

    public void disableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, false, true);
    }

    public void updateRecoveryProcessorEnableStatus(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId, boolean isEnable, boolean isNeedSync) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)procId) || procType == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(planId, false, false);
        if (recoveryPlan == null) {
            logger.debug((Object)"The recoveryPlan is null.");
            throw new LegoCheckedException(201L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR);
        if (isNeedSync) {
            RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite((RecoveryPlan)recoveryPlan, null);
            List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
            if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType()) {
                HashMap<String, Object> requestMsg = new HashMap<String, Object>();
                requestMsg.put("planId", planId);
                requestMsg.put("procType", procType);
                requestMsg.put("procId", procId);
                requestMsg.put("isEnable", isEnable);
                RecoveryServiceRemoteUtil.syncCrdOperationToRemote(remoteSites, requestMsg, "/ws/recoveryplans/syncUpdateRecoveryProcessorEnableStatus");
            }
        }
        Set processes = this.getRecoveryProcesses(planId, procType.getValue());
        this.saveOrUpdateProcessorEnableStatus(procId, isEnable, processes);
    }

    private void saveOrUpdateProcessorEnableStatus(String procId, boolean isEnable, Set<RecoveryProcessDefinition> processes) {
        if (VerifyUtil.isEmpty(processes)) {
            logger.debug((Object)"processes is null,procId=%s", new Object[]{procId});
            throw new LegoCheckedException(1073947393L);
        }
        boolean isProcessorExist = false;
        Iterator<RecoveryProcessDefinition> iterator = processes.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = iterator.next();
        for (RecoveryProcessor processor : rpDefinition.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            isProcessorExist = true;
            if (!processor.getIsEditable().booleanValue()) {
                throw new LegoCheckedException(1073948732L);
            }
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)processor);
            MessageEvent event = MessageEvent.createMessageEvent((int)1, (Object[])new Object[]{rpDefinition, processor});
            this.notifyListener(event);
            break;
        }
        if (!isProcessorExist) {
            throw new LegoCheckedException(201L);
        }
    }

    public void disableAllSchemeRecoveryProcessor(String planId) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, true);
        Set recoveryProcessDefinitions = recoveryPlan.getRecoveryProcesses();
        for (RecoveryProcessDefinition definition : recoveryProcessDefinitions) {
            for (RecoveryProcessor processor : definition.getRecoveryProcessors()) {
                boolean isUserDefined = Boolean.parseBoolean((String)processor.getProps().get("isUserDefined"));
                if (processor.getIsPreset().booleanValue() || isUserDefined) continue;
                this.disableRecoveryProcessor(processor.getPlanId(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)processor.getProcType()), processor.getProcId());
            }
        }
    }

    public void enableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, true, true);
    }

    public void createMountPlan(User user, MountConfiguration mountPlan) {
        logger.debug((Object)"begin to createMountPlan.");
        if (mountPlan == null) {
            logger.error((Object)"The parameter mountPlan is null .");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkMountPlan(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        String mountConfigs = JSONObject.fromObject((Object)mountPlan).toString();
        replicaService.mountReplica(user, mountPlan.getProtectGroupId(), mountPlan.getReplicaId(), mountConfigs);
    }

    private void checkMountPlan(MountConfiguration mountPlan) {
        int[] targetTypes;
        if (VerifyUtil.isEmpty((String)mountPlan.getHostOrGroupSn())) {
            logger.error((Object)"mount plan %s mount host is invalid.", new Object[]{mountPlan.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        if (!VerifyUtil.isEmpty((String)mountPlan.getSiteId()) && VerifyUtil.isEmpty((Object)(site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(mountPlan.getSiteId())))) {
            logger.error((Object)"The site is not exist, siteId is %s.", new Object[]{mountPlan.getSiteId()});
            throw new LegoCheckedException(2117645L, "The site is not exist");
        }
        this.filter(mountPlan);
        String protectGroupId = mountPlan.getProtectGroupId();
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"protect group not exist.id:%s", new Object[]{protectGroupId});
            throw new LegoCheckedException(2117645L);
        }
        IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        if (provider.needRefreshPgStorageInfoPreBuildReplica(protectGroup)) {
            logger.error((Object)"protect group cannot create recovery plan.name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948748L);
        }
        this.checkTime(mountPlan);
        for (int targetType : targetTypes = new int[]{-1, 3, 9, 10, 5}) {
            if (targetType != mountPlan.getTargetReplicaType()) continue;
            return;
        }
        logger.error((Object)"target type is invalid, targetReplicaType is %s.", new Object[]{String.valueOf(mountPlan.getTargetReplicaType())});
        throw new LegoCheckedException(1073947393L);
    }

    private void checkTime(MountConfiguration mountPlan) {
        if (!VerifyUtil.isEmpty((String)mountPlan.getStartTime())) {
            Date execDate;
            Date currentDate = new Date();
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                execDate = sDateFormat.parse(mountPlan.getStartTime());
            }
            catch (Exception e) {
                logger.error((Object)"mountplan start time is error format, mountPlan startTime :%s.", new Object[]{mountPlan.getStartTime()});
                throw new LegoCheckedException(1073947393L);
            }
            if (currentDate.getTime() >= execDate.getTime()) {
                logger.error((Object)"Execution time startTime :%s is less than current time.", new Object[]{mountPlan.getStartTime()});
                throw new LegoCheckedException(1073948456L);
            }
        }
    }

    private void filter(MountConfiguration mountPlan) {
        DrResource hostOrGroup = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(mountPlan.getHostOrGroupSn().split(":")[0]);
        if (VerifyUtil.isEmpty((Object)hostOrGroup)) {
            logger.error((Object)"mount plan %s mount host is not exist.", new Object[]{mountPlan.getName()});
            throw new LegoCheckedException(1077950337L, "The host is not exist");
        }
    }

    public void execMountPlanManual(User user, RecoveryPlan mountPlan) {
        logger.debug((Object)"begin to execMountPlanManual.");
        if (mountPlan == null) {
            logger.error((Object)"The mountPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaBaseService replicaService = (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"can not get replica with replica id %s.", new Object[]{replicaId});
            throw new LegoCheckedException(2117645L);
        }
        if (replica.getStatus() != 1) {
            logger.error((Object)"Replica is not valid: %s, status=%s.", new Object[]{replica.getId(), String.valueOf(replica.getStatus())});
            throw new LegoCheckedException(1073948459L);
        }
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory factory = manager.getReplicaFactory(replica.getType());
        if (!factory.validReplica(replica, true)) {
            logger.error((Object)"Replica is not valid: %s.", new Object[]{replica.getId()});
            throw new LegoCheckedException(1073948459L);
        }
        String mountConfigs = this.getMountConfigByReplicaId(replica);
        MountConfiguration mountCnf = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        String hostSn = mountCnf.getHostOrGroupSn();
        mountCnf.getExtParameters().put("REPLICA_ID", replicaId);
        mountCnf.getExtParameters().put("PG_DISASTER_HOST", hostSn);
        mountCnf.getExtParameters().put("disasterHostSn", hostSn);
        IUseCopyDataService useCopyService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        useCopyService.mountReplica(mountPlan.getPlanId(), replicaId, mountCnf, user);
        IUseCopyDataService service = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        service.updateTask(mountPlan, null);
        mountCnf.setStartTime(null);
        ProtectGroupReplica newReplica = replicaService.queryProtectGroupReplicaById(replicaId);
        String newConfig = JSONObject.fromObject((Object)mountCnf).toString();
        newReplica.addProperty("mountConfigs", newConfig);
        replicaService.saveOrUpdateReplica(newReplica);
    }

    public void clearMountPlanManual(User user, RecoveryPlan mountPlan, boolean isDeleteReplica) {
        logger.debug((Object)"begin to clearMountPlanManual.");
        if (mountPlan == null) {
            logger.error((Object)"The parameter mountPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replicaService.unmountReplica(user, mountPlan.getProtectGroup().getUuid(), replicaId, isDeleteReplica);
    }

    public void modifyMountplan(User user, RecoveryPlan mountPlan, MountConfiguration configuration) {
        String startTime;
        logger.debug((Object)"begin to modifyMountplan.");
        if (VerifyUtil.isEmpty((Object)mountPlan) || VerifyUtil.isEmpty((Object)configuration)) {
            logger.error((Object)"The parameter mountPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaBaseService replicaService = (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        String mountConfigs = this.getMountConfigByReplicaId(replica);
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        if (mountConfiguration == null) {
            logger.error((Object)"The mountConfiguration is null.");
            return;
        }
        IUseCopyDataService service = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        String string = startTime = configuration.getStartTime() == null ? "" : configuration.getStartTime();
        if (VerifyUtil.isEmpty((String)startTime)) {
            this.execMountPlanManual(user, mountPlan);
        } else {
            this.updateTaskForStartTime(mountPlan, startTime, service);
        }
        mountConfiguration.setStartTime(startTime);
        String name = configuration.getName();
        mountPlan.setName(name);
        mountConfiguration.setName(name);
        String description = configuration.getDescription();
        mountPlan.setDescription(description);
        mountConfiguration.setDescription(description);
        this.getBaseDao().getTransactionTemplate().execute(status -> {
            ProtectGroupReplica newReplica = replicaService.queryProtectGroupReplicaById(replicaId);
            if (VerifyUtil.isEmpty((Object)newReplica)) {
                logger.error((Object)"replica dose not exists. replicaId:[%s]", new Object[]{replicaId});
                throw new LegoCheckedException(2117645L);
            }
            String newConfig = JSONObject.fromObject((Object)mountConfiguration).toString();
            newReplica.addProperty("mountConfigs", newConfig);
            replicaService.saveOrUpdateReplica(newReplica);
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)mountPlan);
            return null;
        });
    }

    private void updateTaskForStartTime(RecoveryPlan mountPlan, String startTime, IUseCopyDataService service) {
        Date startDate = null;
        try {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            startDate = sDateFormat.parse(startTime, new ParsePosition(0));
        }
        catch (Exception e) {
            String errorMsg = "parse start time got error,startTime cannot  from \"yyyy-MM-dd HH:mm:ss\". startTime:" + startTime;
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
        Date currentDate = new Date();
        if (currentDate.getTime() >= startDate.getTime()) {
            logger.error((Object)"Execution time %s is less than current time.", new Object[]{startTime});
            throw new LegoCheckedException(1073948456L);
        }
        String newTime = String.valueOf(startDate.getTime());
        service.updateTask(mountPlan, newTime);
    }

    private String getReplicaIdByPlanId(RecoveryPlan mountPlan) {
        String replicaId = (String)mountPlan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)"mountPlan (%s) have no replica, can not mount replica!", new Object[]{mountPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        return replicaId;
    }

    private String getMountConfigByReplicaId(ProtectGroupReplica replica) {
        String mountConfigs = replica.getProperty("mountConfigs");
        if (VerifyUtil.isEmpty((String)mountConfigs)) {
            logger.error((Object)"replica id (%s) can not get mountConfiguration.", new Object[]{replica.getId()});
            throw new LegoCheckedException(2117645L);
        }
        return mountConfigs;
    }
}

