/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService;
import com.huawei.ism.drm.drp.util.RecoveryServiceExtendUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceRemoteUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService", desc="", interfaceClass=IRecoveryPlanSyncService.class)
public class RecoveryPlanSyncServiceImpl
extends DrmBaseService
implements IRecoveryPlanSyncService {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanSyncServiceImpl.class);
    private static final Object RECOVERY_PLAN_LOCK = new Object();
    private IBizScopeManager bizScopeManager;

    public IBizScopeManager getBizScopeManager() {
        return this.bizScopeManager;
    }

    public void setBizScopeManager(IBizScopeManager bizScopeManager) {
        this.bizScopeManager = bizScopeManager;
    }

    public void syncGlobalSettingsToRemote(Site remoteSite, String planId, Map<String, Object> globalSettings) {
        HashMap<String, Object> requestInfos = new HashMap<String, Object>();
        requestInfos.put("planId", planId);
        requestInfos.put("settings", globalSettings);
        logger.debug((Object)"planId: %s.", new Object[]{planId});
        RecoveryServiceRemoteUtil.syncCrdOperationToRemote(remoteSite, requestInfos, "/ws/recoveryplans/syncGlobalSettings");
    }

    public void syncRecoverySettingsToRemote(Site remoteSite, String planId, List<RecoverySetting> settings) {
        HashSet<RecoverySetting> cloneSettings = new HashSet<RecoverySetting>();
        try {
            for (RecoverySetting setting : settings) {
                cloneSettings.add((RecoverySetting)setting.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (cloneSettings.isEmpty()) {
            return;
        }
        IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = recoveryPlanBaseService.getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{planId, 90160758784001L});
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessBaseProvider procProvider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        recoveryPlan.setRecoverySettings(cloneSettings);
        procProvider.decryptPropreties(recoveryPlan);
        HashMap<String, Object> requestInfos = new HashMap<String, Object>();
        requestInfos.put("planId", planId);
        requestInfos.put("settings", new ArrayList(cloneSettings));
        RecoveryServiceRemoteUtil.syncCrdOperationToRemote(remoteSite, requestInfos, "/ws/recoveryplans/syncRecoverySettings");
    }

    public void syncRecoverySettingsToRemote(RecoveryPlan recoveryPlan, String planId, List<RecoverySetting> settings) {
        if (recoveryPlan == null || VerifyUtil.isEmpty(settings)) {
            return;
        }
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            return;
        }
        Iterator<Site> iterator = remoteSites.iterator();
        if (iterator.hasNext()) {
            try {
                this.syncRecoverySettingsToRemote(iterator.next(), planId, settings);
            }
            catch (Exception e) {
                logger.error((Object)"Sync recovery settings to remote failed. PlanId:%s.", new Object[]{planId, 90160758784001L});
            }
        }
    }

    public void syncRecoverySettingsToRemote(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.error((Object)"The recoveryPlan is null.");
            return;
        }
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            logger.error((Object)"The remoteSites is empty.");
            return;
        }
        Iterator<Site> iterator = remoteSites.iterator();
        if (iterator.hasNext()) {
            try {
                this.syncRecoverySettingsToRemote(iterator.next(), recoveryPlan.getPlanId(), settings);
            }
            catch (Exception e) {
                logger.error((Object)"Sync recovery settings to remote failed. PlanId:%s.", new Object[]{recoveryPlan.getPlanId()});
            }
        }
    }

    public void syncSaveOrUpdateRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (!RecoveryServiceUtil.checkRecoverySettings((String)planId, settings)) {
            throw new LegoCheckedException(-1L);
        }
        IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = recoveryPlanBaseService.getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{planId, 90160758784001L});
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessBaseProvider procProvider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        RecoveryPlan tempPlan = new RecoveryPlan();
        tempPlan.setRecoverySettings(new HashSet<RecoverySetting>(settings));
        if (procProvider == null) {
            logger.error((Object)"procProvider is null!");
            throw new LegoCheckedException(1073947393L);
        }
        procProvider.encryptProperties(tempPlan);
        recoveryPlanBaseService.saveOrUpdateRecoverySettings(recoveryPlan, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCreateRecoveryPlan(long userId, RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
            recoveryPlanBaseService.createRecoveryPlan(userId, recoveryPlan, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncModifyRecoveryPlan(RecoveryPlan recoveryPlan) {
        IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan localInfo = recoveryPlanBaseService.getRecoveryPlan(recoveryPlan.getPlanId());
        if (localInfo == null) {
            logger.debug((Object)"localInfo null,not syncModifyRecoveryPlan");
            return;
        }
        localInfo.setDescription(recoveryPlan.getDescription());
        localInfo.setName(recoveryPlan.getName());
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)localInfo);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession((Session)session);
            ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUpdateRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap) {
        IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan localInfo = recoveryPlanBaseService.getRecoveryPlan(recoveryPlan.getPlanId());
        if (localInfo == null) {
            return;
        }
        localInfo.setLastExecuteType(recoveryPlan.getLastExecuteType());
        localInfo.setPlanStatus(recoveryPlan.getPlanStatus());
        localInfo.setProcessStatus(recoveryPlan.getProcessStatus());
        localInfo.setPlanProgress(recoveryPlan.getPlanProgress());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == localInfo.getLastExecuteType()) {
            localInfo.setLastTestStatus(recoveryPlan.getLastTestStatus());
            String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            localInfo.getGlobalSettings().put(disasterSiteId + "_TestResult", String.valueOf(recoveryPlan.getPlanStatus()));
            String hostOrGroupId = RecoveryServiceUtil.getDisasterHostSN((RecoveryPlan)recoveryPlan);
            if (!VerifyUtil.isEmpty((String)hostOrGroupId)) {
                localInfo.getGlobalSettings().put(hostOrGroupId + "_TestResult", String.valueOf(recoveryPlan.getPlanStatus()));
            }
        }
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)localInfo);
            recoveryPlanBaseService.updatePoRecoveryStatus(localInfo.getProtectGroups(), poRecoveryStatusMap, session);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    public void syncRemoveRecoveryPlan(String recoveryPlanId) {
        block3: {
            if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
                logger.error((Object)"Invalid parameter");
                throw new LegoCheckedException(1073947393L);
            }
            try {
                IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
                recoveryPlanBaseService.deleteRecoveryPlan(recoveryPlanId, false);
            }
            catch (LegoCheckedException ex) {
                if (ex.getErrorCode() == 201L || ex.getErrorCode() == 1073947394L) break block3;
                throw ex;
            }
        }
        this.bizScopeManager.deleteScopeObject(recoveryPlanId);
    }

    public void syncRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        if (VerifyUtil.isEmpty(recoveryLogs)) {
            logger.debug((Object)"param is null");
            return;
        }
        IRecoveryPlanBaseService recoveryPlanBaseService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        recoveryPlanBaseService.saveOrUpdateRecoveryLogs(recoveryLogs);
    }

    public void modifyRecoveryPlanFromRemote(RecoveryPlan recoveryPlan) {
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            return;
        }
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType()) {
            recoveryPlan.setRecoveryProcesses(null);
            RecoveryServiceRemoteUtil.syncCrdOperationToRemote(remoteSites, (Object)recoveryPlan, "/ws/recoveryplans/syncModifyRecoveryPlan");
        }
    }

    public void syncDisableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        logger.debug((Object)"The planId is: %s.", new Object[]{planId});
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        recoveryPlanService.updateRecoveryProcessorEnableStatus(planId, procType, procId, false, false);
    }

    public void syncEnableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        logger.debug((Object)"The planId is: %s.", new Object[]{planId});
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        recoveryPlanService.updateRecoveryProcessorEnableStatus(planId, procType, procId, true, false);
    }

    public void createRecoveryPlanFromRemote(RecoveryPlan recoveryPlan, boolean isNeedSyncCreate) {
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (isNeedSyncCreate && DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType() && !VerifyUtil.isEmpty(remoteSites)) {
            this.createRecoveryPlanFromRemote(recoveryPlan, remoteSites);
        }
    }

    private void createRecoveryPlanFromRemote(RecoveryPlan recoveryPlan, List<Site> remoteSites) {
        Iterator<Site> iterator = remoteSites.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        Site remoteSite = iterator.next();
        try {
            RestClient client = SiteUtil.initClient((Site)remoteSite);
            client.postSerializableObj((Object)recoveryPlan, "/ws/recoveryplans/syncCreateRecoveryPlan");
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Sync create rp failed. Name:%s,error :%s.", new Object[]{recoveryPlan.getName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            if (ex.getErrorCode() == 1073948686L) {
                ex = this.reDefineHostNotExistException(recoveryPlan, remoteSite, ex);
            }
            throw ex;
        }
    }

    private LegoCheckedException reDefineHostNotExistException(RecoveryPlan recoveryPlan, Site remoteSite, LegoCheckedException ex) {
        if (remoteSite.getSiteId().equals(RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan))) {
            Site disasterSite = this.getLocalDisasterSites(recoveryPlan).get(0);
            if (VerifyUtil.isEmpty((Object[])ex.getParameters())) {
                return ex;
            }
            DrResource hostOrGroup = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(ex.getParameters()[0]);
            String hostOrGroupName = ex.getParameters()[0];
            if (hostOrGroup != null) {
                hostOrGroupName = hostOrGroup.getName();
            }
            String[] expParams = new String[]{hostOrGroupName, remoteSite.getName(), disasterSite.getName()};
            return new LegoCheckedException(1073948728L, expParams);
        }
        return ex;
    }

    private List<Site> getLocalDisasterSites(RecoveryPlan recoveryPlan) {
        ArrayList<Site> disasterSites = new ArrayList<Site>();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Set disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds((RecoveryPlan)recoveryPlan);
        List localSites = siteService.getAllLocalSites();
        for (Site localSite : localSites) {
            if (!disasterSiteIds.contains(localSite.getSiteId())) continue;
            disasterSites.add(localSite);
        }
        return disasterSites;
    }

    public void removeRemoteRecoveryPlan(RecoveryPlan recoveryPlan) {
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            logger.warn((Object)"The remote sites is empty. planId:%s.", new Object[]{recoveryPlan.getPlanId(), 90160758784000L});
            return;
        }
        for (Site remoteSite : remoteSites) {
            RecoveryServiceRemoteUtil.syncCrdOperationToRemote(remoteSite, (Object)recoveryPlan.getPlanId(), "/ws/recoveryplans/syncRemoveRecoveryPlan/");
        }
    }

    protected Session getHibernateSession() {
        HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
        return template.getSessionFactory().openSession();
    }
}

