/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanServiceImpl;
import com.huawei.ism.drm.drp.service.impl.RecoveryProcessBaseServiceImpl;
import com.huawei.ism.drm.drp.synchronize.RecoveryLogSynchronizerJob;
import com.huawei.ism.drm.drp.util.RecoveryServiceExtendUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceRemoteUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class RecoveryProcessServiceImpl
extends RecoveryProcessBaseServiceImpl
implements IRecoveryProcessService {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessServiceImpl.class);
    private IRecoveryPlanSyncService recoveryPlanSyncService;

    public IRecoveryPlanSyncService getRecoveryPlanSyncService() {
        return this.recoveryPlanSyncService;
    }

    public void setRecoveryPlanSyncService(IRecoveryPlanSyncService recoveryPlanSyncService) {
        this.recoveryPlanSyncService = recoveryPlanSyncService;
    }

    public void initialize() {
        List recoveryPlans = this.recoveryPlanService.getAllRecoveryPlan();
        if (VerifyUtil.isEmpty((Collection)recoveryPlans)) {
            return;
        }
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            Integer status;
            DrmEnumDefine.RecoveryPlanStatusE curPlanStatus = DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus());
            this.changePlanStatusToFailed(recoveryPlan, curPlanStatus);
            if (recoveryPlan.getUse() != null && recoveryPlan.getUse().intValue() == RecoveryPlanUse.INTERNAL_USE.getValue() && (status = (Integer)statusMapping.get(recoveryPlan.getPlanStatus())) != null) {
                recoveryPlan.setPlanStatus(status.intValue());
            }
            this.updateRecoveryPlan(recoveryPlan);
            RecoveryLog recoveryLog = this.recoveryPlanService.getLatestRecoveryLog(recoveryPlan.getPlanId());
            if (recoveryLog != null && !this.bothArePaused(recoveryPlan, recoveryLog)) {
                logger.info((Object)"Set RecoveryLog Failed planId:%s, planStatus:%s, logId:%s, change before logStatus:%s", new Object[]{recoveryPlan.getPlanId(), recoveryPlan.getPlanStatus(), recoveryLog.getLogId(), recoveryLog.getLogStatus()});
                if (recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue()) {
                    recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue());
                    this.updateRecoveryPlan(recoveryPlan);
                }
                this.updateRecoveryLog(recoveryLog.getLogId(), DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue(), String.valueOf(new Date().getTime()));
                this.synchronizedDelVmRecoveryProcessDetailFailed(recoveryLog.getLogId());
            }
            this.updateRecoveryProcessDetail();
        }
        try {
            this.quartzScheduler = StdSchedulerFactory.getDefaultScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"start quartz failed", (Throwable)e, 90160758784001L);
            return;
        }
        this.scheduleLogSyncJob();
    }

    private void scheduleLogSyncJob() {
        String logSyncInterval = ResourceUtil.getValue((String)"logSyncInterval", (String)"5");
        int syncInterval = 300000;
        try {
            syncInterval = Integer.parseInt(logSyncInterval) * 60 * 1000;
        }
        catch (Exception e) {
            logger.error((Object)"Parsing log sync interval failed. Str:%s,error :%s.", new Object[]{logSyncInterval, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        SimpleTriggerImpl logSyncTrigger = new SimpleTriggerImpl("LogSyncTrigger", null, new Date(), null, -1, (long)syncInterval);
        try {
            JobDetailImpl logSyncJobDetail = new JobDetailImpl("JOB_LogSynchronizer", "JOB_GROUP_LogSynchronizer", RecoveryLogSynchronizerJob.class);
            logSyncJobDetail.setDurability(true);
            this.quartzScheduler.scheduleJob((JobDetail)logSyncJobDetail, (Trigger)logSyncTrigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Schedule log sync job failed", (Throwable)e, 90160758784001L);
        }
    }

    private void changePlanStatusToFailed(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanStatusE curPlanStatus) {
        Integer targetStatus = curPlanStatus.getFailStatusWhenRunning();
        if (targetStatus != null) {
            logger.info((Object)"Set RecoveryPlan Failed planId:%s, change before status:%s, change after status:%s", new Object[]{recoveryPlan.getPlanId(), recoveryPlan.getPlanStatus(), targetStatus});
            recoveryPlan.setPlanStatus(targetStatus.intValue());
        }
    }

    private boolean bothArePaused(RecoveryPlan recoveryPlan, RecoveryLog recoveryLog) {
        return recoveryLog.getLogStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue() && recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue();
    }

    private void synchronizedDelVmRecoveryProcessDetailFailed(String recoveryLog) {
        Optional<RecoveryProcessorDetail> recoveryProcessDetail = this.getDelVmRecoveryProcessDetailByLogId(recoveryLog);
        recoveryProcessDetail.ifPresent(detail -> {
            logger.info((Object)"Set RecoveryProcessDetail Failed, detailId:%s", new Object[]{detail.getDetailId()});
            detail.setProcessDetail("lego.err.1073947452");
            detail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.RUNNING.getValue());
            this.updateRecoveryProcessDetail((RecoveryProcessorDetail)detail);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<RecoveryProcessorDetail> getDelVmRecoveryProcessDetailByLogId(String recoveryLogId) {
        Session session;
        RecoveryProcessorDetail detail;
        block5: {
            if (VerifyUtil.isEmpty((String)recoveryLogId)) {
                logger.error((Object)"The parameter recoveryLogId is null.");
                return Optional.empty();
            }
            detail = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHql = "FROM RecoveryProcessorDetail where logId=:logId and PROCESSSTATUS=:processStatus";
                Query query = session.createQuery(queryHql);
                query.setParameter("logId", (Object)recoveryLogId);
                query.setParameter("processStatus", (Object)DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue());
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || results.size() != 1) break block5;
                detail = (RecoveryProcessorDetail)results.get(0);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)String.format(Locale.ROOT, "Getting delVm recovery process detail failed. LogId:%s,errorMessage: %s", recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)ex)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return Optional.ofNullable(detail);
    }

    public void syncRecoveryLog(String planId, String recoveryLogId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)recoveryLogId)) {
            logger.error((Object)"Parameter planId or recoveryLogId is invalid.");
            return;
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            logger.error((Object)"RP does not exist. Id:%s.", new Object[]{planId});
            return;
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() != recoveryPlan.getPlanType()) {
            return;
        }
        RecoveryLog recoveryLog = this.recoveryPlanService.getRecoveryLog(recoveryLogId);
        if (recoveryLog != null) {
            RecoveryPlanServiceImpl rpServiceImpl = (RecoveryPlanServiceImpl)this.recoveryPlanService;
            List details = rpServiceImpl.getDetailsByLogId(recoveryLogId);
            HashSet<RecoveryProcessorDetail> rpDetails = new HashSet<RecoveryProcessorDetail>();
            for (RecoveryProcessorDetail detail : details) {
                rpDetails.add(detail);
            }
            recoveryLog.setRecoveryProcessDetails(rpDetails);
            ArrayList<RecoveryLog> recoveryLogs = new ArrayList<RecoveryLog>();
            recoveryLogs.add(recoveryLog);
            List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
            this.syncRecoveryLogsToRemote(recoveryLogs, remoteSites);
            rpServiceImpl.saveOrUpdateRecoveryLogs(recoveryLogs);
        }
    }

    private void syncRecoveryLogsToRemote(List<RecoveryLog> recoveryLogs, List<Site> remoteSites) {
        if (VerifyUtil.isEmpty(remoteSites)) {
            return;
        }
        for (Site remoteSite : remoteSites) {
            RestClient client = SiteUtil.initClient((Site)remoteSite);
            client.postSerializableObj(recoveryLogs, "/ws/recoveryplans/syncRecoveryLogs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoveryLog> getUnsynchronizedRecoveryLogs() {
        Session session;
        ArrayList<RecoveryLog> unSyncRecoveryLogs;
        block5: {
            unSyncRecoveryLogs = new ArrayList<RecoveryLog>();
            session = null;
            try {
                HibernateTemplate template = this.getMoDao().getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                String querySql = "select LOGID,PLANID from ti_recoverylog where ENDTIME is not null and ISSYNCHRONIZED=0 order by STARTTIME DESC";
                NativeQuery query = session.createSQLQuery(querySql);
                List logs = query.list();
                if (VerifyUtil.isEmpty((Collection)logs)) break block5;
                for (Object obj : logs) {
                    Object[] objArray = (Object[])obj;
                    if (objArray == null || objArray.length < 2) continue;
                    RecoveryLog recoveryLog = new RecoveryLog();
                    recoveryLog.setLogId(String.valueOf(objArray[0]));
                    recoveryLog.setPlanId(String.valueOf(objArray[1]));
                    unSyncRecoveryLogs.add(recoveryLog);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"GetUnsynchronizedRecoveryLogs failed,error Is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return unSyncRecoveryLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryLog queryRecoveryLog(RecoveryLog recoveryLog) {
        RecoveryLog log;
        Session session;
        block4: {
            session = null;
            log = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                Query query = session.createQuery("FROM RecoveryLog log WHERE log.logStatus=? AND log.planId=? AND log.recoverySiteId=? AND log.productionSiteId=? AND log.logType=?", RecoveryLog.class);
                query.setParameter(0, (Object)recoveryLog.getLogStatus());
                query.setParameter(1, (Object)recoveryLog.getPlanId());
                query.setParameter(2, (Object)recoveryLog.getRecoverySiteId());
                query.setParameter(3, (Object)recoveryLog.getProductionSiteId());
                query.setParameter(4, (Object)recoveryLog.getLogType());
                List list = query.list();
                logger.info((Object)"Query RecoveryLog[planId:%s] records size is %s.", new Object[]{recoveryLog.getPlanId(), list.size()});
                if (list.size() != 1) break block4;
                log = (RecoveryLog)list.get(0);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"Query RecoveryLog[planId:%s] log failed:%s .", new Object[]{recoveryLog.getPlanId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRecoveryLog(RecoveryLog recoveryLog) {
        if (recoveryLog == null) {
            logger.error((Object)"The parameter is null.");
            return null;
        }
        String recoveryLogId = null;
        Session session = null;
        try {
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            recoveryLog.setLogId(UUIDGenerator.getUUID());
            session.beginTransaction();
            session.save((Object)recoveryLog);
            this.createRecoveryProcessDetails(recoveryLog.getPlanId(), recoveryLog.getLogId(), recoveryLog.getLogType(), session);
            session.getTransaction().commit();
            recoveryLogId = recoveryLog.getLogId();
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Creating recovery log failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return recoveryLogId;
    }

    private void createRecoveryProcessDetails(String planId, String logId, int procType, Session session) {
        RecoveryPlanServiceImpl planServiceImpl = (RecoveryPlanServiceImpl)this.recoveryPlanService;
        Set processes = planServiceImpl.getRecoveryProcesses(planId, procType);
        if (VerifyUtil.isEmpty((Collection)processes)) {
            logger.error((Object)"The processes is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = processes.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        Set processors = ((RecoveryProcessDefinition)iterator.next()).getRecoveryProcessors();
        List sortedProcesses = RecoveryServiceUtil.sortRecoveryProcessors((Set)processors);
        for (RecoveryProcessor process : sortedProcesses) {
            if (!process.getIsEnabled().booleanValue()) continue;
            process.updateProcessName();
            RecoveryProcessorDetail newDetail = new RecoveryProcessorDetail();
            newDetail.setDetailId(UUIDGenerator.getUUID());
            newDetail.setProcessName(process.getProcName());
            newDetail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            newDetail.setProcId(process.getProcId());
            newDetail.setLogId(logId);
            RecoveryProcessor preProcessor = RecoveryProcessUtil.getValidPreviousProcessor((RecoveryProcessor)process);
            RecoveryProcessor nextProcessor = RecoveryProcessUtil.getValidNextProcessor((RecoveryProcessor)process);
            String previousProcId = preProcessor != null ? preProcessor.getProcId() : null;
            String nextProcId = nextProcessor != null ? nextProcessor.getProcId() : null;
            newDetail.setPreviousProcId(previousProcId);
            newDetail.setNextProcId(nextProcId);
            session.save((Object)newDetail);
        }
    }

    public ProtectGroupReplica getProtectGroupReplicaBySiteId(ProtectGroup protectGroup, String disasterSiteId) {
        if (protectGroup == null || VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList()) || VerifyUtil.isEmpty((String)disasterSiteId)) {
            logger.error((Object)"Invalid parameters.");
            return null;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            List siteInfoList;
            Set siteIdSet;
            String siteInfoListStr;
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)pgReplica)) continue;
            if (pgReplica.getRecoverySite().equals(disasterSiteId)) {
                return pgReplica;
            }
            if (20 == protectGroup.getTemplate().getType() || 24 == protectGroup.getTemplate().getType() || 27 == protectGroup.getTemplate().getType() || 32 == protectGroup.getTemplate().getType()) {
                return pgReplica;
            }
            if (35 != protectGroup.getTemplate().getType() && 36 != protectGroup.getTemplate().getType() || null == (siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO")) || null == (siteIdSet = (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).stream().filter(siteInfo -> siteInfo.getSiteIdSet().contains(disasterSiteId)).findFirst().get().getSiteIdSet()) || !siteIdSet.contains(pgReplica.getRecoverySite())) continue;
            return pgReplica;
        }
        return null;
    }

    public ProtectGroupReplica getProtectGroupReplicaByReplicaId(ProtectGroup protectGroup, String replicaId) {
        if (protectGroup == null || VerifyUtil.isEmpty((String)replicaId)) {
            return null;
        }
        ProtectGroupReplica replica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
        if (replica != null) {
            return replica;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        if (pgReplicas == null) {
            return null;
        }
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (!pgReplica.getId().equals(replicaId)) continue;
            return pgReplica;
        }
        return null;
    }

    protected void syncUpdateToRemote(Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap, RecoveryPlan recoveryPlan) {
        List<Site> remoteSites = RecoveryServiceExtendUtil.getRemoteSites(recoveryPlan);
        if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType() && !VerifyUtil.isEmpty(remoteSites)) {
            HashMap<String, Object> requestObj = new HashMap<String, Object>();
            requestObj.put("plan", recoveryPlan);
            requestObj.put("poRecoveryStatusMap", poRecoveryStatusMap);
            try {
                Iterator<Site> iterator = remoteSites.iterator();
                if (!iterator.hasNext()) {
                    throw new LegoCheckedException(1073947393L);
                }
                Site site = iterator.next();
                RecoveryServiceRemoteUtil.syncCrdOperationToRemote(site, requestObj, "/ws/recoveryplans/syncUpdateRecoveryPlan");
                if (DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
                    this.recoveryPlanSyncService.syncGlobalSettingsToRemote(site, recoveryPlan.getPlanId(), RecoveryProcessUtil.convertSettingType((Map)recoveryPlan.getGlobalSettings()));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Sync update plan failed. Id:%s,error is %s.", new Object[]{recoveryPlan.getPlanId(), ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            }
        }
    }
}

