/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.drp.service.impl.RecoveryResourceBaseServiceImpl;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class RecoveryResourceServiceImpl
extends RecoveryResourceBaseServiceImpl
implements IRecoveryResourceService {
    private static final Log logger = LogFactory.getInstance(RecoveryResourceServiceImpl.class);
    private AbstractReplicationService abstractReplicationService;

    public AbstractReplicationService getAbstractReplicationService() {
        return this.abstractReplicationService;
    }

    public void setAbstractReplicationService(AbstractReplicationService abstractReplicationService) {
        this.abstractReplicationService = abstractReplicationService;
    }

    public Lun getTargetLunByPair(String replicationPairId, String srcDeviceId, String tgtDeviceId) {
        if (replicationPairId == null || srcDeviceId == null || tgtDeviceId == null) {
            return null;
        }
        ReplicationTargetLun targetLun = this.abstractReplicationService.getTargetLun(tgtDeviceId, replicationPairId, srcDeviceId);
        if (null == targetLun) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", tgtDeviceId);
        props.put("lunId", targetLun.getTgtLunId());
        List luns = this.moDao.findMoBy(Lun.class, props);
        Lun lun = null;
        if (null != luns && !luns.isEmpty()) {
            lun = (Lun)luns.get(0);
        }
        return lun;
    }

    public Lun getTargetLunById(String tgtDeviceId, String lunId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", tgtDeviceId);
        props.put("lunId", lunId);
        List groups = this.moDao.findMoBy(Lun.class, props);
        if (groups == null || groups.isEmpty() || groups.size() != 1) {
            return null;
        }
        return (Lun)groups.get(0);
    }

    public Host getHostByUuid(String hostUuid) {
        ManagedObject mObject = this.moDao.getMoByUuid(hostUuid, Boolean.valueOf(true));
        Host host = null;
        if (mObject != null && mObject instanceof Host) {
            host = (Host)mObject;
        }
        return host;
    }

    public String getStorageType(String deviceId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        List storageUnits = this.moDao.findMoBy(StorageUnit.class, props);
        if (storageUnits == null || storageUnits.isEmpty()) {
            return null;
        }
        String storageType = ((StorageUnit)storageUnits.iterator().next()).getClass().getName();
        return storageType;
    }

    public ReplicationRelation queryReplication(String deviceSn, String replicationId, boolean isConsistentGroup) {
        return this.abstractReplicationService.queryReplication(deviceSn, replicationId, isConsistentGroup);
    }

    public ReplicationRelation queryReplication(String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        Site srcDevSite = this.getStorageRegisteredSite(srcDeviceId);
        Site tgtDevSite = this.getStorageRegisteredSite(tgtDeviceId);
        if (1 == srcDevSite.getSiteType() && 1 == tgtDevSite.getSiteType()) {
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("isConsistentGroup", String.valueOf(isConsistentGroup));
            request.put("srcDeviceId", srcDeviceId);
            request.put("tgtDeviceId", tgtDeviceId);
            request.put("replicationId", replicationId);
            RestClient client = SiteUtil.initClient((Site)tgtDevSite);
            String url = "/ws/replications/getReplication";
            ReplicationRelation replication = (ReplicationRelation)client.postSerializableObj(request, url, ReplicationRelation.class);
            return replication;
        }
        ReplicationRelation replication = this.queryReplication(srcDeviceId, replicationId, isConsistentGroup);
        if (replication == null) {
            replication = this.queryReplication(tgtDeviceId, replicationId, isConsistentGroup);
        }
        return replication;
    }

    public ReplicationRelation queryReplication(Site site, String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        ReplicationRelation replication = null;
        if (site == null) {
            logger.error((Object)"The site is null");
            site = this.getStorageRegisteredSite(srcDeviceId);
        }
        if (site.getSiteType() == 1) {
            RestClient client = SiteUtil.initClient((Site)site);
            String url = "/ws/replications/getReplication";
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("isConsistentGroup", String.valueOf(isConsistentGroup));
            request.put("srcDeviceId", srcDeviceId);
            request.put("tgtDeviceId", tgtDeviceId);
            request.put("replicationId", replicationId);
            try {
                replication = (ReplicationRelation)client.postSerializableObj(request, url, ReplicationRelation.class);
            }
            catch (Exception e) {
                logger.error((Object)("query ReplicationRelation failed, srcDeviceId:" + srcDeviceId + ",tgtDeviceId:" + tgtDeviceId + ",replicationId:" + replicationId + "isCon:" + isConsistentGroup + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            return replication;
        }
        replication = this.queryReplication(srcDeviceId, replicationId, isConsistentGroup);
        if (replication == null) {
            replication = this.queryReplication(tgtDeviceId, replicationId, isConsistentGroup);
        }
        return replication;
    }

    public List<DrHost> getDrHostsByDrHostOrGroupId(String drHostOrGroupId) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(drHostOrGroupId);
        ArrayList<DrHost> drHosts = new ArrayList<DrHost>();
        if (drResource instanceof DrHostGroup) {
            for (DrResource drHost : drResource.getChildResources()) {
                drHosts.add((DrHost)drHost);
            }
        } else if (drResource instanceof DrHost) {
            drHosts.add((DrHost)drResource);
        }
        return drHosts;
    }

    public List<DatabaseInstance> getDatabaseInstancesByHostSN(String hostSn) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hostSN", hostSn);
        return this.moDao.findMoBy(DatabaseInstance.class, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatabaseInstance> getDatabaseInstancesByDbName(String dbName, int dbType) {
        Session session;
        List<DatabaseInstance> matcheddbInstances;
        block4: {
            matcheddbInstances = new ArrayList<DatabaseInstance>();
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("select distinct dbInst.HOSTSN, dbInst.instanceName ");
            strBuilder.append("from ti_DatabaseInstance dbInst, ");
            strBuilder.append("(select db.name, mo.parent_id ");
            strBuilder.append("from ti_Database db, T_managedobject mo ");
            strBuilder.append("where db.MOID = mo.moid and db.name=:dbName) dbtemp ");
            strBuilder.append("where dbInst.moId=dbtemp.parent_id and dbInst.dbType=:dbType");
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery query = session.createSQLQuery(strBuilder.toString());
                query.setString("dbName", dbName);
                query.setInteger("dbType", dbType);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                matcheddbInstances = this.constructDatabaseInstances(results);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting database instances by db name failed. DBName:" + dbName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return matcheddbInstances;
    }

    private List<DatabaseInstance> constructDatabaseInstances(List<?> results) {
        ArrayList<DatabaseInstance> matchedDbInstances = new ArrayList<DatabaseInstance>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
            DatabaseInstance dbInstance = new DatabaseInstance();
            dbInstance.setHostSN(String.valueOf(values[0]));
            dbInstance.setInstanceName(String.valueOf(values[1]));
            matchedDbInstances.add(dbInstance);
        }
        return matchedDbInstances;
    }

    public VstoreReplicationPair queryVstoreReplicationPair(String srcDeviceId, String tgtDeviceId, String replicationId) {
        VstoreReplicationPair vstoreReplicationPair = this.queryVstoreReplicationPair(srcDeviceId, replicationId);
        if (vstoreReplicationPair == null) {
            vstoreReplicationPair = this.queryVstoreReplicationPair(tgtDeviceId, replicationId);
        }
        return vstoreReplicationPair;
    }

    private VstoreReplicationPair queryVstoreReplicationPair(String deviceSn, String replicationId) {
        if (deviceSn == null || null == replicationId) {
            logger.error((Object)("Parameter is invalid. DeviceId:" + deviceSn + ",RepId:" + replicationId), 90160758784001L);
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("remoteDeviceSn", deviceSn);
        props.put("vstorePairId", replicationId);
        List groups = this.moDao.findMoBy(VstoreReplicationPair.class, props);
        if (null != groups && groups.size() == 1) {
            return (VstoreReplicationPair)groups.get(0);
        }
        logger.error((Object)("The replication does not exist. DeviceId:" + deviceSn + ",RepId:" + replicationId), 90160758784001L);
        return null;
    }
}

