/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.synchronize;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class RecoveryLogSynchronizer {
    private static Log logger = LogFactory.getInstance(RecoveryLogSynchronizer.class);
    private static RecoveryLogSynchronizer synchronizer = new RecoveryLogSynchronizer();
    private ConcurrentHashMap<String, ReentrantLock> syncLogLocks = new ConcurrentHashMap();
    private Object logSyncLock = new Object();

    private RecoveryLogSynchronizer() {
    }

    public static RecoveryLogSynchronizer getInstance() {
        return synchronizer;
    }

    public void syncRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        if (recoveryLogs == null) {
            logger.debug((Object)"recoveryLogs is null,not need syncRecoveryLogs.");
            return;
        }
        for (RecoveryLog recoveryLog : recoveryLogs) {
            String planId = recoveryLog.getPlanId();
            String logId = recoveryLog.getLogId();
            this.syncRecoveryLog(planId, logId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRecoveryLog(String planId, String logId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)logId)) {
            logger.warn((Object)"Invalid parameters", 90160758784000L);
            return;
        }
        if (!this.tryLockRecoveryLog(planId, logId)) {
            logger.warn((Object)"The log is synchronizing. PlanId:%s,LogId:%s", new Object[]{planId, logId});
            return;
        }
        try {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.syncRecoveryLog(planId, logId);
        }
        catch (Exception e) {
            logger.error((Object)("Sync recovery log failed. PlanId:" + planId + ",LogId:" + logId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            this.unLockRecoveryLog(planId, logId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockRecoveryLog(String planId, String logId) {
        Object object = this.logSyncLock;
        synchronized (object) {
            String key = planId + ":" + logId;
            ReentrantLock lock = this.syncLogLocks.get(key);
            if (null == lock) {
                lock = new ReentrantLock();
                this.syncLogLocks.put(key, lock);
            }
            return lock.tryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLockRecoveryLog(String planId, String logId) {
        Object object = this.logSyncLock;
        synchronized (object) {
            String key = planId + ":" + logId;
            ReentrantLock lock = this.syncLogLocks.get(key);
            if (null != lock) {
                lock.unlock();
                this.syncLogLocks.remove(key);
            }
        }
    }
}

