/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.synchronize;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.synchronize.RecoveryLogSynchronizer;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class RecoveryLogSynchronizerJob
implements StatefulJob {
    private static final Log logger = LogFactory.getInstance(RecoveryLogSynchronizerJob.class);
    private RecoveryLogSynchronizer logSynchronizer = RecoveryLogSynchronizer.getInstance();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            if (rpService == null) {
                logger.warn((Object)"The recovery process service is null.");
                return;
            }
            List recoveryLogs = rpService.getUnsynchronizedRecoveryLogs();
            if (VerifyUtil.isEmpty((Collection)recoveryLogs)) {
                return;
            }
            this.logSynchronizer.syncRecoveryLogs(recoveryLogs);
        }
        catch (Exception e) {
            logger.error((Object)"Executing recovery log sync failed,error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

