/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.util;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RecoveryServiceExtendUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryServiceUtil.class);

    private RecoveryServiceExtendUtil() {
    }

    public static List<Site> getRemoteSites(RecoveryPlan recoveryPlan) {
        ArrayList<Site> remoteSites = new ArrayList<Site>();
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Set disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds((RecoveryPlan)recoveryPlan);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (disasterSite == null || disasterSite.getSiteType() == 0) continue;
            remoteSites.add(disasterSite);
            return remoteSites;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
        logger.debug((Object)"productSiteId= %s.", new Object[]{productSiteId});
        Site productSite = siteService.getSiteById(productSiteId);
        if (productSite != null && productSite.getSiteType() != 0) {
            remoteSites.add(productSite);
            return remoteSites;
        }
        return remoteSites;
    }

    public static List<Site> getRemoteSites(ProtectGroup protectGroup) {
        ArrayList<Site> remoteSites = new ArrayList<Site>();
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Set disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds((ProtectGroup)protectGroup);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (disasterSite == null || disasterSite.getSiteType() == 0) continue;
            remoteSites.add(disasterSite);
            return remoteSites;
        }
        String productSiteId = protectGroup.getProductSiteId();
        logger.debug((Object)"productSiteId=%s.", new Object[]{productSiteId});
        Site productSite = siteService.getSiteById(productSiteId);
        if (productSite != null && productSite.getSiteType() != 0) {
            remoteSites.add(productSite);
            return remoteSites;
        }
        return remoteSites;
    }

    public static Site getRemoteSiteByDevSn(String srcDeviceSn, String tgtDeviceSn) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        logger.debug((Object)"Method getRemoteSiteByDevSn ,srcDeviceSn=%s,tgtDeviceSn=%s.", new Object[]{srcDeviceSn, tgtDeviceSn});
        Site srcDevSite = recoveryService.getStorageRegisteredSite(srcDeviceSn);
        Site tgtDevSite = recoveryService.getStorageRegisteredSite(tgtDeviceSn);
        Site remoteSite = null;
        if (srcDevSite.getSiteType() == 1) {
            remoteSite = srcDevSite;
        } else if (srcDevSite.getSiteType() == 1 && tgtDevSite.getSiteType() == 1) {
            remoteSite = tgtDevSite;
        }
        return remoteSite;
    }

    public static Site getRemoteDisasterSite(RecoveryPlan recoveryPlan) {
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        List localSites = siteService.getAllLocalSites();
        HashSet disasterSiteIds = new HashSet(RecoveryServiceUtil.getDisasterSiteIds((RecoveryPlan)recoveryPlan));
        if (disasterSiteIds.size() > 1) {
            String curDisasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
                logger.debug((Object)"curDisasterSiteId is null");
                return null;
            }
            if (!RecoveryServiceUtil.isContainSite((List)localSites, (String)curDisasterSiteId)) {
                return siteService.getSiteById(curDisasterSiteId);
            }
        } else if (disasterSiteIds.size() == 1) {
            String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
            Site productSite = siteService.getSiteById(productSiteId);
            Site disasterSite = siteService.getSiteById((String)disasterSiteIds.iterator().next());
            if (localSites.contains(productSite) && !localSites.contains(disasterSite)) {
                return disasterSite;
            }
        }
        return null;
    }
}

