/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.fault;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.dao.DataAccessException;

public final class FaultGeneratorUtil {
    private static final Log logger = LogFactory.getInstance(FaultGeneratorUtil.class);

    private FaultGeneratorUtil() {
    }

    public static void generateAlarm(String alarmId, int alarmLevel, String[] alarmParam, FaultEnum.ClearState state) {
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setAlarmLevel(FaultEnum.AlarmSeverity.getSeverity((int)alarmLevel));
        alarm.setAlarmParam(alarmParam);
        Date currentTime = new Date();
        alarm.setAlarmTime(currentTime.getTime());
        alarm.setConfirmTime(0L);
        alarm.setConfirmUser("");
        alarm.setClearStatus(state);
        try {
            if (FaultEnum.ClearState.UNCLEARED == state) {
                FaultGeneratorUtil.generateLegoAlarm(alarm);
            }
        }
        catch (Exception e) {
            logger.error((Object)"generate alarm exception,error Is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758786881L});
        }
    }

    public static void generateAlarm(LegoAlarm alarm) {
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateAlarm(alarm);
    }

    public static void generateRestoreAlarm(Alarm alarm) {
        Date currentTime = new Date();
        alarm.setClearTime(currentTime.getTime());
        alarm.setClearStatus(FaultEnum.ClearState.CLEARED.getValue());
        alarm.setClearUser("system");
        String fmt = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)alarm);
        }
        catch (DataAccessException ex) {
            logger.error((Object)("failed to generate an restore alarm:" + alarm.getEntity() + ",time:" + sdf.format(currentTime)), (Throwable)ex, 90160758786881L);
            return;
        }
    }

    public static void generateRestoreAlarm(LegoAlarm alarm) {
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateRestoreAlarm(alarm);
    }

    public static void generateLegoAlarm(LegoAlarm alarm) {
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateLegoAlarm(alarm);
    }
}

