/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.license.AbstractLicManSdp;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.license.sdk.ILicenseUseInter;
import com.huawei.ism.drm.license.sdk.LicenseCalcBean;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Service(name="ILicenseInter", desc="", interfaceClass=ILicenseInter.class)
public class LicManSDPImpl
extends AbstractLicManSdp
implements ILicenseInter {
    private static final Log logger = LogFactory.getInstance(LicManSDPImpl.class);
    private static final int CALC_LICENSE_TIMEOUT = 10000;

    public LicenseCalcBean calcLicenseConsume(List<String> calcServerList, List<String> resTypeList) {
        logger.info((Object)"into calcLicenseConsume", 90160758787071L);
        LicenseCalcBean licenseCalcBean = new LicenseCalcBean();
        try {
            IManagementServerService msSvc = (IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class);
            ManagementServer localServer = msSvc.getServerInfo();
            if (null == localServer) {
                logger.error((Object)"can not find local info");
                throw new LegoCheckedException(0x200909L);
            }
            if (VerifyUtil.isEmpty(resTypeList) || null == calcServerList || calcServerList.contains(localServer.getUuid())) {
                logger.error((Object)"resTypeList is %s,calcServerList:%s, localServer uuid is %s.", new Object[]{resTypeList, calcServerList, localServer.getUuid()});
                return licenseCalcBean;
            }
            boolean haveCloudLicenseRes = ((ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class)).isHaveCloudLicenseRes();
            for (String resType : resTypeList) {
                int consumeCount = 0;
                List serviceList = (List)this.useServiceMap.get(resType);
                if (null == serviceList) continue;
                for (ILicenseUseInter ser : serviceList) {
                    consumeCount += ser.getUseCount();
                }
                if ("LSTQDPMP".equals(resType) && !haveCloudLicenseRes) {
                    consumeCount += this.getCloudConsumeNum();
                }
                licenseCalcBean.getResConsumeMap().put(resType, consumeCount);
            }
            licenseCalcBean.setCalculated(Boolean.valueOf(true));
            ArrayList<String> calcLocalServerList = new ArrayList<String>();
            calcLocalServerList.addAll(calcServerList);
            calcLocalServerList.add(localServer.getUuid());
            licenseCalcBean.setCalculatedSiteIdList(calcLocalServerList);
            List servers = msSvc.getServers();
            for (ManagementServer server : servers) {
                logger.info((Object)"start calc remote site; server type: %s, id: %s", new Object[]{server.getServerType(), server.getUuid()});
                if (0 == server.getServerType() || licenseCalcBean.getCalculatedSiteIdList().contains(server.getUuid())) continue;
                LicenseCalcBean remoteCalcResult = this.getRemoteLicenseConsume(server, licenseCalcBean.getCalculatedSiteIdList(), resTypeList);
                if (remoteCalcResult.getErrorCode() != 0L) {
                    logger.error((Object)"getRemoteLicenseConsume failed.");
                    licenseCalcBean.setErrorCode(-1L);
                    break;
                }
                this.addRemoteToLocal(licenseCalcBean, remoteCalcResult);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getRemoteLicenseConsume failed.", (Throwable)e, 90160758787071L);
            licenseCalcBean.setErrorCode(e.getErrorCode());
            licenseCalcBean.setParameters(e.getParameters());
        }
        catch (Exception e) {
            licenseCalcBean.setErrorCode(-1L);
            logger.error((Object)("getRemoteLicenseConsume failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        logger.info((Object)"out calcLicenseConsume", 90160758787071L);
        return licenseCalcBean;
    }

    private LicenseCalcBean getRemoteLicenseConsume(ManagementServer server, List<String> calcSiteList, List<String> resTypeList) throws UnsupportedEncodingException {
        logger.info((Object)("into getRemoteLicenseConsume serverUuid=" + server.getUuid() + ", name=" + server.getName()), 90160758787071L);
        RestClient client = SiteUtil.initClient((ManagementServer)server);
        JSONArray obj = JSONArray.fromObject(calcSiteList);
        JSONArray resTypeJson = JSONArray.fromObject(resTypeList);
        String url = "/ws/license/calculateConsume?calculatedSiteIds=" + URLEncoder.encode(obj.toString(), "utf-8") + "&resTypes=" + URLEncoder.encode(resTypeJson.toString(), "utf-8");
        client.setTimeout(10000);
        String result = client.get(url, null);
        logger.info((Object)("getRemoteLicenseConsume serverUuid=" + server.getUuid() + ", name=" + server.getName() + " result=" + result), 90160758787071L);
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        LicenseCalcBean bean = this.json2LicenseCalcBean(jsonObject);
        return bean;
    }

    private LicenseCalcBean json2LicenseCalcBean(JSONObject jsonObject) {
        LicenseCalcBean bean = new LicenseCalcBean();
        try {
            bean.setCalculated(Boolean.valueOf(jsonObject.getBoolean("calculated")));
            JSONArray calcSiteArray = jsonObject.getJSONArray("calculatedSiteIdList");
            for (int i = 0; i < calcSiteArray.size(); ++i) {
                bean.getCalculatedSiteIdList().add(calcSiteArray.getString(i));
            }
            JSONObject mapObj = jsonObject.getJSONObject("resConsumeMap");
            Iterator inters = mapObj.keys();
            while (inters.hasNext()) {
                String mapKey = (String)inters.next();
                bean.getResConsumeMap().put(mapKey, mapObj.getInt(mapKey));
            }
        }
        catch (Exception e) {
            logger.error((Object)"json2LicenseCalcBean failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return bean;
    }

    private void addRemoteToLocal(LicenseCalcBean local, LicenseCalcBean remote) {
        if (remote != null && remote.getCalculated().booleanValue()) {
            this.uniteList(remote.getCalculatedSiteIdList(), local.getCalculatedSiteIdList());
            Map resConsumeMap = remote.getResConsumeMap();
            for (Map.Entry item : resConsumeMap.entrySet()) {
                int count = (Integer)item.getValue();
                if (local.getResConsumeMap().containsKey(item.getKey())) {
                    count += ((Integer)local.getResConsumeMap().get(item.getKey())).intValue();
                }
                local.getResConsumeMap().put(item.getKey(), count);
            }
        }
    }

    private void uniteList(List<String> fromList, List<String> toList) {
        if (null == toList) {
            logger.error((Object)"uniteList toList is null", 90160758787071L);
            return;
        }
        if (null == fromList || fromList.isEmpty()) {
            logger.info((Object)"uniteList fromList is null or empty", 90160758787071L);
            return;
        }
        for (String item : fromList) {
            if (toList.contains(item)) continue;
            toList.add(item);
        }
    }
}

