/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.calculator;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.calculator.AbstractBaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.service.IRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public abstract class BaseRecoveryPointObjectiveCalculator
extends AbstractBaseRecoveryPointObjectiveCalculator
implements IRecoveryPointObjectiveCalculator {
    private static final Log logger = LogFactory.getInstance(BaseRecoveryPointObjectiveCalculator.class);

    protected int getStorageStatus(String sn) {
        String status;
        logger.debug((Object)"sn:%s.", new Object[]{sn});
        DrResource drResource = TopoServiceUtil.getDrResource((String)sn);
        if (drResource != null && !VerifyUtil.isEmpty((String)(status = drResource.getStatus()))) {
            return NumberUtil.convertToInteger((Object)status, (int)-3);
        }
        return -3;
    }

    protected Site getSiteByResourceSN(String sn) {
        logger.debug((Object)"sn:%s", new Object[]{sn});
        DrResource drResource = TopoServiceUtil.getDrResource((String)sn);
        if (drResource == null) {
            logger.warn((Object)"drResource is null. sn:%s", new Object[]{sn});
            return null;
        }
        String srcSiteId = drResource.getSiteId();
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(srcSiteId);
        return site;
    }
}

