/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public abstract class AbRateConfigBaseService {
    private static final Log logger = LogFactory.getInstance(AbRateConfigBaseService.class);

    protected List<ReplicationPair> filterValidStatus(List<ReplicationPair> pairList) {
        ArrayList<ReplicationPair> filterPairList = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : pairList) {
            List tgtLuns = pair.getRepTgtLuns();
            if (VerifyUtil.isEmpty((Collection)tgtLuns) || tgtLuns.isEmpty()) continue;
            boolean isReplicationFault = false;
            for (ReplicationTargetLun tgtLun : tgtLuns) {
                int pairStatus = tgtLun.getPairStatus();
                if (XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue() == pairStatus || ReplicationConstantDefine.PairStatus.INVALID.getValue() == pairStatus) {
                    isReplicationFault = true;
                    logger.error((Object)"the targetlun:%s status :%s.", new Object[]{tgtLun.getName(), tgtLun.getPairStatus()});
                    break;
                }
                logger.debug((Object)"the targetlun:%s  status : %s.", new Object[]{tgtLun.getName(), tgtLun.getPairStatus()});
            }
            if (isReplicationFault) continue;
            filterPairList.add(pair);
        }
        return filterPairList;
    }

    protected List<ProtectObjectStorageInfo> getAllStorageInfo(List<ProtectObject> protectObjects) {
        ArrayList<ProtectObjectStorageInfo> allInfo = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                if (allInfo.contains(posi)) continue;
                allInfo.add(posi);
            }
        }
        return allInfo;
    }

    protected Site getSiteByDeviceSN(String deviceSn) {
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            logger.error((Object)"deviceSN is empty!deviceSN:%s.", new Object[]{deviceSn});
            return null;
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(deviceSn, "ism.deviceType.storage.mainType");
        if (drResource != null) {
            return ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        }
        return null;
    }

    protected List<ReplicationPair> queryValidReplicationPairsBy(String devSn, List<String> lunIds, boolean isRealTime) {
        List pairList = null;
        try {
            pairList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryReplicationPairsByMasterLunId(devSn, lunIds, isRealTime);
        }
        catch (Exception e) {
            logger.error((Object)("query replicationpairs error." + devSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            return new ArrayList<ReplicationPair>();
        }
        return pairList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alterAndSaveSpeedLevel(List<ReplicationTargetLun> repTgtLuns, DmEnumDefine.SpeedLevelE speedLevel) {
        if (VerifyUtil.isEmpty(repTgtLuns)) {
            logger.warn((Object)"repTgtLuns is empty. repTgtLuns:%s", new Object[]{repTgtLuns});
            return;
        }
        ArrayList<Long> targetLunList = new ArrayList<Long>();
        for (ReplicationTargetLun targetLun : repTgtLuns) {
            targetLunList.add(targetLun.getMoId());
        }
        if (VerifyUtil.isEmpty(targetLunList)) {
            logger.warn((Object)"targetLunList is empty. ");
            return;
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String strUpdateSQL = "UPDATE ti_replicationtargetlun SET SPEEDLEVEL=? where MOID in (:moids)";
            session.beginTransaction();
            NativeQuery updateQuery = session.createSQLQuery(strUpdateSQL);
            updateQuery.setInteger(0, speedLevel.getValue());
            updateQuery.setParameterList("moids", targetLunList);
            updateQuery.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("update ti_replicationtargetlun speedlevel error" + targetLunList));
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alterAndSaveCGSpeedLevel(List<ReplicationGroup> groups, DmEnumDefine.SpeedLevelE speedLevel) {
        if (VerifyUtil.isEmpty(groups)) {
            return;
        }
        ArrayList<Long> replicationGroupMoIds = new ArrayList<Long>();
        for (ReplicationGroup group : groups) {
            replicationGroupMoIds.add(group.getMoId());
        }
        if (VerifyUtil.isEmpty(replicationGroupMoIds)) {
            return;
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String strUpdateSql = "UPDATE ti_replicationgroup SET SPEEDLEVEL=? where MOID in (:moids)";
            session.beginTransaction();
            NativeQuery updateQuery = session.createSQLQuery(strUpdateSql);
            updateQuery.setInteger(0, speedLevel.getValue());
            updateQuery.setParameterList("moids", replicationGroupMoIds);
            updateQuery.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("update ti_replicationgroup speedlevel error " + ((Object)replicationGroupMoIds).toString() + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    protected List<ReplicationPair> getPairsByLun(List<String> lunIdList, String devSn) {
        if (VerifyUtil.isEmpty(lunIdList)) {
            logger.error((Object)"lunIdlist is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        StringBuilder lunIds = new StringBuilder();
        for (String lunId : lunIdList) {
            lunIds.append(lunId);
            lunIds.append(";");
        }
        Site site = this.getSiteByDeviceSN(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"getPairsByLun error, site is null, deviceSN:%s", new Object[]{devSn});
            return null;
        }
        lunIds.replace(lunIds.length() - 1, lunIds.length(), "");
        if (1 == site.getSiteType()) {
            RestClient client = SiteUtil.initClient((Site)site);
            try {
                HashMap<String, Object> uriVariabels = new HashMap<String, Object>();
                uriVariabels.put("devSn", devSn);
                uriVariabels.put("lunIds", lunIds.toString());
                uriVariabels.put("isFromDevice", true);
                List pairs = client.getForObjects("/ws/storages/{devSn}/action/getReplicationPairBySrcLunIds?lunIds={lunIds}&isFromDevice={isFromDevice}", uriVariabels, ReplicationPair.class);
                return this.filterValidStatus(pairs);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("getPairsByLun from remote site LegoCheckedException.errorCode:" + e.getErrorCode() + ", lunIds:" + lunIds + ", devSn:" + devSn));
                throw new LegoCheckedException(1073948191L, (Throwable)e);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"getPairsByLun from remote site Exception", (long)1073948191L, null, (Log)logger);
                return null;
            }
        }
        logger.debug((Object)"devSn: %s lunIds: %s.", new Object[]{devSn, lunIds});
        return this.queryValidReplicationPairsBy(devSn, lunIdList, true);
    }
}

