/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.protection.checker.manager.AbRateConfigBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:0##3_1##5_1")
public class RateConfigByPosiServiceImpl
extends AbRateConfigBaseService
implements IRateConfigService {
    private static final Log logger = LogFactory.getInstance(RateConfigByPosiServiceImpl.class);

    public void modifyRate(DmEnumDefine.SpeedLevelE speedLevel, ProtectGroup pg, int protectionLocation) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"pg or protectionLocation is empty");
            throw new LegoCheckedException(1073947393L);
        }
        int times1 = 0;
        while (true) {
            if (times1 >= 3) {
                AlarmReporter.sendAlarm((long)52625438L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{pg.getUuid(), pg.getName()});
                break;
            }
            try {
                this.syncRateByReplicationPair(speedLevel, pg);
                AlarmReporter.restoreAlarm((long)52625438L, (String[])new String[]{pg.getUuid(), pg.getName()});
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"cannot alter ArrayRate..., pgName :%s,error Is %s.", new Object[]{pg.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                ++times1;
                CommonUtil.sleep((long)60000L);
                continue;
            }
            break;
        }
    }

    private List<ReplicationPair> getPair(ProtectGroup pg, String devSn) {
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : pg.getPolist()) {
            protectObjects.add(protectObject);
        }
        List<ProtectObjectStorageInfo> allStorageInfo = this.getAllStorageInfo(protectObjects);
        HashSet<String> lunIdSet = new HashSet<String>();
        for (ProtectObjectStorageInfo posi : allStorageInfo) {
            lunIdSet.add(posi.getResourceId());
        }
        ArrayList<String> lunIdList = new ArrayList<String>();
        lunIdList.addAll(lunIdSet);
        List<ReplicationPair> pairs = this.getPairsByLun(lunIdList, devSn);
        return pairs;
    }

    private String getDevSn(ProtectGroup pg) {
        Set polist = pg.getPolist();
        Iterator iterator = polist.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        ProtectObject po = (ProtectObject)iterator.next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        Iterator usedStorageIterator = usedStorageResourceSet.iterator();
        if (!usedStorageIterator.hasNext()) {
            return "";
        }
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)usedStorageIterator.next();
        logger.debug((Object)"getDevSn end. providerSN:%s.", new Object[]{storageInfo.getResourceProviderSN()});
        return storageInfo.getResourceProviderSN();
    }

    private void syncRateByReplicationPair(DmEnumDefine.SpeedLevelE speedLevel, ProtectGroup pg) {
        String devSn = this.getDevSn(pg);
        List<ReplicationPair> pairs = this.getPair(pg, devSn);
        if (VerifyUtil.isEmpty(pairs)) {
            logger.warn((Object)"pairs is empty. devSn:%s", new Object[]{devSn});
            throw new LegoCheckedException(2117645L);
        }
        for (ReplicationPair replicationPair : pairs) {
            boolean isCg;
            String pairId;
            if (replicationPair.getReplicationMode().intValue() != XveEnumDefinePParent.RM_MODEL_E.RM_MODEL_SYNC.getValue()) continue;
            String consistentGroupId = replicationPair.getConsistentGroupId();
            if (null != consistentGroupId && !"--".equals(consistentGroupId)) {
                pairId = consistentGroupId;
                isCg = true;
            } else {
                pairId = replicationPair.getReplicationId();
                isCg = false;
            }
            this.changeSyncRateByPosi(speedLevel, devSn, pairId, isCg, replicationPair);
        }
    }

    private void changeSyncRateByPosi(DmEnumDefine.SpeedLevelE speedLevel, String devSn, String pairId, boolean isCg, ReplicationPair replicationPair) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (drResource == null) {
            logger.error((Object)"drResource is null");
            throw new LegoCheckedException(2117645L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (site == null) {
            logger.error((Object)"site is null");
            throw new LegoCheckedException(2117645L);
        }
        if (site.getSiteType() == 1) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("replicationId", pairId);
            params.put("devSn", devSn);
            params.put("isConsistentGroup", isCg);
            JSONObject json = new JSONObject();
            json.put((Object)"SPEED", (Object)speedLevel.getValue());
            String url = "/ws/replications/{replicationId}?devSn={devSn}&isConsistentGroup={isConsistentGroup}";
            RestClient restClient = SiteUtil.initClient((Site)site);
            restClient.put(url, json.toString(), params);
        } else {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            proxy.changeRate(devSn, pairId, isCg, speedLevel);
            if (!isCg) {
                this.alterAndSaveSpeedLevel(replicationPair.getRepTgtLuns(), speedLevel);
            } else {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("replicationId", pairId);
                props.put("srcDevSN", devSn);
                List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationGroup.class, props);
                this.alterAndSaveCGSpeedLevel(groups, speedLevel);
            }
        }
    }
}

